/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml;

import java.util.HashMap;
import java.util.Map;
import org.cytoscape.io.internal.read.xgmml.Handler;
import org.cytoscape.io.internal.read.xgmml.ParseState;
import org.cytoscape.io.internal.read.xgmml.SAXState;
import org.cytoscape.io.internal.read.xgmml.handler.AttributeValueUtil;
import org.cytoscape.io.internal.read.xgmml.handler.HandleEdge;
import org.cytoscape.io.internal.read.xgmml.handler.HandleEdgeAttribute;
import org.cytoscape.io.internal.read.xgmml.handler.HandleEdgeGraphics;
import org.cytoscape.io.internal.read.xgmml.handler.HandleEdgeHandle;
import org.cytoscape.io.internal.read.xgmml.handler.HandleEdgeHandleDone;
import org.cytoscape.io.internal.read.xgmml.handler.HandleEdgeHandleList;
import org.cytoscape.io.internal.read.xgmml.handler.HandleGraph;
import org.cytoscape.io.internal.read.xgmml.handler.HandleGraphAttribute;
import org.cytoscape.io.internal.read.xgmml.handler.HandleGraphDone;
import org.cytoscape.io.internal.read.xgmml.handler.HandleGraphGraphics;
import org.cytoscape.io.internal.read.xgmml.handler.HandleListAttribute;
import org.cytoscape.io.internal.read.xgmml.handler.HandleListAttributeDone;
import org.cytoscape.io.internal.read.xgmml.handler.HandleNode;
import org.cytoscape.io.internal.read.xgmml.handler.HandleNodeAttribute;
import org.cytoscape.io.internal.read.xgmml.handler.HandleNodeGraph;
import org.cytoscape.io.internal.read.xgmml.handler.HandleNodeGraphDone;
import org.cytoscape.io.internal.read.xgmml.handler.HandleNodeGraphics;
import org.cytoscape.io.internal.read.xgmml.handler.HandleRDF;
import org.cytoscape.io.internal.read.xgmml.handler.HandleRDFDate;
import org.cytoscape.io.internal.read.xgmml.handler.HandleRDFDescription;
import org.cytoscape.io.internal.read.xgmml.handler.HandleRDFFormat;
import org.cytoscape.io.internal.read.xgmml.handler.HandleRDFIdentifier;
import org.cytoscape.io.internal.read.xgmml.handler.HandleRDFSource;
import org.cytoscape.io.internal.read.xgmml.handler.HandleRDFTitle;
import org.cytoscape.io.internal.read.xgmml.handler.HandleRDFType;
import org.cytoscape.io.internal.read.xgmml.handler.HandleViewEdge;
import org.cytoscape.io.internal.read.xgmml.handler.HandleViewEdgeGraphics;
import org.cytoscape.io.internal.read.xgmml.handler.HandleViewGraph;
import org.cytoscape.io.internal.read.xgmml.handler.HandleViewGraphGraphics;
import org.cytoscape.io.internal.read.xgmml.handler.HandleViewLockedVisualPropAttribute;
import org.cytoscape.io.internal.read.xgmml.handler.HandleViewNode;
import org.cytoscape.io.internal.read.xgmml.handler.HandleViewNodeGraphics;
import org.cytoscape.io.internal.read.xgmml.handler.ReadDataManager;

public class HandlerFactory {
    private Map<ParseState, Map<String, SAXState>> startParseMap;
    private Map<ParseState, Map<String, SAXState>> endParseMap;
    private ReadDataManager manager;
    private AttributeValueUtil attributeValueUtil;

    public HandlerFactory(ReadDataManager manager) {
        this.manager = manager;
        this.attributeValueUtil = new AttributeValueUtil(manager);
    }

    public void init() {
        this.startParseMap = new HashMap<ParseState, Map<String, SAXState>>();
        this.endParseMap = new HashMap<ParseState, Map<String, SAXState>>();
        Object[][] startParseTable = this.createStartParseTable();
        Object[][] endParseTable = this.createEndParseTable();
        this.buildMap(startParseTable, this.startParseMap);
        this.buildMap(endParseTable, this.endParseMap);
    }

    private Object[][] createStartParseTable() {
        if (this.manager.isViewFormat()) {
            Object[][] tbl = new Object[][]{{ParseState.NONE, "graph", ParseState.GRAPH, new HandleViewGraph()}, {ParseState.GRAPH, "graphics", ParseState.NET_GRAPHICS, new HandleViewGraphGraphics()}, {ParseState.NET_GRAPHICS, "att", ParseState.NET_GRAPHICS, new HandleViewGraphGraphics()}, {ParseState.GRAPH, "node", ParseState.NODE, new HandleViewNode()}, {ParseState.NODE, "graphics", ParseState.NODE_GRAPHICS, new HandleViewNodeGraphics()}, {ParseState.NODE_GRAPHICS, "att", ParseState.NODE_GRAPHICS, new HandleViewNodeGraphics()}, {ParseState.GRAPH, "edge", ParseState.EDGE, new HandleViewEdge()}, {ParseState.EDGE, "graphics", ParseState.EDGE_GRAPHICS, new HandleViewEdgeGraphics()}, {ParseState.EDGE_GRAPHICS, "att", ParseState.EDGE_GRAPHICS, new HandleViewEdgeGraphics()}, {ParseState.LOCKED_VISUAL_PROP_ATT, "att", ParseState.LOCKED_VISUAL_PROP_ATT, new HandleViewLockedVisualPropAttribute()}};
            return tbl;
        }
        Object[][] tbl = new Object[][]{{ParseState.NONE, "graph", ParseState.GRAPH, new HandleGraph()}, {ParseState.GRAPH, "graphics", ParseState.NET_GRAPHICS, new HandleGraphGraphics()}, {ParseState.NET_GRAPHICS, "att", ParseState.NET_GRAPHICS, new HandleGraphGraphics()}, {ParseState.GRAPH, "att", ParseState.NET_ATT, new HandleGraphAttribute()}, {ParseState.NET_ATT, "rdf", ParseState.RDF, null}, {ParseState.RDF, "description", ParseState.RDF_DESC, new HandleRDF()}, {ParseState.RDF_DESC, "type", ParseState.RDF_DESC, null}, {ParseState.RDF_DESC, "description", ParseState.RDF_DESC, null}, {ParseState.RDF_DESC, "identifier", ParseState.RDF_DESC, null}, {ParseState.RDF_DESC, "date", ParseState.RDF_DESC, null}, {ParseState.RDF_DESC, "title", ParseState.RDF_DESC, null}, {ParseState.RDF_DESC, "source", ParseState.RDF_DESC, null}, {ParseState.RDF_DESC, "format", ParseState.RDF_DESC, null}, {ParseState.NET_ATT, "graph", ParseState.GRAPH, new HandleGraph()}, {ParseState.GRAPH, "node", ParseState.NODE, new HandleNode()}, {ParseState.NODE_GRAPH, "node", ParseState.NODE, new HandleNode()}, {ParseState.NODE, "graphics", ParseState.NODE_GRAPHICS, new HandleNodeGraphics()}, {ParseState.NODE, "att", ParseState.NODE_ATT, new HandleNodeAttribute()}, {ParseState.NODE_ATT, "graph", ParseState.NODE_GRAPH, new HandleNodeGraph()}, {ParseState.NODE_GRAPH, "att", ParseState.NET_ATT, new HandleGraphAttribute()}, {ParseState.NODE_GRAPHICS, "att", ParseState.NODE_GRAPHICS, new HandleNodeGraphics()}, {ParseState.GRAPH, "edge", ParseState.EDGE, new HandleEdge()}, {ParseState.NODE_GRAPH, "edge", ParseState.EDGE, new HandleEdge()}, {ParseState.EDGE, "att", ParseState.EDGE_ATT, new HandleEdgeAttribute()}, {ParseState.EDGE, "graphics", ParseState.EDGE_GRAPHICS, new HandleEdgeGraphics()}, {ParseState.EDGE_GRAPHICS, "att", ParseState.EDGE_GRAPHICS, new HandleEdgeGraphics()}, {ParseState.EDGE_BEND, "att", ParseState.EDGE_HANDLE, new HandleEdgeHandle()}, {ParseState.EDGE_HANDLE, "att", ParseState.EDGE_HANDLE, new HandleEdgeHandle()}, {ParseState.LIST_ATT, "att", ParseState.LIST_ELEMENT, new HandleListAttribute()}, {ParseState.LIST_ELEMENT, "att", ParseState.LIST_ELEMENT, new HandleListAttribute()}};
        return tbl;
    }

    private Object[][] createEndParseTable() {
        if (this.manager.isViewFormat()) {
            Object[][] tbl = new Object[][]{{ParseState.LOCKED_VISUAL_PROP_ATT, "att", ParseState.NONE, null}, {ParseState.GRAPH, "graph", ParseState.NONE, null}};
            return tbl;
        }
        Object[][] tbl = new Object[][]{{ParseState.RDF_DESC, "type", ParseState.RDF_DESC, new HandleRDFType()}, {ParseState.RDF_DESC, "description", ParseState.RDF_DESC, new HandleRDFDescription()}, {ParseState.RDF_DESC, "identifier", ParseState.RDF_DESC, new HandleRDFIdentifier()}, {ParseState.RDF_DESC, "date", ParseState.RDF_DESC, new HandleRDFDate()}, {ParseState.RDF_DESC, "title", ParseState.RDF_DESC, new HandleRDFTitle()}, {ParseState.RDF_DESC, "source", ParseState.RDF_DESC, new HandleRDFSource()}, {ParseState.RDF_DESC, "format", ParseState.RDF_DESC, new HandleRDFFormat()}, {ParseState.EDGE_HANDLE, "att", ParseState.EDGE_BEND, new HandleEdgeHandleDone()}, {ParseState.EDGE_BEND, "att", ParseState.EDGE_BEND, new HandleEdgeHandleList()}, {ParseState.NODE_GRAPH, "graph", ParseState.NODE, new HandleNodeGraphDone()}, {ParseState.GRAPH, "graph", ParseState.NONE, new HandleGraphDone()}, {ParseState.LIST_ATT, "att", ParseState.NONE, new HandleListAttributeDone()}};
        return tbl;
    }

    private void buildMap(Object[][] table, Map<ParseState, Map<String, SAXState>> map) {
        int size = table.length;
        Map<String, SAXState> internalMap = null;
        for (int i = 0; i < size; ++i) {
            SAXState st = new SAXState((ParseState)((Object)table[i][0]), (String)table[i][1], (ParseState)((Object)table[i][2]), (Handler)table[i][3]);
            if (st.getHandler() != null) {
                st.getHandler().setManager(this.manager);
                st.getHandler().setAttributeValueUtil(this.attributeValueUtil);
            }
            if ((internalMap = map.get((Object)st.getStartState())) == null) {
                internalMap = new HashMap<String, SAXState>();
            }
            internalMap.put(st.getTag(), st);
            map.put(st.getStartState(), internalMap);
        }
    }

    public SAXState getStartHandler(ParseState currentState, String tag) {
        if (this.startParseMap.get((Object)currentState) != null) {
            return this.startParseMap.get((Object)currentState).get(tag);
        }
        return null;
    }

    public SAXState getEndHandler(ParseState currentState, String tag) {
        if (this.endParseMap.get((Object)currentState) != null) {
            return this.endParseMap.get((Object)currentState).get(tag);
        }
        return null;
    }
}

