/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.vizmap;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import org.cytoscape.io.BasicCyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VizmapXMLFileFilter
extends BasicCyFileFilter {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public VizmapXMLFileFilter(Set<String> extensions, Set<String> contentTypes, String description, DataCategory category, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
    }

    public VizmapXMLFileFilter(String[] extensions, String[] contentTypes, String description, DataCategory category, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
    }

    public boolean accepts(InputStream stream, DataCategory category) {
        if (category != this.category) {
            return false;
        }
        String header = this.getHeader(stream, 20);
        return header.contains("<vizmap");
    }

    public boolean accepts(URI uri, DataCategory category) {
        boolean bl;
        block8: {
            InputStream is = uri.toURL().openStream();
            try {
                bl = this.accepts(is, category);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Error while opening stream: " + uri, (Throwable)e);
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }
}

