/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.transformer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.filter.TransformerManager;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.filter.model.SubFilterTransformer;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.io.internal.util.FilterIO;
import org.cytoscape.io.read.CyTransformerReader;

public class CyTransformerReaderImpl
implements CyTransformerReader {
    private JsonFactory factory = new JsonFactory();
    private TransformerManager transformerManager;

    public CyTransformerReaderImpl() {
        this.factory.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
    }

    public void registerTransformerManager(TransformerManager transformerManager, Map<String, String> properties) {
        this.transformerManager = transformerManager;
    }

    public void unregisterTransformerManager(TransformerManager transformerManager, Map<String, String> properties) {
        this.transformerManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedTransformer<?, ?>[] read(InputStream stream) throws IOException {
        try (JsonParser parser = this.factory.createParser(stream);){
            this.assertNextToken(parser, JsonToken.START_ARRAY);
            ArrayList namedTransformers = new ArrayList();
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                Transformer<?, ?> transformer;
                this.assertEquals(JsonToken.START_OBJECT, parser.getCurrentToken());
                this.assertField(parser, "name");
                String name = parser.nextTextValue();
                this.assertField(parser, "transformers");
                this.assertNextToken(parser, JsonToken.START_ARRAY);
                ArrayList transformers = new ArrayList();
                while ((transformer = this.readTransformer(parser)) != null) {
                    transformers.add(transformer);
                }
                this.assertNextToken(parser, JsonToken.END_OBJECT);
                namedTransformers.add(FilterIO.createNamedTransformer(name, transformers));
            }
            NamedTransformer[] namedTransformerArray = namedTransformers.toArray(new NamedTransformer[namedTransformers.size()]);
            return namedTransformerArray;
        }
    }

    private Transformer<?, ?> readTransformer(JsonParser parser) throws IOException {
        JsonToken firstToken = parser.nextToken();
        if (firstToken == JsonToken.END_ARRAY) {
            return null;
        }
        if (firstToken != JsonToken.START_OBJECT) {
            throw new IOException("Expected: " + JsonToken.START_OBJECT + ". Got: " + firstToken);
        }
        this.assertField(parser, "id");
        String id = parser.nextTextValue();
        this.assertField(parser, "parameters");
        this.assertNextToken(parser, JsonToken.START_OBJECT);
        Transformer transformer = this.transformerManager.createTransformer(id);
        if (transformer == null && !id.contains(".")) {
            transformer = this.transformerManager.createTransformer("org.cytoscape." + id);
        }
        if (transformer == null) {
            throw new IOException("Unrecognized id: '" + id + "'");
        }
        Map<String, Object> parameters = this.readParameters(parser);
        this.assertEquals(JsonToken.END_OBJECT, parser.getCurrentToken());
        FilterIO.applyParameters(parameters, transformer);
        if (transformer instanceof CompositeFilter) {
            this.readCompositeFilter(parser, (CompositeFilter)transformer);
        } else if (transformer instanceof SubFilterTransformer) {
            SubFilterTransformer sft = (SubFilterTransformer)transformer;
            this.readCompositeFilter(parser, sft.getCompositeFilter());
        } else {
            this.assertNextToken(parser, JsonToken.END_OBJECT);
        }
        return transformer;
    }

    private void readCompositeFilter(JsonParser parser, CompositeFilter composite) throws IOException {
        Filter filter;
        JsonToken firstToken = parser.nextToken();
        if (firstToken == JsonToken.END_OBJECT) {
            return;
        }
        if (firstToken != JsonToken.FIELD_NAME) {
            throw new IOException("Expected: " + JsonToken.FIELD_NAME + ". Got: " + firstToken);
        }
        this.assertEquals("transformers", parser.getCurrentName());
        this.assertEquals(JsonToken.START_ARRAY, parser.nextToken());
        while ((filter = (Filter)this.readTransformer(parser)) != null) {
            composite.append(filter);
        }
        this.assertEquals(JsonToken.END_ARRAY, parser.getCurrentToken());
        this.assertNextToken(parser, JsonToken.END_OBJECT);
    }

    private Map<String, Object> readParameters(JsonParser parser) throws IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            this.assertEquals(JsonToken.FIELD_NAME, parser.getCurrentToken());
            String name = parser.getCurrentName();
            parser.nextToken();
            Object value = this.readCurrentValue(parser);
            parameters.put(name, value);
        }
        return parameters;
    }

    private Object readCurrentValue(JsonParser parser) throws IOException {
        switch (parser.getCurrentToken()) {
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return parser.getBooleanValue();
            }
            case VALUE_NUMBER_FLOAT: {
                return parser.getDoubleValue();
            }
            case VALUE_NUMBER_INT: {
                return parser.getLongValue();
            }
            case VALUE_STRING: {
                return parser.getText();
            }
            case START_ARRAY: {
                return this.readArray(parser);
            }
        }
        return null;
    }

    private List<Object> readArray(JsonParser parser) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            list.add(this.readCurrentValue(parser));
        }
        return list;
    }

    private void assertField(JsonParser parser, String name) throws IOException {
        this.assertNextToken(parser, JsonToken.FIELD_NAME);
        this.assertEquals(name, parser.getCurrentName());
    }

    private void assertEquals(Object expected, Object actual) throws IOException {
        if (expected == null) {
            if (actual == null) {
                return;
            }
            throw new IOException("Expected null");
        }
        if (!expected.equals(actual)) {
            throw new IOException("Expected: " + expected + ". Got: " + actual);
        }
    }

    void assertNextToken(JsonParser parser, JsonToken token) throws IOException {
        if (parser.nextToken() != token) {
            throw new IOException("Expected: " + token + ". Got: " + parser.getCurrentToken());
        }
    }
}

