/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.sif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Map;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.internal.read.sif.Interaction;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SIFNetworkReader
extends AbstractCyNetworkReader {
    private static final String TAB = "\t";
    private String delimiter = " ";
    private final StringBuilder edgeNameBuilder = new StringBuilder();
    private TaskMonitor parentTaskMonitor;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public SIFNetworkReader(InputStream is, CyServiceRegistrar serviceRegistrar) {
        super(is, (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class), (CyNetworkFactory)serviceRegistrar.getService(CyNetworkFactory.class), (CyNetworkManager)serviceRegistrar.getService(CyNetworkManager.class), (CyRootNetworkManager)serviceRegistrar.getService(CyRootNetworkManager.class));
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws IOException {
        tm.setTitle("Read SIF File");
        try {
            this.readInput(tm);
        }
        finally {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (Exception e) {
                    logger.warn("Cannot close SIF input stream", (Throwable)e);
                }
            }
        }
    }

    private void readInput(TaskMonitor tm) throws IOException {
        tm.setProgress(0.0);
        tm.setStatusMessage("Preparing to read...");
        this.parentTaskMonitor = tm;
        CharsetDecoder charset = Charset.forName("UTF-8").newDecoder();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream, charset), 131072);
        String line = null;
        CyRootNetwork root = this.getRootNetwork();
        CySubNetwork newNetwork = root != null ? root.addSubNetwork() : (CySubNetwork)this.cyNetworkFactory.createNetwork();
        tm.setProgress(0.1);
        tm.setStatusMessage("Analyzing SIF file...");
        ArrayList<String> allLines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            if (this.cancelled) {
                br.close();
                return;
            }
            if (!TAB.equals(this.delimiter) && line.contains(TAB)) {
                this.delimiter = TAB;
            }
            if (line.trim().isEmpty()) continue;
            allLines.add(line);
        }
        tm.setProgress(0.2);
        tm.setStatusMessage("Processing the interactions...");
        int numInteractionsRead = 0;
        Map nMap = this.getNodeMap();
        int total = allLines.size();
        for (int i = 0; i < total; ++i) {
            if (this.cancelled) {
                nMap.clear();
                br.close();
                return;
            }
            line = allLines.set(i, null);
            try {
                Interaction itr = new Interaction(line, this.delimiter);
                this.createEdge(itr, newNetwork, nMap);
            }
            catch (Exception e) {
                logger.warn("Invalid SIF line: " + line, (Throwable)e);
                continue;
            }
            if (++numInteractionsRead % 1000 != 0) continue;
            tm.setStatusMessage("Processed " + numInteractionsRead + " interactions so far.");
        }
        br.close();
        tm.setStatusMessage("Processed " + numInteractionsRead + " interactions in total.");
        nMap.clear();
        nMap = null;
        this.networks = new CyNetwork[]{newNetwork};
        tm.setProgress(1.0);
    }

    private void createEdge(Interaction itr, CySubNetwork subNetwork, Map<Object, CyNode> nMap) {
        CyNode sourceNode = nMap.get(itr.getSource());
        if (sourceNode == null) {
            sourceNode = subNetwork.addNode();
            subNetwork.getRow((CyIdentifiable)sourceNode).set("name", (Object)itr.getSource());
            nMap.put(itr.getSource(), subNetwork.getRootNetwork().getNode(sourceNode.getSUID().longValue()));
        }
        for (String target : itr.getTargets()) {
            CyNode targetNode = nMap.get(target);
            if (targetNode == null) {
                targetNode = subNetwork.addNode();
                subNetwork.getRow((CyIdentifiable)targetNode).set("name", (Object)target);
                nMap.put(target, subNetwork.getRootNetwork().getNode(targetNode.getSUID().longValue()));
            }
            if (!subNetwork.containsNode(sourceNode)) {
                subNetwork.addNode(sourceNode);
            }
            if (!subNetwork.containsNode(targetNode)) {
                subNetwork.addNode(targetNode);
            }
            CyEdge edge = subNetwork.addEdge(sourceNode, targetNode, true);
            subNetwork.getRow((CyIdentifiable)edge).set("name", (Object)this.getEdgeName(itr, target));
            subNetwork.getRow((CyIdentifiable)edge).set("interaction", (Object)itr.getType());
        }
    }

    private String getEdgeName(Interaction itr, String target) {
        this.edgeNameBuilder.delete(0, this.edgeNameBuilder.length());
        this.edgeNameBuilder.append(itr.getSource());
        this.edgeNameBuilder.append(" (");
        this.edgeNameBuilder.append(itr.getType());
        this.edgeNameBuilder.append(") ");
        this.edgeNameBuilder.append(target);
        return this.edgeNameBuilder.toString();
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        CyNetworkView view = this.getNetworkViewFactory().createNetworkView(network);
        CyLayoutAlgorithmManager layoutMgr = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
        CyLayoutAlgorithm layout = layoutMgr.getDefaultLayout();
        String attribute = layoutMgr.getLayoutAttribute(layout, view);
        TaskIterator itr = layout.createTaskIterator(view, layout.getDefaultLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, attribute);
        Task nextTask = itr.next();
        try {
            nextTask.run(this.parentTaskMonitor);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not finish layout", e);
        }
        return view;
    }
}

