/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.sif;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

final class Interaction {
    private String source;
    private List<String> targets;
    private String interactionType;

    Interaction(String rawText, String delimiter) {
        StringTokenizer strtok = new StringTokenizer(rawText, delimiter);
        int counter = 0;
        this.targets = new ArrayList<String>();
        while (strtok.hasMoreTokens()) {
            if (counter == 0) {
                this.source = strtok.nextToken().trim();
            } else if (counter == 1) {
                this.interactionType = strtok.nextToken().trim();
            } else {
                this.targets.add(strtok.nextToken().trim());
            }
            ++counter;
        }
    }

    final String getSource() {
        return this.source;
    }

    String getType() {
        return this.interactionType;
    }

    List<String> getTargets() {
        return this.targets;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.interactionType);
        sb.append("::");
        sb.append(this.source);
        sb.append("::");
        int targetSize = this.targets.size();
        for (int i = 0; i < targetSize; ++i) {
            sb.append(this.targets.get(i));
            if (i >= targetSize - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

