/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.session;

import java.net.URI;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.cytoscape.io.BasicCyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFileFilter
extends BasicCyFileFilter {
    private static final String DEFAULT_VERSION = "2.0.0";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private String requiredVersion;

    public SessionFileFilter(Set<String> extensions, Set<String> contentTypes, String description, DataCategory category, String requiredVersion, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
        this.requiredVersion = requiredVersion;
    }

    public SessionFileFilter(String[] extensions, String[] contentTypes, String description, DataCategory category, String requiredVersion, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
        this.requiredVersion = requiredVersion;
    }

    public boolean accepts(URI uri, DataCategory category) {
        if (super.accepts(uri, category)) {
            String version = this.extractVersion(uri);
            return this.accepts(version);
        }
        return false;
    }

    protected String extractVersion(URI uri) {
        String version = "";
        try (ZipInputStream zis = new ZipInputStream(uri.toURL().openStream());){
            ZipEntry zen = null;
            String entryName = null;
            while ((zen = zis.getNextEntry()) != null) {
                entryName = zen.getName();
                try {
                    if (entryName.contains("apps/") || !entryName.endsWith(".version")) continue;
                    version = this.parseVersion(entryName);
                    logger.debug("CYS version: " + version);
                    break;
                }
                catch (Exception e) {
                    logger.warn("Failed reading session entry: " + entryName, (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            logger.error("Failed reading session file: " + uri.getPath(), (Throwable)ex);
        }
        return version;
    }

    protected String parseVersion(String entryName) {
        return entryName.replaceAll("[^/]*/", "").replace(".version", "");
    }

    protected boolean accepts(String version) {
        boolean accepts = true;
        if (version == null || version.trim().isEmpty()) {
            version = DEFAULT_VERSION;
        }
        int majorVer = 0;
        int minorVer = 0;
        int revision = 0;
        try {
            String[] verArr = version.split("\\.");
            majorVer = Integer.parseInt(verArr[0]);
            if (verArr.length > 1) {
                minorVer = Integer.parseInt(verArr[1]);
            }
            if (verArr.length > 2) {
                revision = Integer.parseInt(verArr[2]);
            }
        }
        catch (Exception ex) {
            logger.warn("Cannot parse the session file's version \"" + version + "\"", (Throwable)ex);
        }
        if (this.requiredVersion != null) {
            String[] reqArr = this.requiredVersion.split("\\.");
            int reqMajorVer = 0;
            int reqMinorVer = 0;
            int reqRevision = 0;
            try {
                reqMajorVer = Integer.parseInt(reqArr[0]);
                if (reqMajorVer != majorVer) {
                    accepts = false;
                } else {
                    if (reqArr.length > 1) {
                        reqMinorVer = Integer.parseInt(reqArr[1]);
                    }
                    if (reqMinorVer > minorVer) {
                        accepts = false;
                    } else if (reqMinorVer == minorVer) {
                        if (reqArr.length > 2) {
                            reqRevision = Integer.parseInt(reqArr[2]);
                        }
                        if (reqRevision > revision) {
                            accepts = false;
                        }
                    }
                }
            }
            catch (Exception ex) {
                logger.warn("Cannot parse the required version \"" + this.requiredVersion + "\"", (Throwable)ex);
            }
        }
        return accepts;
    }
}

