/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.nnf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CyNetworkNaming;

public class NNFParser {
    private static final String HAS_NESTED_NETWORK_ATTRIBUTE = "has_nested_network";
    private String[] parts;
    private int length;
    private final Set<CyNetwork> networks;
    private CyNetwork overviewwork;
    private Map<String, CyNetwork> networksByName;
    private final CyRootNetwork rootNetwork;
    private final Map<Object, CyNode> nMap;
    private final CyNetworkNaming namingUtil;

    public NNFParser(CyRootNetwork rootNetwork, CyNetworkFactory cyNetworkFactory, Map<Object, CyNode> nMap, CyServiceRegistrar serviceRegistrar) {
        this.namingUtil = (CyNetworkNaming)serviceRegistrar.getService(CyNetworkNaming.class);
        this.nMap = nMap;
        this.networksByName = new HashMap<String, CyNetwork>();
        this.networks = new LinkedHashSet<CyNetwork>();
        if (rootNetwork != null) {
            this.rootNetwork = rootNetwork;
            this.overviewwork = this.rootNetwork.addSubNetwork();
        } else {
            this.overviewwork = cyNetworkFactory.createNetwork();
            this.rootNetwork = ((CySubNetwork)this.overviewwork).getRootNetwork();
        }
        this.networks.add(this.overviewwork);
    }

    private CyNetwork getNetworkByName(String name) {
        return this.networksByName.get(name);
    }

    public boolean parse(String line) {
        this.parts = NNFParser.splitLine(line);
        this.length = this.parts.length;
        String originalName = this.parts[0];
        CyNetwork network = this.getNetworkByName(originalName);
        if (network == null) {
            network = this.rootNetwork.addSubNetwork();
            String actualName = this.namingUtil.getSuggestedNetworkTitle(originalName);
            network.getRow((CyIdentifiable)network).set("name", (Object)actualName);
            this.networksByName.put(originalName, network);
            this.networks.add(network);
            CyNode parent = this.getNodeByName(originalName);
            if (parent != null) {
                this.setNestedNetwork(network, parent, network);
            }
            if ((parent = this.getNodefromOverview(originalName)) != null) {
                this.setNestedNetwork(network, parent, network);
            }
        }
        if (this.length == 2) {
            CyNode node;
            if (this.nMap.get(this.parts[1]) == null) {
                node = network.addNode();
                this.nMap.put(this.parts[1], this.rootNetwork.getNode(node.getSUID().longValue()));
            } else {
                node = this.nMap.get(this.parts[1]);
                CySubNetwork subnet = (CySubNetwork)network;
                subnet.addNode(node);
            }
            network.getRow((CyIdentifiable)node).set("name", (Object)this.parts[1]);
            CyNetwork nestedNetwork = this.getNetworkByName(this.parts[1]);
            if (nestedNetwork != null) {
                this.setNestedNetwork(network, node, nestedNetwork);
            }
        } else if (this.length == 4) {
            CyNode source = null;
            Collection matchingRows = network.getDefaultNodeTable().getMatchingRows("name", (Object)this.parts[1]);
            if (!matchingRows.isEmpty()) {
                CyRow row = (CyRow)matchingRows.iterator().next();
                Long suid = (Long)row.get("SUID", Long.class);
                if (suid != null) {
                    source = network.getNode(suid.longValue());
                }
            } else {
                CyNode newNode;
                if (this.nMap.get(this.parts[1]) == null) {
                    source = network.addNode();
                    newNode = this.rootNetwork.getNode(source.getSUID().longValue());
                    this.nMap.put(this.parts[1], newNode);
                } else {
                    newNode = this.nMap.get(this.parts[1]);
                    CySubNetwork subNet = (CySubNetwork)network;
                    subNet.addNode(newNode);
                    source = network.getNode(newNode.getSUID().longValue());
                }
                network.getRow((CyIdentifiable)source).set("name", (Object)this.parts[1]);
            }
            CyNetwork nestedNetwork = this.networksByName.get(this.parts[1]);
            if (nestedNetwork != null) {
                this.setNestedNetwork(network, source, nestedNetwork);
            }
            CyNode target = null;
            Collection matchingRows2 = network.getDefaultNodeTable().getMatchingRows("name", (Object)this.parts[3]);
            if (!matchingRows2.isEmpty()) {
                CyRow row = (CyRow)matchingRows2.iterator().next();
                Long suid = (Long)row.get("SUID", Long.class);
                if (suid != null) {
                    target = network.getNode(suid.longValue());
                }
            } else {
                CyNode newNode;
                if (this.nMap.get(this.parts[3]) == null) {
                    target = network.addNode();
                    newNode = this.rootNetwork.getNode(target.getSUID().longValue());
                    this.nMap.put(this.parts[3], newNode);
                } else {
                    newNode = this.nMap.get(this.parts[3]);
                    CySubNetwork subNet = (CySubNetwork)network;
                    subNet.addNode(newNode);
                    target = network.getNode(newNode.getSUID().longValue());
                }
                network.getRow((CyIdentifiable)target).set("name", (Object)this.parts[3]);
            }
            nestedNetwork = this.networksByName.get(this.parts[3]);
            if (nestedNetwork != null) {
                this.setNestedNetwork(network, target, nestedNetwork);
            }
            CyEdge newEdge = network.addEdge(source, target, true);
            network.getRow((CyIdentifiable)newEdge).set("interaction", (Object)this.parts[2]);
            network.getRow((CyIdentifiable)newEdge).set("name", (Object)(this.parts[1] + " (" + this.parts[2] + ") " + this.parts[3]));
        } else {
            return false;
        }
        return true;
    }

    private void setNestedNetwork(CyNetwork sourceNetwork, CyNode node, CyNetwork targetNetwork) {
        boolean attributeExists;
        node.setNetworkPointer(targetNetwork);
        CyTable nodeTable = sourceNetwork.getDefaultNodeTable();
        boolean bl = attributeExists = nodeTable.getColumn(HAS_NESTED_NETWORK_ATTRIBUTE) != null;
        if (targetNetwork == null && attributeExists) {
            nodeTable.getRow((Object)node.getSUID()).set(HAS_NESTED_NETWORK_ATTRIBUTE, (Object)false);
        } else if (targetNetwork != null) {
            if (!attributeExists) {
                nodeTable.createColumn(HAS_NESTED_NETWORK_ATTRIBUTE, Boolean.class, false);
            }
            CyRow row = nodeTable.getRow((Object)node.getSUID());
            row.set(HAS_NESTED_NETWORK_ATTRIBUTE, (Object)true);
        }
    }

    private CyNode getNodeByName(String nodeName) {
        CyNode retNode = null;
        Iterator<String> it = this.networksByName.keySet().iterator();
        while (it.hasNext()) {
            CyRow row;
            Long suid;
            CyNetwork network = this.networksByName.get(it.next());
            Collection matchingRows = network.getDefaultNodeTable().getMatchingRows("name", (Object)nodeName);
            if (matchingRows.isEmpty() || (suid = (Long)(row = (CyRow)matchingRows.iterator().next()).get("SUID", Long.class)) == null) continue;
            return network.getNode(suid.longValue());
        }
        return retNode;
    }

    private CyNode getNodefromOverview(String nodeName) {
        Collection matchingRows = this.overviewwork.getDefaultNodeTable().getMatchingRows("name", (Object)nodeName);
        if (matchingRows.isEmpty()) {
            return null;
        }
        CyRow row = (CyRow)matchingRows.iterator().next();
        Long suid = (Long)row.get("SUID", Long.class);
        return this.overviewwork.getNode(suid.longValue());
    }

    public void setOverViewnetworkName(String desiredName) {
        String actualName = this.namingUtil.getSuggestedNetworkTitle(desiredName);
        this.overviewwork.getRow((CyIdentifiable)this.overviewwork).set("name", (Object)actualName);
        this.networksByName.put(desiredName, this.overviewwork);
    }

    public static String[] splitLine(String line) {
        ArrayList<String> parts = new ArrayList<String>();
        boolean escaped = false;
        StringBuilder part = null;
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (escaped) {
                escaped = false;
                if (part == null) {
                    part = new StringBuilder();
                }
                part.append(ch);
                continue;
            }
            if (ch == '\\') {
                escaped = true;
                continue;
            }
            if (ch == ' ' || ch == '\t') {
                if (part == null) continue;
                parts.add(part.toString());
                part = null;
                continue;
            }
            if (part == null) {
                part = new StringBuilder();
            }
            part.append(ch);
        }
        if (part != null) {
            parts.add(part.toString());
        }
        String[] array = new String[parts.size()];
        return parts.toArray(array);
    }

    protected Set<CyNetwork> getNetworks() {
        return this.networks;
    }
}

