/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.gml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.net.URI;
import java.util.Set;
import org.cytoscape.io.BasicCyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.internal.read.gml.GMLParser;
import org.cytoscape.io.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMLFileFilter
extends BasicCyFileFilter {
    private static final int DEFAULT_WORDS_TO_SAMPLE = 10;
    private StreamUtil streamUtil;

    public GMLFileFilter(Set<String> extensions, Set<String> contentTypes, String description, DataCategory category, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
        this.streamUtil = streamUtil;
    }

    public GMLFileFilter(String[] extensions, String[] contentTypes, String description, DataCategory category, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
        this.streamUtil = streamUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accepts(InputStream stream, DataCategory category) {
        if (!category.equals((Object)DataCategory.NETWORK)) {
            return false;
        }
        StreamTokenizer tokenizer = GMLParser.createTokenizer(stream);
        try {
            try {
                int wordCount = 0;
                int type = tokenizer.nextToken();
                String lastWord = null;
                while (type != -1 && wordCount < 10) {
                    if (type == -3 && "[".equals(tokenizer.sval) && "graph".equals(lastWord)) {
                        boolean bl = true;
                        return bl;
                    }
                    if (type == -3) {
                        lastWord = tokenizer.sval;
                        ++wordCount;
                    }
                    type = tokenizer.nextToken();
                }
                boolean bl = false;
                return bl;
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
            logger.error("Error parsing header", (Throwable)e);
            return false;
        }
    }

    public boolean accepts(URI uri, DataCategory category) {
        boolean bl;
        block9: {
            if (!category.equals((Object)DataCategory.NETWORK)) {
                return false;
            }
            InputStream is = this.streamUtil.getInputStream(uri.toURL());
            try {
                bl = this.accepts(is, category);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
                    logger.error("Error while reading header", (Throwable)e);
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }
}

