/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.cytoscape.cg.internal.editor.ImageList;
import org.cytoscape.cg.internal.ui.CustomGraphicsManagerDialog;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.util.CustomGraphicsBrowser;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.vizmap.gui.DefaultViewPanel;

public class ImageCustomGraphicsSelector
extends JPanel {
    private boolean firingActionEvent;
    private String actionCommand = "imageCustomGraphicsSelectorChanged";
    private ImageList graphicsList;
    private final CyServiceRegistrar serviceRegistrar;

    public ImageCustomGraphicsSelector(final CustomGraphicsBrowser browser, final CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView((Component)((Object)this.getGraphicsList()));
        JButton openImgMgrBtn = new JButton(new AbstractAction("Open Image Manager..."){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window owner = SwingUtilities.getWindowAncestor(ImageCustomGraphicsSelector.this);
                CustomGraphicsManager customGraphicsMgr = (CustomGraphicsManager)serviceRegistrar.getService(CustomGraphicsManager.class);
                CustomGraphicsManagerDialog dialog = new CustomGraphicsManagerDialog(owner, customGraphicsMgr, browser, serviceRegistrar);
                dialog.setVisible(true);
                ImageCustomGraphicsSelector.this.update(ImageCustomGraphicsSelector.this.getSelectedValue());
            }
        });
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{openImgMgrBtn});
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(scrollPane, -1, -1, Short.MAX_VALUE).addComponent(openImgMgrBtn, -2, -1, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(scrollPane, -1, -1, Short.MAX_VALUE).addComponent(openImgMgrBtn, -2, -1, -2));
        this.update((CyCustomGraphics)null);
    }

    public void update(CyCustomGraphics selectedValue) {
        CustomGraphicsManager customGraphicsMgr = (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class);
        Collection<CyCustomGraphics> newValues = customGraphicsMgr.getAllCustomGraphics();
        this.getGraphicsList().setListItems(newValues, selectedValue);
    }

    public CyCustomGraphics getSelectedValue() {
        return (CyCustomGraphics)this.getGraphicsList().getSelectedValue();
    }

    public void setSelectedValue(CyCustomGraphics value) {
        if (value != null) {
            this.getGraphicsList().setSelectedValue(value, true);
        } else {
            this.getGraphicsList().clearSelection();
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void setActionCommand(String aCommand) {
        this.actionCommand = aCommand;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            long mostRecentEventTime = EventQueue.getMostRecentEventTime();
            int modifiers = 0;
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            if (currentEvent instanceof InputEvent) {
                modifiers = ((InputEvent)currentEvent).getModifiersEx();
            } else if (currentEvent instanceof ActionEvent) {
                modifiers = ((ActionEvent)currentEvent).getModifiers();
            }
            try {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ActionListener.class) continue;
                    if (e == null) {
                        e = new ActionEvent(this, 1001, this.getActionCommand(), mostRecentEventTime, modifiers);
                    }
                    ((ActionListener)listeners[i + 1]).actionPerformed(e);
                }
            }
            finally {
                this.firingActionEvent = false;
            }
        }
    }

    private ImageList getGraphicsList() {
        if (this.graphicsList == null) {
            DefaultViewPanel defViewPanel = (DefaultViewPanel)this.serviceRegistrar.getService(DefaultViewPanel.class);
            this.graphicsList = new ImageList(defViewPanel);
            this.graphicsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() == 2) {
                        ImageCustomGraphicsSelector.this.fireActionEvent();
                    }
                }
            });
        }
        return this.graphicsList;
    }
}

