/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.cytoscape.application.events.CyStartEvent;
import org.cytoscape.application.events.CyStartListener;
import org.cytoscape.cg.event.CustomGraphicsLibraryUpdatedEvent;
import org.cytoscape.cg.event.CustomGraphicsLibraryUpdatedListener;
import org.cytoscape.cg.internal.ui.CustomGraphicsCellRenderer;
import org.cytoscape.cg.internal.ui.CustomGraphicsListModel;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.BitmapCustomGraphics;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.NullCustomGraphics;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.jdesktop.swingx.JXList;

public class CustomGraphicsBrowser
extends JXList
implements CyStartListener,
CustomGraphicsLibraryUpdatedListener {
    private CustomGraphicsListModel model;
    private final CyServiceRegistrar serviceRegistrar;
    private static DataFlavor urlFlavor;

    public CustomGraphicsBrowser(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.initComponents();
    }

    public void handleEvent(CyStartEvent e) {
        this.addAllImages();
    }

    @Override
    public void handleEvent(CustomGraphicsLibraryUpdatedEvent e) {
        this.model.removeAllElements();
        this.model.clear();
        this.addAllImages();
    }

    public void removeCustomGraphics(CyCustomGraphics<?> cg) {
        this.model.removeElement(cg);
    }

    private void initComponents() {
        this.setMaximumSize(new Dimension(300, 10000));
        this.model = new CustomGraphicsListModel();
        this.setModel(this.model);
        this.setCellRenderer(new CustomGraphicsCellRenderer());
        this.setDropTarget(new URLDropTarget());
    }

    private void addAllImages() {
        CustomGraphicsManager manager = (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class);
        Collection<CyCustomGraphics> graphics = manager.getAllCustomGraphics();
        for (CyCustomGraphics cg : graphics) {
            if (cg instanceof NullCustomGraphics) continue;
            this.model.addElement(cg);
        }
    }

    private AbstractURLImageCustomGraphics<?> addCustomGraphics(String urlStr) {
        CustomGraphicsManager manager = (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class);
        try {
            AbstractURLImageCustomGraphics cg;
            URL url = new URL(urlStr);
            Long id = manager.getNextAvailableID();
            AbstractURLImageCustomGraphics abstractURLImageCustomGraphics = cg = urlStr.toLowerCase().endsWith(".svg") ? new SVGCustomGraphics(id, urlStr, url) : new BitmapCustomGraphics(id, urlStr, url);
            if (cg != null) {
                manager.addCustomGraphics(cg, url);
                this.model.addElement(cg);
            }
            return cg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
    }

    private class URLDropTarget
    extends DropTarget {
        private Component parent;
        private Border originalBorder;
        private final Border dropBorder = BorderFactory.createLineBorder(UIManager.getColor("Focus.color"), 2);

        private URLDropTarget() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(3);
            Transferable trans = dtde.getTransferable();
            boolean gotData = false;
            AbstractURLImageCustomGraphics<?> lastCG = null;
            try {
                if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List fileList = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : fileList) {
                        lastCG = CustomGraphicsBrowser.this.addCustomGraphics(file.toURI().toURL().toString());
                    }
                    gotData = true;
                } else if (trans.isDataFlavorSupported(urlFlavor)) {
                    URL url = (URL)trans.getTransferData(urlFlavor);
                    CustomGraphicsBrowser.this.addCustomGraphics(url.toString());
                    gotData = true;
                } else if (trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String s = (String)trans.getTransferData(DataFlavor.stringFlavor);
                    URL url = new URL(s);
                    CustomGraphicsBrowser.this.addCustomGraphics(url.toString());
                    gotData = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                dtde.dropComplete(gotData);
            }
            if (lastCG != null) {
                CustomGraphicsBrowser.this.setSelectedValue(lastCG, true);
            }
        }

        @Override
        public synchronized void dragEnter(DropTargetDragEvent dtde) {
            super.dragEnter(dtde);
            this.parent = CustomGraphicsBrowser.this.getParent();
            if (this.parent instanceof JViewport) {
                this.parent = this.parent.getParent();
            }
            if (this.parent instanceof JComponent) {
                try {
                    this.originalBorder = ((JComponent)this.parent).getBorder();
                    ((JComponent)this.parent).setBorder(this.dropBorder);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public synchronized void dragExit(DropTargetEvent dte) {
            super.dragExit(dte);
            if (this.parent instanceof JComponent) {
                try {
                    ((JComponent)this.parent).setBorder(this.originalBorder);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

