/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.model;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGUniverse;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import org.cytoscape.cg.internal.paint.TexturePaintFactory;
import org.cytoscape.cg.internal.util.MathUtil;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.Cy2DGraphicLayer;

public class SVGLayer
implements Cy2DGraphicLayer {
    private Rectangle2D bounds;
    private Rectangle2D scaledBounds;
    private BufferedImage img;
    private TexturePaint paint;
    private final String svg;
    private final SVGDiagram diagram;

    public SVGLayer(String svg) {
        this.svg = svg;
        SVGUniverse universe = new SVGUniverse();
        StringReader is = new StringReader(svg);
        URI uri = universe.loadSVG((Reader)is, "about");
        this.diagram = universe.getDiagram(uri);
        this.diagram.setIgnoringClipHeuristic(true);
        this.bounds = this.scaledBounds = new Rectangle2D.Float(0.0f, 0.0f, this.diagram.getWidth(), this.diagram.getHeight());
    }

    private SVGLayer(String svg, SVGDiagram diagram, Rectangle2D bounds, Rectangle2D scaledBounds) {
        this.svg = svg;
        this.diagram = diagram;
        this.bounds = bounds;
        this.scaledBounds = scaledBounds;
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public CustomGraphicLayer transform(AffineTransform xform) {
        Rectangle2D newBounds = xform.createTransformedShape(this.bounds).getBounds2D();
        return new SVGLayer(this.svg, this.diagram, newBounds, this.scaledBounds);
    }

    public void draw(Graphics2D g, Shape shape, CyNetworkView networkView, View<? extends CyIdentifiable> view) {
        this.draw(g, shape, this.bounds);
    }

    public void draw(Graphics2D g, CyTableView tableView, CyColumn column, CyRow row) {
        this.draw(g, this.bounds, this.bounds);
    }

    public void draw(Graphics2D g, Shape shape, Rectangle2D bounds) {
        double x = bounds.getX();
        double y = bounds.getY();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        double iw = this.diagram.getWidth();
        double ih = this.diagram.getHeight();
        if (w == 0.0 || h == 0.0 || iw == 0.0 || ih == 0.0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        double scale = MathUtil.scaleToFit(iw, ih, w, h);
        double nw = iw * scale;
        double nh = ih * scale;
        g2.translate(x - nw / 2.0, y - nh / 2.0);
        g2.scale(scale, scale);
        try {
            this.diagram.render(g2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        g2.dispose();
    }

    public TexturePaint getPaint(Rectangle2D r) {
        if (this.img == null || this.paint == null || !r.equals(this.scaledBounds)) {
            this.img = this.createImage(r);
            this.paint = new TexturePaintFactory(this.img).getPaint(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        }
        this.scaledBounds = r;
        return this.paint;
    }

    public BufferedImage createImage(Rectangle2D r) {
        double x = r.getX();
        double y = r.getY();
        int w = (int)r.getWidth();
        int h = (int)r.getHeight();
        Rectangle2D.Double b = new Rectangle2D.Double(x + (double)w / 2.0, y + (double)h / 2.0, w, h);
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        this.draw(g2, r, b);
        return image;
    }
}

