/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.model;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.cytoscape.cg.model.CGComparator;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.NullCustomGraphics;
import org.cytoscape.view.model.DiscreteRange;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics2;

public final class CustomGraphicsRange
extends DiscreteRange<CyCustomGraphics> {
    private static CustomGraphicsManager manager;
    private static CustomGraphicsRange instance;

    private CustomGraphicsRange() {
        super(CyCustomGraphics.class, new HashSet());
    }

    public static CustomGraphicsRange getInstance() {
        if (instance == null) {
            instance = new CustomGraphicsRange();
        }
        return instance;
    }

    public Class<CyCustomGraphics> getType() {
        return CyCustomGraphics.class;
    }

    public boolean isDiscrete() {
        return true;
    }

    public Set<CyCustomGraphics> values() {
        TreeSet<CyCustomGraphics> sortedSet = new TreeSet<CyCustomGraphics>(new CGComparator());
        sortedSet.addAll(manager.getAllCustomGraphics());
        return sortedSet;
    }

    public void addRangeValue(CyCustomGraphics newValue) {
        manager.addCustomGraphics(newValue, null);
    }

    public boolean inRange(CyCustomGraphics value) {
        return value instanceof CyCustomGraphics2 || value == NullCustomGraphics.getNullObject() || manager.getAllCustomGraphics().contains(value);
    }

    public static void setManager(CustomGraphicsManager manager) {
        CustomGraphicsRange.manager = manager;
    }
}

