/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.cytoscape.cg.internal.charts.util.ColorGradient;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteProviderManager;

public class ColorScheme {
    @Deprecated
    public static final ColorScheme CONTRASTING = new ColorScheme("CONTRASTING", "Contrasting");
    @Deprecated
    public static final ColorScheme MODULATED = new ColorScheme("MODULATED", "Modulated");
    @Deprecated
    public static final ColorScheme RAINBOW = new ColorScheme("RAINBOW", "Rainbow");
    @Deprecated
    public static final ColorScheme RANDOM = new ColorScheme("RANDOM", "Random");
    @Deprecated
    public static final ColorScheme CUSTOM = new ColorScheme("CUSTOM", "Custom");
    private final String key;
    private final String label;
    private ColorGradient gradient;
    private Palette palette;
    private static CyServiceRegistrar serviceRegistrar;

    @Deprecated
    public ColorScheme(String key, String label) {
        this.key = key;
        this.label = label;
    }

    @Deprecated
    public ColorScheme(ColorGradient gradient) {
        this.key = gradient.name();
        this.label = gradient.getLabel();
        this.gradient = gradient;
    }

    public ColorScheme(Palette palette) {
        this.key = palette.getIdentifier().toString();
        this.label = palette.getName();
        this.palette = palette;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public List<Color> getColors(int nColors) {
        List<Color> colors = null;
        if (nColors > 0) {
            if (this.palette != null || this.gradient != null) {
                List<Color> list = colors = this.gradient != null ? this.gradient.getColors() : Arrays.asList(this.palette.getColors(nColors));
                if (colors.size() > nColors) {
                    ArrayList<Color> newColors = new ArrayList<Color>();
                    newColors.add(colors.get(0));
                    if (nColors == 2) {
                        newColors.add(colors.get(colors.size() - 1));
                    } else if (nColors == 3) {
                        newColors.add(colors.get(Math.round((float)(colors.size() - 1) / 2.0f)));
                        newColors.add(colors.get(colors.size() - 1));
                    } else if (nColors > 1) {
                        newColors.addAll(colors.subList(1, nColors));
                    }
                    colors = newColors;
                }
            } else if (nColors > 0) {
                if (RANDOM.getKey().equalsIgnoreCase(this.key) || CUSTOM.getKey().equalsIgnoreCase(this.key)) {
                    colors = ColorScheme.generateRandomColors(nColors);
                }
                if (RAINBOW.getKey().equalsIgnoreCase(this.key)) {
                    colors = ColorScheme.generateRainbowColors(nColors);
                }
                if (MODULATED.getKey().equalsIgnoreCase(this.key)) {
                    colors = ColorScheme.generateModulatedRainbowColors(nColors);
                }
                if (CONTRASTING.getKey().equalsIgnoreCase(this.key)) {
                    colors = ColorScheme.generateContrastingColors(nColors);
                }
            }
        }
        if (colors == null) {
            colors = Collections.emptyList();
        }
        return colors;
    }

    public Palette getPalette() {
        return this.palette;
    }

    public static ColorScheme parse(String input) {
        if (RANDOM.getKey().equalsIgnoreCase(input)) {
            return RANDOM;
        }
        if (CUSTOM.getKey().equalsIgnoreCase(input)) {
            return CUSTOM;
        }
        if (RAINBOW.getKey().equalsIgnoreCase(input)) {
            return RAINBOW;
        }
        if (MODULATED.getKey().equalsIgnoreCase(input)) {
            return MODULATED;
        }
        if (CONTRASTING.getKey().equalsIgnoreCase(input)) {
            return CONTRASTING;
        }
        if (ColorGradient.contains(input)) {
            return new ColorScheme(ColorGradient.getGradient(input));
        }
        if (input != null && serviceRegistrar != null) {
            PaletteProviderManager ppManager = (PaletteProviderManager)serviceRegistrar.getService(PaletteProviderManager.class);
            for (PaletteProvider provider : ppManager.getPaletteProviders()) {
                Palette palette = provider.getPalette(input);
                if (palette == null) continue;
                return new ColorScheme(palette);
            }
        }
        return CUSTOM;
    }

    public static List<Color> generateRandomColors(int nColors) {
        Calendar cal = Calendar.getInstance();
        int seed = cal.get(13);
        Random rand = new Random(seed);
        ArrayList<Color> result = new ArrayList<Color>(nColors);
        for (int index = 0; index < nColors; ++index) {
            int r = rand.nextInt(255);
            int g = rand.nextInt(255);
            int b = rand.nextInt(255);
            result.add(index, new Color(r, g, b, 255));
        }
        return result;
    }

    public static List<Color> generateRainbowColors(int nColors) {
        ArrayList<Color> values = new ArrayList<Color>();
        for (float i = 0.0f; i < (float)nColors; i += 1.0f) {
            values.add(new Color(Color.HSBtoRGB(i / (float)nColors, 1.0f, 1.0f)));
        }
        return values;
    }

    public static List<Color> generateModulatedRainbowColors(int nColors) {
        ArrayList<Color> values = new ArrayList<Color>();
        for (float i = 0.0f; i < (float)nColors; i += 1.0f) {
            float sat = Math.abs(((Number)Math.cos((double)(8.0f * i) / (Math.PI * 2))).floatValue()) * 0.7f + 0.3f;
            float br = Math.abs(((Number)Math.sin((double)i / (Math.PI * 2) + 1.5707963267948966)).floatValue()) * 0.7f + 0.3f;
            values.add(new Color(Color.HSBtoRGB(i / (float)nColors, sat, br)));
        }
        return values;
    }

    public static List<Color> generateContrastingColors(int nColors) {
        ArrayList<Color> values = new ArrayList<Color>();
        if (nColors == 2) {
            values.add(new Color(Color.HSBtoRGB(0.0f, 1.0f, 1.0f)));
            values.add(new Color(Color.HSBtoRGB(0.5f, 1.0f, 1.0f)));
            return values;
        }
        float divs = nColors;
        for (float i = 0.0f; i < divs; i += 1.0f) {
            Color rgbColor = new Color(Color.HSBtoRGB(i / divs, 1.0f, 1.0f));
            values.add(rgbColor);
            if ((i += 1.0f) >= divs) break;
            float hue = i / divs + 0.5f;
            if (hue >= 1.0f) {
                hue -= 1.0f;
            }
            rgbColor = new Color(Color.HSBtoRGB(hue, 1.0f, 1.0f));
            values.add(rgbColor);
        }
        return values;
    }

    public static void setServiceRegistrar(CyServiceRegistrar serviceRegistrar) {
        ColorScheme.serviceRegistrar = serviceRegistrar;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.key == null ? 0 : this.key.toUpperCase().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorScheme other = (ColorScheme)obj;
        return !(this.key == null ? other.key != null : !this.key.equalsIgnoreCase(other.key));
    }

    public String toString() {
        return this.label;
    }
}

