/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.model;

import java.net.URL;
import org.cytoscape.cg.model.AbstractDCustomGraphics;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;

public abstract class AbstractURLImageCustomGraphics<T extends CustomGraphicLayer>
extends AbstractDCustomGraphics<T> {
    static final float DEF_FIT_RATIO = 1.0f;
    protected URL sourceUrl;

    protected AbstractURLImageCustomGraphics(Long id, String displayName) {
        super(id, displayName);
    }

    protected AbstractURLImageCustomGraphics(Long id, String displayName, URL url) {
        this(id, displayName);
        this.sourceUrl = url;
        this.fitRatio = 1.0f;
        if (displayName.startsWith("bundle:")) {
            int index = displayName.lastIndexOf("/");
            displayName = displayName.substring(index + 1);
        }
    }

    public URL getSourceURL() {
        return this.sourceUrl;
    }

    public String toSerializableString() {
        if (this.sourceUrl != null) {
            return this.makeSerializableString(this.sourceUrl.toString());
        }
        return this.makeSerializableString(this.displayName);
    }

    @Override
    public String toString() {
        if (this.sourceUrl == null && this.displayName == null) {
            return "Empty image";
        }
        if (this.sourceUrl != null && !this.sourceUrl.toString().startsWith("bundle")) {
            return this.sourceUrl.toString();
        }
        return this.displayName;
    }

    public abstract String getTypeNamespace();

    public abstract String getTypeName();

    @Override
    public String getTypeFullName() {
        return this.getTypeNamespace() + "." + this.getTypeName();
    }
}

