/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.model;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.cytoscape.cg.model.Taggable;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.table.CyColumnView;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphicsFactory;

public abstract class AbstractDCustomGraphics<T extends CustomGraphicLayer>
implements CyCustomGraphics<T>,
Taggable {
    protected static final String DELIMITER = ",";
    public static final String LIST_DELIMITER = "|";
    protected float fitRatio = 0.9f;
    protected final Long id;
    protected List<T> layers;
    protected String displayName;
    protected int width = 50;
    protected int height = 50;
    protected CyCustomGraphicsFactory<T> factory;
    protected final SortedSet<String> tags;

    public AbstractDCustomGraphics(Long id, String displayName) {
        this.id = id;
        this.layers = new ArrayList<T>();
        this.displayName = displayName;
        this.tags = new TreeSet<String>();
    }

    public Long getIdentifier() {
        return this.id;
    }

    public void setIdentifier(Long id) {
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List<T> getLayers(CyNetworkView networkView, View<? extends CyIdentifiable> graphObject) {
        return this.layers;
    }

    public List<T> getLayers(CyTableView tableView, CyColumnView columnView, CyRow row) {
        return this.layers;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public abstract Image getRenderedImage();

    public abstract String toString();

    @Override
    public Collection<String> getTags() {
        return this.tags;
    }

    protected String makeSerializableString(String name) {
        String tagStr = "";
        if (this.tags.size() != 0) {
            StringBuilder builder = new StringBuilder();
            for (String tag : this.tags) {
                builder.append(tag + LIST_DELIMITER);
            }
            String temp = builder.toString();
            tagStr = temp.substring(0, temp.length() - 1);
        }
        if (name == null) {
            name = this.displayName;
        }
        if (name.contains(DELIMITER)) {
            name = name.replace(DELIMITER, "___");
        }
        return this.getTypeFullName() + DELIMITER + this.getIdentifier() + DELIMITER + name + DELIMITER + tagStr;
    }

    public String getTypeFullName() {
        return this.getClass().getCanonicalName();
    }

    public void setFitRatio(float fitRatio) {
        this.fitRatio = fitRatio;
    }

    public float getFitRatio() {
        return this.fitRatio;
    }
}

