/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.cg.internal.json.ColorJsonDeserializer;
import org.cytoscape.cg.internal.json.ColorJsonSerializer;
import org.cytoscape.cg.internal.json.ColorSchemeJsonDeserializer;
import org.cytoscape.cg.internal.json.ColorSchemeJsonSerializer;
import org.cytoscape.cg.internal.json.Point2DJsonDeserializer;
import org.cytoscape.cg.internal.json.Point2DJsonSerializer;
import org.cytoscape.cg.internal.json.PropertiesJsonDeserializer;
import org.cytoscape.cg.internal.json.PropertiesJsonSerializer;
import org.cytoscape.cg.internal.json.Rectangle2DJsonDeserializer;
import org.cytoscape.cg.internal.json.Rectangle2DJsonSerializer;
import org.cytoscape.cg.model.ColorScheme;
import org.cytoscape.cg.model.Orientation;
import org.cytoscape.cg.model.Rotation;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCustomGraphics2<T extends CustomGraphicLayer>
implements CyCustomGraphics2<T> {
    public static final String COLORS = "cy_colors";
    public static final String COLOR_SCHEME = "cy_colorScheme";
    public static final String ORIENTATION = "cy_orientation";
    public static final String ROTATION = "cy_rotation";
    protected Long id;
    protected float fitRatio = 0.9f;
    protected String displayName;
    protected int width = 50;
    protected int height = 50;
    private final Map<String, Object> properties;
    private ObjectMapper mapper;
    protected final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    protected AbstractCustomGraphics2(String displayName) {
        this.displayName = displayName;
        this.properties = new HashMap<String, Object>();
    }

    protected AbstractCustomGraphics2(String displayName, String input) {
        this(displayName);
        this.addProperties(this.parseInput(input));
    }

    protected AbstractCustomGraphics2(String displayName, Map<String, ?> properties) {
        this(displayName);
        this.addProperties(properties);
    }

    public Map<String, Object> getProperties() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof ColorScheme) {
                value = ((ColorScheme)value).getKey();
            } else if (value instanceof Enum) {
                value = value.toString();
            }
            map.put(key, value);
        }
        return map;
    }

    public Long getIdentifier() {
        return this.id;
    }

    public void setIdentifier(Long id) {
        this.id = id;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public float getFitRatio() {
        return this.fitRatio;
    }

    public void setFitRatio(float fitRatio) {
        this.fitRatio = fitRatio;
    }

    public String toString() {
        return this.displayName;
    }

    public String toSerializableString() {
        Object output = "";
        try {
            ObjectMapper om = this.getObjectMapper();
            output = om.writeValueAsString(this.properties);
            output = this.getId() + ":" + (String)output;
        }
        catch (JsonProcessingException e) {
            this.logger.error("Cannot create JSON from custom graphics", (Throwable)e);
        }
        return output;
    }

    public abstract String getId();

    public synchronized void set(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be null.");
        }
        Class<?> type = this.getSettingType(key);
        if (type != null) {
            if (value != null) {
                boolean correctType = type == Array.class && value.getClass().isArray() && value.getClass().getComponentType() == this.getSettingElementType(key);
                boolean bl = correctType = correctType || type.isAssignableFrom(value.getClass());
                if (!correctType) {
                    ObjectMapper om = this.getObjectMapper();
                    String json = value.toString();
                    if (type != List.class) {
                        try {
                            json = om.writeValueAsString(value);
                        }
                        catch (JsonProcessingException e) {
                            this.logger.error("Cannot parse JSON field " + key, (Throwable)e);
                        }
                    }
                    value = PropertiesJsonDeserializer.readValue(key, json, om, this);
                }
            }
            this.properties.put(key, value);
        }
    }

    public synchronized <S> S get(String key, Class<S> cls) {
        Object obj = this.properties.get(key);
        return (S)(obj != null && cls.isAssignableFrom(obj.getClass()) ? obj : null);
    }

    public synchronized <S> S get(String key, Class<S> cls, S defValue) {
        S value = this.get(key, cls);
        return value != null ? value : defValue;
    }

    public synchronized <S> List<S> getList(String key, Class<S> cls) {
        Object obj = this.properties.get(key);
        return obj instanceof List ? (List)obj : Collections.emptyList();
    }

    public synchronized <S> S[] getArray(String key, Class<S> cls) {
        Object obj = this.properties.get(key);
        Object[] arr = null;
        try {
            arr = obj != null && obj.getClass().isArray() ? (Object[])obj : null;
        }
        catch (ClassCastException e) {
            this.logger.error("Cannot cast property '" + key + "' to array.", (Throwable)e);
        }
        return arr;
    }

    public synchronized float[] getFloatArray(String key) {
        Object obj = this.properties.get(key);
        try {
            return (float[])obj;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public synchronized double[] getDoubleArray(String key) {
        Object obj = this.properties.get(key);
        try {
            return (double[])obj;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    protected Map<String, Object> parseInput(String input) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (input != null && !input.isEmpty()) {
            try {
                ObjectMapper om = this.getObjectMapper();
                Map map = (Map)om.readValue(input, Map.class);
                if (map != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        props.put(key, value);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Cannot parse JSON: " + input, (Throwable)e);
            }
        }
        return props;
    }

    public Class<?> getSettingType(String key) {
        if (key.equalsIgnoreCase(COLORS)) {
            return List.class;
        }
        if (key.equalsIgnoreCase(COLOR_SCHEME)) {
            return ColorScheme.class;
        }
        if (key.equalsIgnoreCase(ORIENTATION)) {
            return Orientation.class;
        }
        if (key.equalsIgnoreCase(ROTATION)) {
            return Rotation.class;
        }
        return null;
    }

    public Class<?> getSettingElementType(String key) {
        if (key.equalsIgnoreCase(COLORS)) {
            return Color.class;
        }
        return Object.class;
    }

    protected void addProperties(Map<String, ?> properties) {
        if (properties != null) {
            for (Map.Entry<String, ?> entry : properties.entrySet()) {
                if (this.getSettingType(entry.getKey()) == null) continue;
                this.set(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void addJsonSerializers(SimpleModule module) {
        module.addSerializer((JsonSerializer)new PropertiesJsonSerializer());
        module.addSerializer((JsonSerializer)new ColorSchemeJsonSerializer());
        module.addSerializer((JsonSerializer)new ColorJsonSerializer());
        module.addSerializer((JsonSerializer)new Point2DJsonSerializer());
        module.addSerializer((JsonSerializer)new Rectangle2DJsonSerializer());
    }

    protected void addJsonDeserializers(SimpleModule module) {
        module.addDeserializer(Map.class, (JsonDeserializer)new PropertiesJsonDeserializer(this));
        module.addDeserializer(ColorScheme.class, (JsonDeserializer)new ColorSchemeJsonDeserializer());
        module.addDeserializer(Color.class, (JsonDeserializer)new ColorJsonDeserializer());
        module.addDeserializer(Point2D.class, (JsonDeserializer)new Point2DJsonDeserializer());
        module.addDeserializer(Rectangle2D.class, (JsonDeserializer)new Rectangle2DJsonDeserializer());
    }

    private ObjectMapper getObjectMapper() {
        if (this.mapper == null) {
            SimpleModule module = new SimpleModule();
            this.addJsonSerializers(module);
            this.addJsonDeserializers(module);
            this.mapper = new ObjectMapper();
            this.mapper.registerModule((Module)module);
        }
        return this.mapper;
    }
}

