/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.vector;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import org.cytoscape.cg.internal.paint.LinearGradientPaintFactory;
import org.cytoscape.cg.internal.vector.GradientLayerCustomGraphics;
import org.cytoscape.cg.internal.vector.PaintCustomGraphics;

public class GradientRoundRectangleLayer
extends GradientLayerCustomGraphics {
    private static final String NAME = "Round Rectangle Gradient";
    private int r = 20;

    public GradientRoundRectangleLayer(Long id) {
        super(id, NAME);
    }

    @Override
    protected void renderImage(Graphics graphics) {
        super.renderImage(graphics);
        Graphics2D g2d = (Graphics2D)graphics;
        this.update();
        g2d.setPaint(this.paintFactory.getPaint(this.shape.getBounds2D()));
        g2d.fillRoundRect(this.rendered.getMinX(), this.rendered.getMinY(), this.rendered.getWidth(), this.rendered.getHeight(), this.r, this.r);
    }

    public void update() {
        this.layers.clear();
        this.r = (int)((float)Math.min(this.width, this.height) / 4.0f);
        this.shape = new RoundRectangle2D.Double(-this.width / 2, -this.height / 2, this.width, this.height, this.r, this.r);
        this.paintFactory = new LinearGradientPaintFactory(this.colorList, this.stopList);
        PaintCustomGraphics cg = new PaintCustomGraphics(this.shape, this.paintFactory);
        this.layers.add(cg);
    }

    public String toSerializableString() {
        return this.makeSerializableString(this.displayName);
    }
}

