/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.vector;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.cg.internal.util.PaintFactory;
import org.cytoscape.cg.internal.vector.CustomGraphicsProperty;
import org.cytoscape.cg.internal.vector.VectorCustomGraphics;
import org.cytoscape.cg.model.AbstractDCustomGraphics;
import org.cytoscape.cg.model.CustomGraphicsPropertyImpl;

public abstract class GradientLayerCustomGraphics
extends AbstractDCustomGraphics
implements VectorCustomGraphics {
    protected PaintFactory paintFactory;
    protected Shape shape;
    private final String NAME;
    private static final float FIT = 0.9f;
    protected static final String COLOR1 = "Color 1";
    protected static final String COLOR2 = "Color 2";
    protected final CustomGraphicsProperty<Color> c1;
    protected final CustomGraphicsProperty<Color> c2;
    protected List<Color> colorList;
    protected List<Float> stopList;
    protected BufferedImage rendered;
    private static final Color transparentWhite = new Color(255, 255, 255, 100);
    private static final Color transparentBlack = new Color(100, 100, 100, 100);
    private static final int DEF_W = 100;
    private static final int DEF_H = 100;
    protected final Map<String, CustomGraphicsProperty<?>> props;

    public GradientLayerCustomGraphics(Long id, String name) {
        super(id, name);
        this.NAME = name;
        this.width = 100;
        this.height = 100;
        this.props = new HashMap();
        this.colorList = new ArrayList<Color>();
        this.stopList = new ArrayList<Float>();
        this.c1 = new CustomGraphicsPropertyImpl<Color>(transparentWhite);
        this.colorList.add(this.c1.getValue());
        this.stopList.add(Float.valueOf(0.0f));
        this.c2 = new CustomGraphicsPropertyImpl<Color>(transparentBlack);
        this.colorList.add(this.c2.getValue());
        this.stopList.add(Float.valueOf(1.0f));
        this.props.put(COLOR1, this.c1);
        this.props.put(COLOR2, this.c2);
        this.tags.add("vector image, gradient");
        this.fitRatio = 0.9f;
        this.getRenderedImage();
    }

    @Override
    public Map<String, CustomGraphicsProperty<?>> getGraphicsProps() {
        return this.props;
    }

    protected void renderImage(Graphics graphics) {
        this.rendered.flush();
        Graphics2D g2 = (Graphics2D)graphics.create();
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.dispose();
    }

    @Override
    public Image getRenderedImage() {
        if (this.rendered == null || this.rendered != null && (this.rendered.getWidth() != this.width || this.rendered.getHeight() != this.height)) {
            this.rendered = new BufferedImage(this.width, this.height, 2);
            this.renderImage(this.rendered.getGraphics());
        }
        return this.rendered;
    }

    @Override
    public String toString() {
        return this.NAME;
    }
}

