/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.util;

import java.awt.Color;
import org.cytoscape.cg.internal.util.ColorUtil;

public class ControlPoint {
    private Color color;
    private float position;

    public ControlPoint() {
        this(Color.WHITE, 0.0f);
    }

    public ControlPoint(Color color, float position) {
        if (color == null) {
            throw new IllegalArgumentException("'color' must not be null.");
        }
        this.setColor(color);
        this.setPosition(position);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float getPosition() {
        return this.position;
    }

    public void setPosition(float position) {
        this.position = position;
    }

    public int hashCode() {
        int prime = 11;
        int result = 5;
        result = prime * result + (this.color == null ? 0 : this.color.hashCode());
        result = prime * result + Float.floatToIntBits(this.position);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ControlPoint other = (ControlPoint)obj;
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        return Float.floatToIntBits(this.position) == Float.floatToIntBits(other.position);
    }

    public String toString() {
        return this.getPosition() + ":" + ColorUtil.toHexString(this.getColor());
    }
}

