/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.cg.internal.ui.CustomGraphicsDetailPanel;
import org.cytoscape.cg.internal.ui.CustomGraphicsListModel;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.BitmapCustomGraphics;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.cg.util.CustomGraphicsBrowser;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomGraphicsManagerDialog
extends JDialog {
    private static final String IMG_FILES_DESCRIPTION = "Image file (PNG, GIF, JPEG or SVG)";
    private static final String[] IMG_EXTENSIONS = new String[]{"jpg", "jpeg", "png", "gif", "svg"};
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private JButton addButton;
    private JButton deleteButton;
    private JButton closeButton;
    private JScrollPane leftScrollPane;
    private JSplitPane mainSplitPane;
    private JScrollPane rightScrollPane;
    private JPanel leftPanel;
    private JPanel buttonPanel;
    private final CustomGraphicsBrowser browser;
    private final CustomGraphicsDetailPanel detail;
    private final CustomGraphicsManager manager;
    private final IconManager iconManager;

    public CustomGraphicsManagerDialog(Window owner, CustomGraphicsManager manager, CustomGraphicsBrowser browser, CyServiceRegistrar serviceRegistrar) {
        super(owner, Dialog.ModalityType.APPLICATION_MODAL);
        if (browser == null) {
            throw new NullPointerException("CustomGraphicsBrowser is null.");
        }
        this.manager = manager;
        this.browser = browser;
        this.iconManager = (IconManager)serviceRegistrar.getService(IconManager.class);
        this.initComponents();
        this.detail = new CustomGraphicsDetailPanel((CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class));
        this.leftScrollPane.setViewportView((Component)((Object)browser));
        this.rightScrollPane.setViewportView(this.detail);
        this.setPreferredSize(new Dimension(880, 580));
        this.setTitle("Image Manager");
        this.browser.addListSelectionListener(this.detail);
        this.pack();
    }

    private void initComponents() {
        this.deleteButton = new JButton();
        this.addButton = new JButton();
        this.mainSplitPane = new JSplitPane();
        this.leftScrollPane = new JScrollPane();
        this.rightScrollPane = new JScrollPane();
        this.leftPanel = new JPanel();
        this.mainSplitPane.setBorder(null);
        this.rightScrollPane.setBorder(null);
        this.leftScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")));
        this.leftPanel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Separator.foreground")));
        this.setDefaultCloseOperation(2);
        this.addButton.setText("\uf067");
        this.addButton.setFont(this.iconManager.getIconFont(18.0f));
        this.addButton.setToolTipText("Add Images");
        if (LookAndFeelUtil.isAquaLAF()) {
            this.addButton.putClientProperty("JButton.buttonType", "segmentedGradient");
            this.addButton.putClientProperty("JButton.segmentPosition", "middle");
        }
        this.addButton.addActionListener(evt -> this.addButtonActionPerformed(evt));
        this.deleteButton.setText("\uf014");
        this.deleteButton.setFont(this.iconManager.getIconFont(18.0f));
        this.deleteButton.setToolTipText("Remove Selected Images");
        if (LookAndFeelUtil.isAquaLAF()) {
            this.deleteButton.putClientProperty("JButton.buttonType", "segmentedGradient");
            this.deleteButton.putClientProperty("JButton.segmentPosition", "only");
        }
        this.deleteButton.addActionListener(evt -> this.deleteButtonActionPerformed(evt));
        this.closeButton = new JButton(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomGraphicsManagerDialog.this.dispose();
            }
        });
        this.buttonPanel = LookAndFeelUtil.createOkCancelPanel(null, (JButton)this.closeButton);
        this.mainSplitPane.setDividerLocation(230);
        this.mainSplitPane.setLeftComponent(this.leftPanel);
        this.mainSplitPane.setRightComponent(this.rightScrollPane);
        GroupLayout layout = new GroupLayout(this.leftPanel);
        this.leftPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.leftScrollPane, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addButton, -1, -1, Short.MAX_VALUE).addComponent(this.deleteButton, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.leftScrollPane, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.addButton).addComponent(this.deleteButton)));
        layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.mainSplitPane, -1, -1, Short.MAX_VALUE).addComponent(this.buttonPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.mainSplitPane, -1, -1, Short.MAX_VALUE).addComponent(this.buttonPanel, -2, -1, -2)));
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), null, (Action)this.closeButton.getAction());
        this.pack();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter(IMG_FILES_DESCRIPTION, IMG_EXTENSIONS);
        chooser.setDialogTitle("Select Image Files");
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.processFiles(chooser.getSelectedFiles());
        }
    }

    private void processFiles(File[] files) {
        for (File file : files) {
            BufferedImage img = null;
            String svg = null;
            if (file.isFile()) {
                try {
                    if (file.getName().toLowerCase().endsWith(".svg")) {
                        svg = Files.readString(file.toPath());
                    } else {
                        img = ImageIO.read(file);
                    }
                }
                catch (Exception e) {
                    logger.error("Could not read file: " + file.toString(), (Throwable)e);
                    continue;
                }
            }
            try {
                URL url = file.toURI().toURL();
                AbstractURLImageCustomGraphics cg = null;
                if (svg != null) {
                    cg = new SVGCustomGraphics(this.manager.getNextAvailableID(), file.toString(), url, svg);
                } else if (img != null) {
                    cg = new BitmapCustomGraphics(this.manager.getNextAvailableID(), file.toString(), url, img);
                }
                if (cg == null) continue;
                this.manager.addCustomGraphics(cg, url);
                ((CustomGraphicsListModel)this.browser.getModel()).addElement(cg);
            }
            catch (Exception e) {
                logger.error("Could not create custom graphics: " + file, (Throwable)e);
            }
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        Object[] toBeRemoved;
        for (Object obj : toBeRemoved = this.browser.getSelectedValues()) {
            CyCustomGraphics cg = (CyCustomGraphics)obj;
            if (!this.manager.isUsedInCurrentSession(cg)) {
                this.browser.removeCustomGraphics(cg);
                this.manager.removeCustomGraphics(cg.getIdentifier());
                continue;
            }
            JOptionPane.showMessageDialog(this, cg.getDisplayName() + " is used in current session and cannot remove it.", "Custom Graphics is in Use.", 0);
        }
    }
}

