/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.cg.internal.util.VisualPropertyIconFactory;
import org.cytoscape.cg.model.BitmapCustomGraphics;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.cg.util.CustomGraphicsBrowser;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.jdesktop.swingx.JXImageView;

public class CustomGraphicsDetailPanel
extends JPanel
implements ListSelectionListener {
    private JTextField heightTextField;
    private CGImageView imageViewPanel;
    private JCheckBox lockCheckBox;
    private JTextField nameTextField;
    private JButton resetButton;
    private JTextField widthTextField;
    private CyCustomGraphics<?> cg;
    private final CyApplicationManager appManager;

    public CustomGraphicsDetailPanel(CyApplicationManager appManager) {
        this.appManager = appManager;
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(LookAndFeelUtil.createTitledBorder((String)"Image"));
        JLabel nameLabel = new JLabel("Name:");
        JLabel imgViewLabel = new JLabel("Actual Size View:");
        JLabel widthLabel = new JLabel("Width:");
        JLabel heightLabel = new JLabel("Height:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(nameLabel).addComponent(this.getNameTextField(), -1, -1, Short.MAX_VALUE)).addComponent(imgViewLabel, -1, -1, Short.MAX_VALUE).addComponent((Component)((Object)this.getImageViewPanel()), -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(widthLabel).addComponent(this.getWidthTextField(), -2, 60, -2).addComponent(heightLabel).addComponent(this.getHeightTextField(), -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getLockCheckBox()).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getResetButton())));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(nameLabel).addComponent(this.getNameTextField())).addComponent(imgViewLabel, -2, -1, -2).addComponent((Component)((Object)this.getImageViewPanel()), -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(widthLabel).addComponent(this.getWidthTextField()).addComponent(heightLabel).addComponent(this.getHeightTextField()).addComponent(this.getLockCheckBox()).addComponent(this.getResetButton())));
    }

    JTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new JTextField();
            this.nameTextField.addActionListener(evt -> {
                String newName = this.nameTextField.getText();
                if (newName != null && newName.trim().length() != 0 && this.cg != null) {
                    this.cg.setDisplayName(this.nameTextField.getText());
                }
            });
        }
        return this.nameTextField;
    }

    JTextField getWidthTextField() {
        if (this.widthTextField == null) {
            this.widthTextField = new JTextField();
            this.widthTextField.addActionListener(evt -> this.resizeImage(this.widthTextField));
            this.widthTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    CustomGraphicsDetailPanel.this.resizeImage(CustomGraphicsDetailPanel.this.widthTextField);
                }
            });
        }
        return this.widthTextField;
    }

    JTextField getHeightTextField() {
        if (this.heightTextField == null) {
            this.heightTextField = new JTextField();
            this.heightTextField.addActionListener(evt -> this.resizeImage(this.heightTextField));
            this.heightTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    CustomGraphicsDetailPanel.this.resizeImage(CustomGraphicsDetailPanel.this.heightTextField);
                }
            });
        }
        return this.heightTextField;
    }

    JCheckBox getLockCheckBox() {
        if (this.lockCheckBox == null) {
            this.lockCheckBox = new JCheckBox("Aspect Ratio");
            this.lockCheckBox.setSelected(true);
            this.lockCheckBox.addActionListener(evt -> this.resizeImage(null));
        }
        return this.lockCheckBox;
    }

    CGImageView getImageViewPanel() {
        if (this.imageViewPanel == null) {
            this.imageViewPanel = new CGImageView();
            this.imageViewPanel.setLayout(new BorderLayout());
            this.imageViewPanel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Separator.foreground")));
        }
        return this.imageViewPanel;
    }

    JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton("Original");
            this.resetButton.addActionListener(evt -> {
                if (this.cg == null || this.cg.getRenderedImage() == null) {
                    return;
                }
                if (this.cg instanceof BitmapCustomGraphics) {
                    Image image = ((BitmapCustomGraphics)this.cg).resetImage();
                    this.getImageViewPanel().setImage(image);
                    int w = image.getWidth(null);
                    int h = image.getHeight(null);
                    this.getWidthTextField().setText(Integer.toString(w));
                    this.getHeightTextField().setText(Integer.toString(h));
                    this.cg.setWidth(w);
                    this.cg.setHeight(h);
                    CyNetworkView netView = this.appManager.getCurrentNetworkView();
                    if (netView != null) {
                        netView.updateView();
                    }
                }
            });
        }
        return this.resetButton;
    }

    private void resizeImage(JComponent source) {
        CyNetworkView netView;
        boolean isBitmap;
        String width = this.getWidthTextField().getText();
        String height = this.getHeightTextField().getText();
        Image currentImage = this.cg.getRenderedImage();
        if (currentImage == null) {
            return;
        }
        boolean lock = this.getLockCheckBox().isSelected();
        int currentW = currentImage.getWidth(null);
        int currentH = currentImage.getHeight(null);
        Integer w = null;
        Integer h = null;
        try {
            w = Integer.parseInt(width);
            h = Integer.parseInt(height);
        }
        catch (NumberFormatException e) {
            this.getWidthTextField().setText(Integer.toString(currentW));
            this.getHeightTextField().setText(Integer.toString(currentH));
            return;
        }
        boolean bl = isBitmap = !(this.cg instanceof SVGCustomGraphics);
        if (isBitmap) {
            float ratio;
            if (!lock) {
                this.cg.setWidth(w.intValue());
                this.cg.setHeight(h.intValue());
                this.getImageViewPanel().setImage(this.cg.getRenderedImage());
            } else if (this.getWidthTextField().equals(source)) {
                ratio = (float)currentH / (float)currentW;
                int converted = (int)((float)w.intValue() * ratio);
                this.cg.setWidth(w.intValue());
                this.cg.setHeight(converted);
                this.getImageViewPanel().setImage(this.cg.getRenderedImage());
                this.getHeightTextField().setText(Integer.toString(converted));
            } else if (this.getHeightTextField().equals(source)) {
                ratio = (float)currentW / (float)currentH;
                int converted = (int)((float)h.intValue() * ratio);
                this.cg.setWidth(converted);
                this.cg.setHeight(h.intValue());
                this.getImageViewPanel().setImage(this.cg.getRenderedImage());
                this.getWidthTextField().setText(Integer.toString(converted));
            }
        }
        if ((netView = this.appManager.getCurrentNetworkView()) != null) {
            netView.updateView();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!(e.getSource() instanceof CustomGraphicsBrowser) || e.getValueIsAdjusting()) {
            return;
        }
        CustomGraphicsBrowser browser = (CustomGraphicsBrowser)e.getSource();
        this.cg = (CyCustomGraphics)browser.getSelectedValue();
        this.getNameTextField().setText(null);
        this.getNameTextField().setToolTipText(null);
        this.getHeightTextField().setText(null);
        this.getWidthTextField().setText(null);
        if (this.cg == null) {
            this.getImageViewPanel().setImage(null);
            this.getImageViewPanel().setIcon(null);
            this.getImageViewPanel().setEditable(false);
            return;
        }
        this.getNameTextField().setText(this.cg.getDisplayName());
        this.getNameTextField().setToolTipText(this.cg.getDisplayName());
        boolean isBitmap = this.cg instanceof BitmapCustomGraphics;
        this.getWidthTextField().setEnabled(isBitmap);
        this.getHeightTextField().setEnabled(isBitmap);
        this.getLockCheckBox().setEnabled(isBitmap);
        this.getResetButton().setEnabled(isBitmap);
        this.getImageViewPanel().setEditable(isBitmap);
        if (this.cg instanceof SVGCustomGraphics) {
            int w = this.getImageViewPanel().getWidth();
            int h = this.getImageViewPanel().getHeight();
            Icon icon = VisualPropertyIconFactory.createIcon(this.cg, w, h);
            this.getImageViewPanel().setIcon(icon);
            this.getImageViewPanel().setImage(null);
        } else {
            Image img = this.cg.getRenderedImage();
            this.getImageViewPanel().setImage(img);
            this.getImageViewPanel().setIcon(null);
            this.getHeightTextField().setText(Integer.toString(img.getHeight(null)));
            this.getWidthTextField().setText(Integer.toString(img.getWidth(null)));
        }
    }

    private class CGImageView
    extends JXImageView {
        private Icon icon;

        private CGImageView() {
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
            this.repaint();
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.icon != null) {
                Point2D center = new Point2D.Double((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
                if (this.getImageLocation() != null) {
                    center = this.getImageLocation();
                }
                Point2D.Double loc = new Point2D.Double();
                int w = this.icon.getIconWidth();
                int h = this.icon.getIconHeight();
                loc.setLocation(center.getX() - (double)w / 2.0, center.getY() - (double)h / 2.0);
                this.icon.paintIcon((Component)((Object)this), g, (int)loc.getX(), (int)loc.getY());
            }
        }
    }
}

