/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.gradient.radial;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import org.cytoscape.cg.internal.gradient.AbstractGradient;
import org.cytoscape.cg.internal.gradient.radial.RadialGradientLayer;

public class RadialGradient
extends AbstractGradient<RadialGradientLayer> {
    public static final String FACTORY_ID = "org.cytoscape.RadialGradient";
    public static final String DISPLAY_NAME = "Radial Gradient";
    public static final String CENTER = "cy_center";
    public static final String RADIUS = "cy_radius";
    private BufferedImage renderedImg;
    private volatile boolean dirty = true;

    public RadialGradient(String input) {
        super(DISPLAY_NAME, input);
    }

    public RadialGradient(RadialGradient gradient) {
        super(gradient);
    }

    public RadialGradient(Map<String, Object> properties) {
        super(DISPLAY_NAME, properties);
    }

    public synchronized Image getRenderedImage() {
        if (this.dirty) {
            this.updateRendereredImage();
            this.dirty = false;
        }
        return this.renderedImg;
    }

    @Override
    public String getId() {
        return FACTORY_ID;
    }

    @Override
    public synchronized void set(String key, Object value) {
        super.set(key, value);
        if (CENTER.equalsIgnoreCase(key) || RADIUS.equalsIgnoreCase(key) || "cy_gradientFractions".equalsIgnoreCase(key) || "cy_gradientColors".equalsIgnoreCase(key)) {
            this.dirty = true;
        }
    }

    @Override
    public Class<?> getSettingType(String key) {
        if (key.equalsIgnoreCase(CENTER)) {
            return Point2D.class;
        }
        if (key.equalsIgnoreCase(RADIUS)) {
            return Float.class;
        }
        return super.getSettingType(key);
    }

    @Override
    protected RadialGradientLayer createLayer() {
        RadialGradientLayer layer = null;
        float radius = this.get(RADIUS, Float.class, Float.valueOf(1.0f)).floatValue();
        Point2D center = this.get(CENTER, Point2D.class, new Point2D.Float(radius / 2.0f, radius / 2.0f));
        List<Float> fractions = this.getList("cy_gradientFractions", Float.class);
        List<Color> colors = this.getList("cy_gradientColors", Color.class);
        if (center != null && fractions.size() > 1) {
            layer = new RadialGradientLayer(center, radius, fractions, colors);
        }
        return layer;
    }

    private void updateRendereredImage() {
        RadialGradientLayer layer = this.createLayer();
        if (layer != null) {
            Rectangle rect = layer.getBounds2D().getBounds();
            rect = new Rectangle(rect.x, rect.y, 100, 100);
            Ellipse2D.Double shape = new Ellipse2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
            this.renderedImg = new BufferedImage(rect.width, rect.height, 2);
            Graphics2D g2d = this.renderedImg.createGraphics();
            g2d.setPaint(layer.getPaint(rect));
            g2d.fill(shape);
        } else {
            this.renderedImg = new BufferedImage(24, 24, 2);
        }
    }
}

