/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.gradient.linear;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.cytoscape.cg.internal.gradient.AbstractGradientLayer;
import org.cytoscape.cg.internal.util.MathUtil;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;

public class LinearGradientLayer
extends AbstractGradientLayer {
    protected double angle;
    protected Rectangle2D rectangle = new Rectangle(0, 0, 100, 100);

    public LinearGradientLayer(double angle, List<Float> fractions, List<Color> colors) {
        super(fractions, colors);
        this.angle = MathUtil.normalizeAngle(angle);
    }

    public Paint getPaint(Rectangle2D bounds) {
        Line2D line = LinearGradientLayer.getGradientAxis(bounds, this.angle);
        this.paint = new LinearGradientPaint(line.getP1(), line.getP2(), this.fractionArray, this.colorArray);
        return this.paint;
    }

    public Rectangle2D getBounds2D() {
        return this.rectangle;
    }

    public CustomGraphicLayer transform(AffineTransform xform) {
        LinearGradientLayer newLayer = new LinearGradientLayer(this.angle, this.fractions, this.colors);
        newLayer.rectangle = xform.createTransformedShape(this.rectangle).getBounds2D();
        return newLayer;
    }

    private static Line2D getGradientAxis(Rectangle2D bounds, double angle) {
        Point2D start = null;
        Point2D end = null;
        double x1 = bounds.getMinX();
        double y1 = bounds.getMinY();
        double x2 = bounds.getMaxX();
        double y2 = bounds.getMaxY();
        double cx = bounds.getCenterX();
        double cy = bounds.getCenterY();
        if (angle == 0.0) {
            start = new Point2D.Double(x1, cy);
            end = new Point2D.Double(x2, cy);
        } else if (angle == 90.0) {
            start = new Point2D.Double(cx, y2);
            end = new Point2D.Double(cx, y1);
        } else if (angle == 180.0) {
            start = new Point2D.Double(x2, cy);
            end = new Point2D.Double(x1, cy);
        } else if (angle == 270.0) {
            start = new Point2D.Double(cx, y1);
            end = new Point2D.Double(cx, y2);
        } else {
            double d = Math.max(bounds.getWidth(), bounds.getHeight());
            Line2D gl = new Line2D.Double(cx - d, cy, cx + d, cy);
            gl = MathUtil.rotate(gl, -angle, cx, cy);
            int q = MathUtil.getQuadrant(angle);
            Line2D pl1 = new Line2D.Double(x1, cy - d, x1, cy + d);
            double ax = x1;
            double ay = q == 1 || q == 3 ? y2 : y1;
            pl1 = MathUtil.rotate(pl1, -angle, ax, ay);
            Line2D pl2 = new Line2D.Double(x2, cy - d, x2, cy + d);
            ax = x2;
            ay = q == 1 || q == 3 ? y1 : y2;
            pl2 = MathUtil.rotate(pl2, -angle, ax, ay);
            start = MathUtil.getIntersectionPoint(gl, q == 1 || q == 4 ? pl1 : pl2);
            end = MathUtil.getIntersectionPoint(gl, q == 1 || q == 4 ? pl2 : pl1);
        }
        return new Line2D.Double(start, end);
    }
}

