/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.gradient;

import java.awt.Color;
import java.awt.Paint;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;

public abstract class AbstractGradientLayer
implements CustomGraphicLayer {
    protected final List<Float> fractions;
    protected final List<Color> colors;
    protected final float[] fractionArray;
    protected final Color[] colorArray;
    protected Paint paint;

    public AbstractGradientLayer(List<Float> fractions, List<Color> colors) {
        int i;
        this.fractions = fractions;
        this.colors = colors;
        TreeMap<Float, Color> map = new TreeMap<Float, Color>();
        for (i = 0; i < fractions.size(); ++i) {
            Float frac = fractions.get(i);
            if (frac == null) continue;
            Color color = colors.size() > i ? colors.get(i) : Color.WHITE;
            map.put(frac, color);
        }
        this.fractionArray = new float[map.size()];
        this.colorArray = new Color[map.size()];
        i = 0;
        for (Map.Entry entry : map.entrySet()) {
            this.fractionArray[i] = ((Float)entry.getKey()).floatValue();
            this.colorArray[i] = entry.getValue() != null ? (Color)entry.getValue() : Color.WHITE;
            ++i;
        }
    }
}

