/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import org.cytoscape.cg.internal.util.ViewUtil;
import org.cytoscape.cg.internal.util.VisualPropertyIconFactory;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.vizmap.gui.DefaultViewPanel;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.icon.EmptyIcon;

public class ImageList
extends JXList {
    private static final int ICON_SIZE = 40;
    private final Set<CyCustomGraphics> values;
    private final Map<CyCustomGraphics, Icon> iconMap;
    private final DefaultListModel<CyCustomGraphics> model;
    private final DefaultViewPanel defViewPanel;

    public ImageList(DefaultViewPanel defViewPanel) {
        this.defViewPanel = defViewPanel;
        this.values = Collections.synchronizedSet(new LinkedHashSet());
        this.iconMap = new HashMap<CyCustomGraphics, Icon>();
        this.model = new DefaultListModel();
        this.setModel(this.model);
        this.setCellRenderer(new IconCellRenderer());
        this.setAutoCreateRowSorter(true);
        this.setSortOrder(SortOrder.ASCENDING);
        this.setSelectionMode(0);
        this.setCursor(new Cursor(12));
        final Collator collator = Collator.getInstance(Locale.getDefault());
        this.setComparator(new Comparator<CyCustomGraphics<?>>(){

            @Override
            public int compare(CyCustomGraphics<?> o1, CyCustomGraphics<?> o2) {
                return collator.compare(o1.getDisplayName(), o2.getDisplayName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderIcons(Set<CyCustomGraphics> values) {
        RenderingEngine engine;
        this.iconMap.clear();
        RenderingEngine renderingEngine = engine = this.defViewPanel != null ? this.defViewPanel.getRenderingEngine() : null;
        if (engine != null) {
            Set<CyCustomGraphics> set = values;
            synchronized (set) {
                for (CyCustomGraphics val : values) {
                    Icon icon = VisualPropertyIconFactory.createIcon(val, 40, 40);
                    if (icon == null) continue;
                    this.iconMap.put(val, icon);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListItems(Collection<CyCustomGraphics> newValues, CyCustomGraphics<?> selectedValue) {
        Set<CyCustomGraphics> set = this.values;
        synchronized (set) {
            this.values.clear();
            if (newValues != null) {
                this.values.addAll(newValues);
            }
        }
        this.renderIcons(this.values);
        this.model.removeAllElements();
        set = this.values;
        synchronized (set) {
            for (CyCustomGraphics val : this.values) {
                this.model.addElement(val);
            }
        }
        if (selectedValue != null) {
            this.setSelectedValue(selectedValue, true);
        }
        this.repaint();
    }

    private final class IconCellRenderer
    extends JPanel
    implements ListCellRenderer<CyCustomGraphics> {
        private final Color BG_COLOR = UIManager.getColor("Table.background");
        private final Color FG_COLOR = UIManager.getColor("Table.foreground");
        private final Color SELECTED_BG_COLOR = UIManager.getColor("Table.selectionBackground");
        private final Color SELECTED_FG_COLOR = UIManager.getColor("Table.selectionForeground");
        private JLabel iconLbl = new JLabel("");
        private JLabel textLbl = new JLabel("");
        private final Icon emptyIcon = new EmptyIcon(40, 40);

        public IconCellRenderer() {
            this.setOpaque(true);
            MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground"));
            Border paddingBorder = BorderFactory.createEmptyBorder(0, 4, 0, 4);
            this.setBorder(BorderFactory.createCompoundBorder(border, paddingBorder));
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.iconLbl);
            this.add(Box.createHorizontalStrut(20));
            this.add(this.textLbl);
            this.add(Box.createHorizontalGlue());
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.textLbl});
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends CyCustomGraphics> list, CyCustomGraphics value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(isSelected ? this.SELECTED_BG_COLOR : this.BG_COLOR);
            this.setForeground(isSelected ? this.SELECTED_FG_COLOR : this.FG_COLOR);
            Icon icon = ImageList.this.iconMap.get(value);
            this.iconLbl.setIcon(icon != null ? ImageList.this.iconMap.get(value) : this.emptyIcon);
            this.textLbl.setText(ViewUtil.getShortName(value.getDisplayName()));
            this.revalidate();
            return this;
        }
    }
}

