/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.ring;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.cg.internal.charts.AbstractChartLayer;
import org.cytoscape.cg.internal.charts.CustomPieSectionLabelGenerator;
import org.cytoscape.cg.internal.charts.LabelPosition;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.RingPlot;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.Rotation;

public class RingLayer
extends AbstractChartLayer<PieDataset> {
    private List<PieDataset> datasetList;
    private List<JFreeChart> chartList;
    private final Map<String, String> labels;
    private final double startAngle;
    private final double hole;
    private final org.cytoscape.cg.model.Rotation rotation;

    public RingLayer(Map<String, List<Double>> data, List<String> labels, boolean showLabels, float itemFontSize, List<Color> colors, float borderWidth, Color borderColor, double startAngle, double hole, org.cytoscape.cg.model.Rotation rotation) {
        super(data, labels, null, null, showLabels, false, false, itemFontSize, LabelPosition.STANDARD, colors, 0.0f, TRANSPARENT_COLOR, 0.0f, borderWidth, borderColor, null);
        this.startAngle = startAngle;
        this.hole = hole;
        this.rotation = rotation;
        this.labels = new HashMap<String, String>();
    }

    @Override
    public void draw(Graphics2D g, Shape shape, CyNetworkView networkView, View<? extends CyIdentifiable> view) {
        this.getChart();
        if (this.chartList.size() == 1) {
            super.draw(g, shape, networkView, view);
        } else {
            for (JFreeChart chart : this.chartList) {
                chart.draw(g, this.bounds);
            }
        }
    }

    @Override
    protected PieDataset createDataset() {
        this.datasetList = new ArrayList<PieDataset>();
        for (String category : this.data.keySet()) {
            List values = (List)this.data.get(category);
            PieDataset ds = RingLayer.createPieDataset(values);
            if (ds == null) continue;
            this.datasetList.add(ds);
        }
        if (this.showItemLabels && this.itemLabels != null && this.datasetList.size() == 1) {
            List keys = this.datasetList.get(0).getKeys();
            for (int i = 0; i < keys.size(); ++i) {
                String k = (String)keys.get(i);
                String label = this.itemLabels.size() > i ? (String)this.itemLabels.get(i) : null;
                this.labels.put(k, label);
            }
        }
        return this.datasetList.isEmpty() ? null : this.datasetList.get(0);
    }

    @Override
    protected JFreeChart getChart() {
        if (this.datasetList == null || this.chartList == null) {
            this.createDataset();
            int total = this.datasetList.size();
            this.chartList = new ArrayList<JFreeChart>(total);
            if (total > 0) {
                int count = 0;
                for (PieDataset ds : this.datasetList) {
                    double sectionDepth = (1.0 - this.hole) / (double)total * (double)(total - count);
                    JFreeChart chart = this.createChart(ds, sectionDepth, 0.004);
                    this.chartList.add(chart);
                    ++count;
                }
            } else {
                JFreeChart chart = this.createChart(RingLayer.createPieDataset(Collections.EMPTY_LIST), 1.0, 0.0);
                this.chartList.add(chart);
            }
        }
        return this.chartList == null || this.chartList.isEmpty() ? null : this.chartList.get(0);
    }

    @Override
    protected JFreeChart createChart(PieDataset dataset) {
        return this.createChart(dataset, 0.0, 0.0);
    }

    @Override
    protected BufferedImage createImage(Rectangle2D r) {
        this.getChart();
        if (this.chartList.size() == 1) {
            return super.createImage(r);
        }
        Rectangle nr = this.validateBounds(r);
        BufferedImage img = new BufferedImage(nr.width, nr.height, 2);
        Graphics g = img.getGraphics();
        for (JFreeChart chart : this.chartList) {
            Image transpImg = RingLayer.transformColorToTransparency(chart.createBufferedImage(nr.width, nr.height), TRANSPARENT_COLOR, TRANSPARENT_COLOR);
            g.drawImage(transpImg, 0, 0, null);
        }
        return img;
    }

    private JFreeChart createChart(PieDataset dataset, double sectionDepth, double interiorGap) {
        JFreeChart chart = ChartFactory.createRingChart(null, (PieDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
        chart.setAntiAlias(true);
        chart.setBorderVisible(false);
        chart.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        chart.setBackgroundImageAlpha(0.0f);
        chart.setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        RingPlot plot = (RingPlot)chart.getPlot();
        plot.setCircular(true);
        plot.setStartAngle(this.startAngle);
        plot.setDirection(this.rotation == org.cytoscape.cg.model.Rotation.ANTICLOCKWISE ? Rotation.ANTICLOCKWISE : Rotation.CLOCKWISE);
        plot.setOutlineVisible(false);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        plot.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        plot.setBackgroundAlpha(0.0f);
        plot.setShadowPaint((Paint)TRANSPARENT_COLOR);
        plot.setShadowXOffset(0.0);
        plot.setShadowYOffset(0.0);
        plot.setInnerSeparatorExtension(0.0);
        plot.setOuterSeparatorExtension(0.0);
        plot.setSectionDepth(sectionDepth);
        plot.setInteriorGap(interiorGap);
        plot.setLabelGenerator(this.showItemLabels && this.datasetList.size() == 1 ? new CustomPieSectionLabelGenerator(this.labels) : null);
        plot.setSimpleLabels(true);
        plot.setLabelBackgroundPaint((Paint)TRANSPARENT_COLOR);
        plot.setLabelOutlinePaint((Paint)TRANSPARENT_COLOR);
        plot.setLabelShadowPaint((Paint)TRANSPARENT_COLOR);
        plot.setLabelFont(plot.getLabelFont().deriveFont(this.itemFontSize));
        BasicStroke stroke = new BasicStroke(this.borderWidth, 1, 1);
        plot.setSeparatorStroke((Stroke)stroke);
        plot.setSeparatorPaint((Paint)(this.borderWidth > 0.0f ? this.borderColor : TRANSPARENT_COLOR));
        List keys = dataset.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            String k = (String)keys.get(i);
            Color c = this.colors.size() > i ? (Color)this.colors.get(i) : DEFAULT_ITEM_BG_COLOR;
            plot.setSectionPaint((Comparable)((Object)k), (Paint)c);
            plot.setSectionOutlinePaint((Comparable)((Object)k), (Paint)(this.borderWidth > 0.0f ? this.borderColor : TRANSPARENT_COLOR));
            plot.setSectionOutlineStroke((Comparable)((Object)k), (Stroke)stroke);
        }
        return chart;
    }

    private static Image transformColorToTransparency(BufferedImage image, Color c1, Color c2) {
        final int r1 = c1.getRed();
        final int g1 = c1.getGreen();
        final int b1 = c1.getBlue();
        final int r2 = c2.getRed();
        final int g2 = c2.getGreen();
        final int b2 = c2.getBlue();
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                int r = (rgb & 0xFF0000) >> 16;
                int g = (rgb & 0xFF00) >> 8;
                int b = rgb & 0xFF;
                if (r >= r1 && r <= r2 && g >= g1 && g <= g2 && b >= b1 && b <= b2) {
                    return rgb & 0xFFFFFF;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }
}

