/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.pie;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.cg.internal.charts.AbstractChartLayer;
import org.cytoscape.cg.internal.charts.CustomPieSectionLabelGenerator;
import org.cytoscape.cg.internal.charts.LabelPosition;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.Rotation;

public class PieLayer
extends AbstractChartLayer<PieDataset> {
    public static final double INTERIOR_GAP = 0.004;
    private final Map<String, String> labels;
    private final double startAngle;
    private final org.cytoscape.cg.model.Rotation rotation;

    public PieLayer(Map<String, List<Double>> data, List<String> itemLabels, boolean showLabels, float itemFontSize, List<Color> colors, float borderWidth, Color borderColor, double startAngle, org.cytoscape.cg.model.Rotation rotation) {
        super(data, itemLabels, null, null, showLabels, false, false, itemFontSize, LabelPosition.STANDARD, colors, 0.0f, TRANSPARENT_COLOR, 0.0f, borderWidth, borderColor, null);
        this.startAngle = startAngle;
        this.rotation = rotation;
        this.labels = new HashMap<String, String>();
    }

    @Override
    protected PieDataset createDataset() {
        List values = this.data.isEmpty() ? null : (List)this.data.values().iterator().next();
        PieDataset dataset = PieLayer.createPieDataset(values);
        if (this.showItemLabels && this.itemLabels != null) {
            List keys = dataset.getKeys();
            for (int i = 0; i < keys.size(); ++i) {
                String k = (String)keys.get(i);
                String label = this.itemLabels.size() > i ? (String)this.itemLabels.get(i) : null;
                this.labels.put(k, label);
            }
        }
        return dataset;
    }

    @Override
    protected JFreeChart createChart(PieDataset dataset) {
        JFreeChart chart = ChartFactory.createPieChart(null, (PieDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
        chart.setAntiAlias(true);
        chart.setBorderVisible(false);
        chart.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        chart.setBackgroundImageAlpha(0.0f);
        chart.setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setCircular(true);
        plot.setStartAngle(this.startAngle);
        plot.setDirection(this.rotation == org.cytoscape.cg.model.Rotation.ANTICLOCKWISE ? Rotation.ANTICLOCKWISE : Rotation.CLOCKWISE);
        plot.setOutlineVisible(false);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        plot.setInteriorGap(0.004);
        plot.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        plot.setBackgroundAlpha(0.0f);
        plot.setShadowPaint((Paint)TRANSPARENT_COLOR);
        plot.setShadowXOffset(0.0);
        plot.setShadowYOffset(0.0);
        plot.setLabelGenerator((PieSectionLabelGenerator)(this.showItemLabels ? new CustomPieSectionLabelGenerator(this.labels) : null));
        plot.setSimpleLabels(true);
        plot.setLabelFont(plot.getLabelFont().deriveFont(this.itemFontSize));
        plot.setLabelBackgroundPaint((Paint)TRANSPARENT_COLOR);
        plot.setLabelOutlinePaint((Paint)TRANSPARENT_COLOR);
        plot.setLabelShadowPaint((Paint)TRANSPARENT_COLOR);
        plot.setLabelPaint((Paint)this.labelColor);
        BasicStroke stroke = new BasicStroke(this.borderWidth, 1, 1);
        List keys = dataset.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            String k = (String)keys.get(i);
            Color c = this.colors.size() > i ? (Color)this.colors.get(i) : DEFAULT_ITEM_BG_COLOR;
            plot.setSectionPaint((Comparable)((Object)k), (Paint)c);
            plot.setSectionOutlinePaint((Comparable)((Object)k), (Paint)(this.borderWidth > 0.0f ? this.borderColor : TRANSPARENT_COLOR));
            plot.setSectionOutlineStroke((Comparable)((Object)k), (Stroke)stroke);
        }
        return chart;
    }
}

