/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.pie;

import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.cg.internal.charts.AbstractChartEditor;
import org.cytoscape.cg.internal.charts.ColorSchemeEditor;
import org.cytoscape.cg.internal.charts.pie.PieChart;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifier;

public class PieChartEditor
extends AbstractChartEditor<PieChart> {
    private JLabel startAngleLbl;
    private JComboBox<Double> startAngleCmb;

    public PieChartEditor(PieChart chart, CyServiceRegistrar serviceRegistrar) {
        super(chart, Number.class, false, false, false, true, false, false, false, false, serviceRegistrar);
        this.domainLabelPositionLbl.setVisible(false);
        this.getDomainLabelPositionCmb().setVisible(false);
    }

    @Override
    protected void createLabels() {
        super.createLabels();
        this.startAngleLbl = new JLabel("Start Angle (degrees):");
    }

    @Override
    protected JPanel getOtherAdvancedOptionsPnl() {
        JPanel p = super.getOtherAdvancedOptionsPnl();
        p.setVisible(true);
        GroupLayout layout = new GroupLayout(p);
        p.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(this.startAngleLbl).addComponent(this.getStartAngleCmb(), -2, -1, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.startAngleLbl).addComponent(this.getStartAngleCmb())));
        return p;
    }

    private JComboBox<Double> getStartAngleCmb() {
        if (this.startAngleCmb == null) {
            this.startAngleCmb = this.createAngleComboBox(this.chart, "cy_startAngle", ANGLES);
        }
        return this.startAngleCmb;
    }

    @Override
    protected ColorSchemeEditor<PieChart> getColorSchemeEditor() {
        if (this.colorSchemeEditor == null) {
            this.colorSchemeEditor = new PieColorSchemeEditor((PieChart)this.chart, this.getDefaultPaletteType(), this.getDefaultPaletteName(), ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork(), this.serviceRegistrar);
        }
        return this.colorSchemeEditor;
    }

    private class PieColorSchemeEditor
    extends ColorSchemeEditor<PieChart> {
        public PieColorSchemeEditor(PieChart chart, PaletteType paletteType, String defaultPaletteName, CyNetwork network, CyServiceRegistrar serviceRegistrar) {
            super(chart, false, paletteType, defaultPaletteName, network, serviceRegistrar);
        }

        @Override
        protected int getTotal() {
            if (this.total <= 0 && this.network != null) {
                List<CyColumnIdentifier> dataColumns = ((PieChart)this.chart).getList("cy_dataColumns", CyColumnIdentifier.class);
                int listCount = 0;
                int singleCount = 0;
                List allNodes = this.network.getNodeList();
                CyTable table = this.network.getDefaultNodeTable();
                for (CyColumnIdentifier colId : dataColumns) {
                    CyColumn column = table.getColumn(colId.getColumnName());
                    if (column == null) continue;
                    int count = 0;
                    if (column.getType() == List.class) {
                        for (CyNode node : allNodes) {
                            CyRow row = this.network.getRow((CyIdentifiable)node);
                            List values = row.getList(column.getName(), column.getListElementType());
                            if (values == null) continue;
                            count = Math.max(count, values.size());
                        }
                        listCount += count;
                        continue;
                    }
                    ++singleCount;
                }
                this.total = listCount + singleCount;
            }
            return this.total;
        }
    }
}

