/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts.box;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.cytoscape.cg.internal.charts.AbstractChartLayer;
import org.cytoscape.cg.internal.charts.LabelPosition;
import org.cytoscape.cg.internal.util.EqualDashStroke;
import org.cytoscape.cg.model.Orientation;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.ui.RectangleInsets;

public class BoxLayer
extends AbstractChartLayer<BoxAndWhiskerCategoryDataset> {
    private final boolean showRangeZeroBaseline;
    private final Orientation orientation;

    public BoxLayer(Map<String, List<Double>> data, boolean showRangeAxis, boolean showRangeZeroBaseline, List<Color> colors, float axisWidth, Color axisColor, float axisFontSize, float borderWidth, Color borderColor, List<Double> range, Orientation orientation) {
        super(data, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, false, false, showRangeAxis, 0.0f, LabelPosition.STANDARD, colors, axisWidth, axisColor, axisFontSize, borderWidth, borderColor, range);
        this.showRangeZeroBaseline = showRangeZeroBaseline;
        this.orientation = orientation;
    }

    @Override
    protected BoxAndWhiskerCategoryDataset createDataset() {
        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        for (String series : this.data.keySet()) {
            List values = (List)this.data.get(series);
            dataset.add(values, (Comparable)((Object)series), (Comparable)((Object)"1"));
        }
        return dataset;
    }

    @Override
    protected JFreeChart createChart(BoxAndWhiskerCategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBoxAndWhiskerChart(null, null, null, (BoxAndWhiskerCategoryDataset)dataset, (boolean)false);
        chart.setAntiAlias(true);
        chart.setBorderVisible(false);
        chart.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        chart.setBackgroundImageAlpha(0.0f);
        chart.setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setOutlineVisible(false);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        plot.setAxisOffset(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        plot.setBackgroundAlpha(0.0f);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        if (this.showRangeZeroBaseline) {
            plot.setRangeZeroBaselineVisible(true);
            plot.setRangeZeroBaselinePaint((Paint)this.axisColor);
            plot.setRangeZeroBaselineStroke((Stroke)new EqualDashStroke(this.axisWidth));
        }
        PlotOrientation plotOrientation = this.orientation == Orientation.HORIZONTAL ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        plot.setOrientation(plotOrientation);
        BasicStroke axisStroke = new BasicStroke(this.axisWidth, 1, 1);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setVisible(this.showDomainAxis);
        domainAxis.setAxisLineStroke((Stroke)axisStroke);
        domainAxis.setAxisLinePaint((Paint)this.axisColor);
        domainAxis.setTickMarksVisible(false);
        domainAxis.setTickMarkStroke((Stroke)axisStroke);
        domainAxis.setTickMarkPaint((Paint)this.axisColor);
        domainAxis.setTickLabelsVisible(false);
        domainAxis.setCategoryMargin(0.1);
        domainAxis.setLowerMargin(0.025);
        domainAxis.setUpperMargin(0.025);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setVisible(this.showRangeAxis);
        rangeAxis.setAxisLineStroke((Stroke)axisStroke);
        rangeAxis.setAxisLinePaint((Paint)this.axisColor);
        rangeAxis.setTickMarkStroke((Stroke)axisStroke);
        rangeAxis.setTickMarkPaint((Paint)this.axisColor);
        rangeAxis.setTickLabelFont(rangeAxis.getLabelFont().deriveFont(this.axisFontSize).deriveFont(0));
        rangeAxis.setTickLabelPaint((Paint)this.axisColor);
        rangeAxis.setLowerMargin(0.1);
        rangeAxis.setUpperMargin(0.1);
        if (this.range != null && this.range.size() >= 2 && this.range.get(0) != null && this.range.get(1) != null) {
            rangeAxis.setLowerBound(((Double)this.range.get(0)).doubleValue());
            rangeAxis.setUpperBound(((Double)this.range.get(1)).doubleValue());
        }
        BoxAndWhiskerRenderer renderer = (BoxAndWhiskerRenderer)plot.getRenderer();
        renderer.setFillBox(true);
        renderer.setMeanVisible(false);
        renderer.setBaseItemLabelsVisible(false);
        BasicStroke stroke = new BasicStroke(this.borderWidth, 1, 1);
        List keys = dataset.getRowKeys();
        for (int i = 0; i < keys.size(); ++i) {
            renderer.setSeriesStroke(i, (Stroke)stroke);
            renderer.setSeriesOutlineStroke(i, (Stroke)stroke);
            renderer.setSeriesOutlinePaint(i, (Paint)(this.borderWidth > 0.0f ? this.borderColor : TRANSPARENT_COLOR));
            if (this.colors == null || this.colors.size() < keys.size()) continue;
            renderer.setSeriesPaint(i, (Paint)this.colors.get(i));
        }
        return chart;
    }
}

