/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.charts;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.cg.internal.charts.ColorSchemeEditor;
import org.cytoscape.cg.internal.charts.LabelPosition;
import org.cytoscape.cg.internal.util.SortedListModel;
import org.cytoscape.cg.internal.util.ViewUtil;
import org.cytoscape.cg.model.AbstractCustomGraphics2;
import org.cytoscape.cg.model.Orientation;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.BasicCollapsiblePanel;
import org.cytoscape.util.swing.ColorButton;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifier;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifierFactory;

public abstract class AbstractChartEditor<T extends AbstractCustomGraphics2<?>>
extends JPanel {
    protected static Double[] ANGLES = new Double[]{0.0, 45.0, 90.0, 135.0, 180.0, 225.0, 270.0, 315.0};
    private BasicCollapsiblePanel basicOptionsPnl;
    private BasicCollapsiblePanel advancedOptionsPnl;
    private DataPanel dataPnl;
    private JPanel rangePnl;
    private JPanel labelsPnl;
    private JPanel orientationPnl;
    private JPanel axesPnl;
    private JPanel borderPnl;
    protected ColorSchemeEditor<T> colorSchemeEditor;
    private JPanel otherBasicOptionsPnl;
    private JPanel otherAdvancedOptionsPnl;
    protected JLabel itemLabelsColumnLbl;
    protected JLabel domainLabelsColumnLbl;
    protected JLabel rangeLabelsColumnLbl;
    private JComboBox<CyColumnIdentifier> itemLabelsColumnCmb;
    private JComboBox<CyColumnIdentifier> domainLabelsColumnCmb;
    private JComboBox<CyColumnIdentifier> rangeLabelsColumnCmb;
    protected JLabel domainLabelPositionLbl;
    protected JComboBox<LabelPosition> domainLabelPositionCmb;
    private JCheckBox globalRangeCkb;
    private JCheckBox autoRangeCkb;
    private JLabel rangeMinLbl;
    private JTextField rangeMinTxt;
    private JButton refreshRangeBtn;
    private JLabel rangeMaxLbl;
    private JTextField rangeMaxTxt;
    private JCheckBox itemLabelsVisibleCkb;
    private JCheckBox domainAxisVisibleCkb;
    private JCheckBox rangeAxisVisibleCkb;
    private JCheckBox rangeZeroBaselineVisibleCkb;
    private JLabel itemFontSizeLbl;
    private JTextField itemFontSizeTxt;
    private JLabel axisWidthLbl;
    private JTextField axisWidthTxt;
    private JLabel axisColorLbl;
    private JLabel axisFontSizeLbl;
    private JTextField axisFontSizeTxt;
    private ColorButton axisColorBtn;
    private ButtonGroup orientationGrp;
    private JRadioButton verticalRd;
    private JRadioButton horizontalRd;
    private JLabel borderWidthLbl;
    private JTextField borderWidthTxt;
    private JLabel borderColorLbl;
    private ColorButton borderColorBtn;
    protected final boolean columnIsSeries;
    protected final boolean setRange;
    protected final boolean setOrientation;
    protected final boolean setItemLabels;
    protected final boolean setDomainLabels;
    protected final boolean setRangeLabels;
    protected final boolean hasAxes;
    protected final boolean hasZeroBaseline;
    protected final Map<CyColumnIdentifier, CyColumn> columns;
    protected final Map<CyColumnIdentifier, CyColumn> labelColumns;
    protected final T chart;
    protected final Class<?> dataType;
    protected Class<? extends CyIdentifiable> targetType;
    protected boolean initializing;
    protected final CyServiceRegistrar serviceRegistrar;

    protected AbstractChartEditor(T chart, Class<?> dataType, boolean columnIsSeries, boolean setRange, boolean setOrientation, boolean setItemLabels, boolean setDomainLabels, boolean setRangeLabels, boolean hasAxes, boolean hasZeroBaseline, CyServiceRegistrar serviceRegistrar) {
        if (chart == null) {
            throw new IllegalArgumentException("'chart' argument must not be null.");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("'dataType' argument must not be null.");
        }
        if (serviceRegistrar == null) {
            throw new IllegalArgumentException("'serviceRegistrar' argument must not be null.");
        }
        this.chart = chart;
        this.columnIsSeries = columnIsSeries;
        this.dataType = dataType;
        this.setRange = setRange;
        this.setOrientation = setOrientation;
        this.setItemLabels = setItemLabels;
        this.setDomainLabels = setDomainLabels;
        this.setRangeLabels = setRangeLabels;
        this.hasAxes = hasAxes;
        this.hasZeroBaseline = hasZeroBaseline;
        this.serviceRegistrar = serviceRegistrar;
        ColumnComparator columnComparator = new ColumnComparator();
        this.columns = new TreeMap<CyColumnIdentifier, CyColumn>(columnComparator);
        this.labelColumns = new TreeMap<CyColumnIdentifier, CyColumn>(columnComparator);
        CyNetwork net = ((CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        if (net != null) {
            CyTable table = net.getDefaultNodeTable();
            Collection cols = table.getColumns();
            CyColumnIdentifierFactory colIdFactory = (CyColumnIdentifierFactory)serviceRegistrar.getService(CyColumnIdentifierFactory.class);
            for (CyColumn c : cols) {
                if (c.getName() == "SUID") continue;
                CyColumnIdentifier colId = colIdFactory.createColumnIdentifier(c.getName());
                this.columns.put(colId, c);
                if (!List.class.isAssignableFrom(c.getType())) continue;
                this.labelColumns.put(colId, c);
            }
        }
        this.init();
    }

    public void setTargetType(Class<? extends CyIdentifiable> targetType) {
        this.targetType = targetType;
        this.updateOptions();
    }

    protected void init() {
        this.initializing = true;
        try {
            this.createLabels();
            this.setOpaque(!LookAndFeelUtil.isAquaLAF());
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent((Component)this.getBasicOptionsPnl(), -1, -1, Short.MAX_VALUE).addComponent((Component)this.getAdvancedOptionsPnl(), -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)this.getBasicOptionsPnl(), -2, -1, -2).addComponent((Component)this.getAdvancedOptionsPnl(), -2, -1, -2));
            ViewUtil.recursiveDo(this, c -> LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{c}));
        }
        finally {
            this.initializing = false;
        }
        this.update(false);
    }

    protected void createLabels() {
        this.itemLabelsColumnLbl = new JLabel("Column:");
        this.itemFontSizeLbl = new JLabel("Font Size:");
        this.domainLabelsColumnLbl = new JLabel("Domain Labels Column:");
        this.rangeLabelsColumnLbl = new JLabel("Range Labels Column:");
        this.domainLabelPositionLbl = new JLabel("Domain Label Position:");
        this.rangeMinLbl = new JLabel("Min:");
        this.rangeMaxLbl = new JLabel("Max:");
        this.axisWidthLbl = new JLabel("Axis Width:");
        this.axisColorLbl = new JLabel("Axis Color:");
        this.axisFontSizeLbl = new JLabel("Axis Font Size:");
        this.borderWidthLbl = new JLabel("Border Width:");
        this.borderColorLbl = new JLabel("Border Color:");
    }

    protected BasicCollapsiblePanel getBasicOptionsPnl() {
        if (this.basicOptionsPnl == null) {
            this.basicOptionsPnl = new BasicCollapsiblePanel("Setup");
            this.basicOptionsPnl.setCollapsed(false);
            this.basicOptionsPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            GroupLayout layout = new GroupLayout(this.basicOptionsPnl.getContentPane());
            this.basicOptionsPnl.getContentPane().setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getOtherBasicOptionsPnl()).addComponent(this.getDataPnl()).addComponent(this.getRangePnl()));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getOtherBasicOptionsPnl(), -2, -1, -2).addComponent(this.getDataPnl(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getRangePnl(), -2, -1, -2));
            this.basicOptionsPnl.addCollapseListener(new BasicCollapsiblePanel.CollapseListener(){

                public void expanded() {
                    AbstractChartEditor.this.getAdvancedOptionsPnl().setCollapsed(true);
                }

                public void collapsed() {
                }
            });
        }
        return this.basicOptionsPnl;
    }

    protected BasicCollapsiblePanel getAdvancedOptionsPnl() {
        if (this.advancedOptionsPnl == null) {
            this.advancedOptionsPnl = new BasicCollapsiblePanel("Customize");
            this.advancedOptionsPnl.setCollapsed(true);
            this.advancedOptionsPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            GroupLayout layout = new GroupLayout(this.advancedOptionsPnl.getContentPane());
            this.advancedOptionsPnl.getContentPane().setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getColorSchemeEditor()).addComponent(this.getLabelsPnl()).addComponent(this.getOrientationPnl()).addComponent(this.getAxesPnl()).addComponent(this.getBorderPnl()).addComponent(this.getOtherAdvancedOptionsPnl()));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getColorSchemeEditor()).addComponent(this.getLabelsPnl()).addComponent(this.getOrientationPnl()).addComponent(this.getAxesPnl()).addComponent(this.getBorderPnl()).addComponent(this.getOtherAdvancedOptionsPnl()));
            this.advancedOptionsPnl.addCollapseListener(new BasicCollapsiblePanel.CollapseListener(){

                public void expanded() {
                    AbstractChartEditor.this.getBasicOptionsPnl().setCollapsed(true);
                }

                public void collapsed() {
                }
            });
        }
        return this.advancedOptionsPnl;
    }

    protected DataPanel getDataPnl() {
        if (this.dataPnl == null) {
            this.dataPnl = new DataPanel();
            this.dataPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.dataPnl.refresh();
        }
        return this.dataPnl;
    }

    protected JPanel getRangePnl() {
        if (this.rangePnl == null) {
            this.rangePnl = new JPanel();
            this.rangePnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.rangePnl.setVisible(this.setRange);
            if (!this.rangePnl.isVisible()) {
                return this.rangePnl;
            }
            GroupLayout layout = new GroupLayout(this.rangePnl);
            this.rangePnl.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getGlobalRangeCkb()).addGroup(layout.createSequentialGroup().addComponent(this.getAutoRangeCkb()).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rangeMinLbl).addComponent(this.getRangeMinTxt()).addComponent(this.rangeMaxLbl).addComponent(this.getRangeMaxTxt()).addComponent(this.getRefreshRangeBtn())));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getGlobalRangeCkb()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getAutoRangeCkb(), -2, -1, -2).addComponent(this.rangeMinLbl).addComponent(this.getRangeMinTxt(), -2, -1, -2).addComponent(this.rangeMaxLbl).addComponent(this.getRangeMaxTxt(), -2, -1, -2).addComponent(this.getRefreshRangeBtn(), -2, -1, -2)));
        }
        return this.rangePnl;
    }

    protected JPanel getLabelsPnl() {
        if (this.labelsPnl == null) {
            this.labelsPnl = new JPanel();
            this.labelsPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            if (!this.labelsPnl.isVisible()) {
                return this.labelsPnl;
            }
            GroupLayout layout = new GroupLayout(this.labelsPnl);
            this.labelsPnl.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            GroupLayout.ParallelGroup hGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING, true);
            GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
            if (this.setItemLabels) {
                hGroup.addGroup(layout.createSequentialGroup().addComponent(this.getItemLabelsVisibleCkb()).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.itemLabelsColumnLbl).addComponent(this.getItemLabelsColumnCmb(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.itemFontSizeLbl).addComponent(this.getItemFontSizeTxt(), -2, -1, -2));
                vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getItemLabelsVisibleCkb()).addComponent(this.itemLabelsColumnLbl).addComponent(this.getItemLabelsColumnCmb()).addComponent(this.itemFontSizeLbl).addComponent(this.getItemFontSizeTxt()));
            }
            if (this.setRangeLabels) {
                hGroup.addGroup(layout.createSequentialGroup().addComponent(this.rangeLabelsColumnLbl).addComponent(this.getRangeLabelsColumnCmb(), -2, -1, -2));
                vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.rangeLabelsColumnLbl).addComponent(this.getRangeLabelsColumnCmb()));
            }
            if (this.setDomainLabels) {
                hGroup.addGroup(layout.createSequentialGroup().addComponent(this.domainLabelsColumnLbl).addComponent(this.getDomainLabelsColumnCmb(), -2, -1, -2));
                vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.domainLabelsColumnLbl).addComponent(this.getDomainLabelsColumnCmb()));
            }
            hGroup.addGroup(layout.createSequentialGroup().addComponent(this.domainLabelPositionLbl).addComponent(this.getDomainLabelPositionCmb(), -2, -1, -2));
            vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.domainLabelPositionLbl).addComponent(this.getDomainLabelPositionCmb()));
            JSeparator sep = new JSeparator();
            hGroup.addComponent(sep);
            vGroup.addComponent(sep, -2, -1, -2);
        }
        return this.labelsPnl;
    }

    protected JPanel getOrientationPnl() {
        if (this.orientationPnl == null) {
            this.orientationPnl = new JPanel();
            this.orientationPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            GroupLayout layout = new GroupLayout(this.orientationPnl);
            this.orientationPnl.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            JSeparator sep = new JSeparator();
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(this.getVerticalRd()).addComponent(this.getHorizontalRd())).addComponent(sep));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getVerticalRd()).addComponent(this.getHorizontalRd())).addComponent(sep, -2, -1, -2));
        }
        return this.orientationPnl;
    }

    protected JPanel getAxesPnl() {
        if (this.axesPnl == null) {
            this.axesPnl = new JPanel();
            this.axesPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            GroupLayout layout = new GroupLayout(this.axesPnl);
            this.axesPnl.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            JSeparator vsep = new JSeparator(1);
            JSeparator sep = new JSeparator();
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getDomainAxisVisibleCkb()).addComponent(this.getRangeAxisVisibleCkb()).addComponent(this.getRangeZeroBaselineVisibleCkb())).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(vsep, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(this.axisWidthLbl).addComponent(this.getAxisWidthTxt(), -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.axisColorLbl).addComponent((Component)this.getAxisColorBtn(), -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.axisFontSizeLbl).addComponent(this.getAxisFontSizeTxt(), -2, -1, -2)))).addComponent(sep));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addGroup(layout.createSequentialGroup().addComponent(this.getDomainAxisVisibleCkb()).addComponent(this.getRangeAxisVisibleCkb()).addComponent(this.getRangeZeroBaselineVisibleCkb())).addComponent(vsep).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.axisWidthLbl).addComponent(this.getAxisWidthTxt(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.axisColorLbl).addComponent((Component)this.getAxisColorBtn(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.axisFontSizeLbl).addComponent(this.getAxisFontSizeTxt(), -2, -1, -2)))).addComponent(sep, -2, -1, -2));
        }
        return this.axesPnl;
    }

    protected JPanel getBorderPnl() {
        if (this.borderPnl == null) {
            this.borderPnl = new JPanel();
            this.borderPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            GroupLayout layout = new GroupLayout(this.borderPnl);
            this.borderPnl.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            JSeparator sep = new JSeparator();
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(this.borderWidthLbl).addComponent(this.getBorderWidthTxt(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.borderColorLbl).addComponent((Component)this.getBorderColorBtn(), -2, -1, -2)).addComponent(sep));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.borderWidthLbl).addComponent(this.getBorderWidthTxt()).addComponent(this.borderColorLbl).addComponent((Component)this.getBorderColorBtn())).addComponent(sep, -2, -1, -2));
        }
        return this.borderPnl;
    }

    protected ColorSchemeEditor<T> getColorSchemeEditor() {
        if (this.colorSchemeEditor == null) {
            this.colorSchemeEditor = new ColorSchemeEditor<T>(this.chart, this.columnIsSeries, this.getDefaultPaletteType(), this.getDefaultPaletteName(), ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork(), this.serviceRegistrar);
        }
        return this.colorSchemeEditor;
    }

    protected JPanel getOtherBasicOptionsPnl() {
        if (this.otherBasicOptionsPnl == null) {
            this.otherBasicOptionsPnl = new JPanel();
            this.otherBasicOptionsPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.otherBasicOptionsPnl.setVisible(false);
        }
        return this.otherBasicOptionsPnl;
    }

    protected JPanel getOtherAdvancedOptionsPnl() {
        if (this.otherAdvancedOptionsPnl == null) {
            this.otherAdvancedOptionsPnl = new JPanel();
            this.otherAdvancedOptionsPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.otherAdvancedOptionsPnl.setVisible(false);
        }
        return this.otherAdvancedOptionsPnl;
    }

    protected JComboBox<CyColumnIdentifier> getItemLabelsColumnCmb() {
        if (this.itemLabelsColumnCmb == null) {
            this.itemLabelsColumnCmb = new CyColumnComboBox(this.labelColumns.keySet(), true);
            AbstractChartEditor.selectColumnIdItem(this.itemLabelsColumnCmb, ((AbstractCustomGraphics2)this.chart).get("cy_itemLabelsColumn", CyColumnIdentifier.class));
            this.itemLabelsColumnCmb.addActionListener(evt -> {
                CyColumnIdentifier colId = (CyColumnIdentifier)this.itemLabelsColumnCmb.getSelectedItem();
                ((AbstractCustomGraphics2)this.chart).set("cy_itemLabelsColumn", colId != null ? colId.getColumnName() : null);
            });
        }
        return this.itemLabelsColumnCmb;
    }

    protected JComboBox<CyColumnIdentifier> getDomainLabelsColumnCmb() {
        if (this.domainLabelsColumnCmb == null) {
            this.domainLabelsColumnCmb = new CyColumnComboBox(this.labelColumns.keySet(), true);
            AbstractChartEditor.selectColumnIdItem(this.domainLabelsColumnCmb, ((AbstractCustomGraphics2)this.chart).get("cy_domainLabelsColumn", CyColumnIdentifier.class));
            this.domainLabelsColumnCmb.addActionListener(evt -> {
                CyColumnIdentifier colId = (CyColumnIdentifier)this.domainLabelsColumnCmb.getSelectedItem();
                ((AbstractCustomGraphics2)this.chart).set("cy_domainLabelsColumn", colId != null ? colId.getColumnName() : null);
            });
        }
        return this.domainLabelsColumnCmb;
    }

    protected JComboBox<CyColumnIdentifier> getRangeLabelsColumnCmb() {
        if (this.rangeLabelsColumnCmb == null) {
            this.rangeLabelsColumnCmb = new CyColumnComboBox(this.labelColumns.keySet(), true);
            AbstractChartEditor.selectColumnIdItem(this.rangeLabelsColumnCmb, ((AbstractCustomGraphics2)this.chart).get("cy_rangeLabelsColumn", CyColumnIdentifier.class));
            this.rangeLabelsColumnCmb.addActionListener(evt -> {
                CyColumnIdentifier colId = (CyColumnIdentifier)this.rangeLabelsColumnCmb.getSelectedItem();
                ((AbstractCustomGraphics2)this.chart).set("cy_rangeLabelsColumn", colId != null ? colId.getColumnName() : null);
            });
        }
        return this.rangeLabelsColumnCmb;
    }

    protected JCheckBox getGlobalRangeCkb() {
        if (this.globalRangeCkb == null) {
            this.globalRangeCkb = new JCheckBox("Same Value Range for All Charts");
            this.globalRangeCkb.setToolTipText("Use the same min/max values for all charts");
            this.globalRangeCkb.setSelected(((AbstractCustomGraphics2)this.chart).get("cy_globalRange", Boolean.class, (Boolean)Boolean.TRUE));
            this.globalRangeCkb.addItemListener(evt -> {
                boolean selected = evt.getStateChange() == 1;
                ((AbstractCustomGraphics2)this.chart).set("cy_globalRange", selected);
                this.updateGlobalRange();
                if (selected) {
                    this.updateRangeMinMax(((AbstractCustomGraphics2)this.chart).getList("cy_range", Double.class).isEmpty());
                }
            });
        }
        return this.globalRangeCkb;
    }

    protected JCheckBox getAutoRangeCkb() {
        if (this.autoRangeCkb == null) {
            this.autoRangeCkb = new JCheckBox("Automatic Range");
            this.autoRangeCkb.setSelected(((AbstractCustomGraphics2)this.chart).get("cy_autoRange", Boolean.class, (Boolean)Boolean.TRUE));
            this.autoRangeCkb.addItemListener(evt -> {
                boolean selected = evt.getStateChange() == 1;
                this.getRangeMinTxt().setEnabled(!selected);
                this.getRangeMaxTxt().setEnabled(!selected);
                this.getRangeMinTxt().requestFocus();
                ((AbstractCustomGraphics2)this.chart).set("cy_autoRange", selected);
                if (selected) {
                    this.updateRangeMinMax(true);
                }
            });
        }
        return this.autoRangeCkb;
    }

    protected JTextField getRangeMinTxt() {
        if (this.rangeMinTxt == null) {
            this.rangeMinTxt = new JTextField();
            Boolean auto = ((AbstractCustomGraphics2)this.chart).get("cy_autoRange", Boolean.class, (Boolean)Boolean.TRUE);
            this.rangeMinTxt.setEnabled(auto == false);
            this.rangeMinTxt.setInputVerifier(new DoubleInputVerifier());
            this.rangeMinTxt.setMinimumSize(new Dimension(60, this.rangeMinTxt.getMinimumSize().height));
            this.rangeMinTxt.setHorizontalAlignment(11);
            this.rangeMinTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    AbstractChartEditor.this.setGlobalRange();
                }
            });
        }
        return this.rangeMinTxt;
    }

    protected JTextField getRangeMaxTxt() {
        if (this.rangeMaxTxt == null) {
            this.rangeMaxTxt = new JTextField();
            Boolean auto = ((AbstractCustomGraphics2)this.chart).get("cy_autoRange", Boolean.class, (Boolean)Boolean.TRUE);
            this.rangeMaxTxt.setEnabled(auto == false);
            this.rangeMaxTxt.setInputVerifier(new DoubleInputVerifier());
            this.rangeMaxTxt.setMinimumSize(new Dimension(60, this.rangeMaxTxt.getMinimumSize().height));
            this.rangeMaxTxt.setHorizontalAlignment(11);
            this.rangeMaxTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    AbstractChartEditor.this.setGlobalRange();
                }
            });
        }
        return this.rangeMaxTxt;
    }

    protected JButton getRefreshRangeBtn() {
        if (this.refreshRangeBtn == null) {
            this.refreshRangeBtn = new JButton("\uf021");
            this.refreshRangeBtn.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(12.0f));
            this.refreshRangeBtn.setToolTipText("Refresh automatic range values");
            this.refreshRangeBtn.addActionListener(evt -> {
                this.updateRangeMinMax(true);
                this.refreshRangeBtn.setEnabled(false);
            });
        }
        return this.refreshRangeBtn;
    }

    protected JCheckBox getItemLabelsVisibleCkb() {
        if (this.itemLabelsVisibleCkb == null) {
            this.itemLabelsVisibleCkb = new JCheckBox("Show Value Labels");
            this.itemLabelsVisibleCkb.setVisible(this.setItemLabels);
            if (this.setItemLabels) {
                this.itemLabelsVisibleCkb.setSelected(((AbstractCustomGraphics2)this.chart).get("cy_showItemLabels", Boolean.class, false));
                this.itemLabelsVisibleCkb.addActionListener(evt -> {
                    ((AbstractCustomGraphics2)this.chart).set("cy_showItemLabels", this.itemLabelsVisibleCkb.isSelected());
                    this.itemLabelsColumnLbl.setEnabled(this.itemLabelsVisibleCkb.isSelected());
                    this.getItemLabelsColumnCmb().setEnabled(this.itemLabelsVisibleCkb.isSelected());
                    this.itemFontSizeLbl.setEnabled(this.itemLabelsVisibleCkb.isSelected());
                    this.getItemFontSizeTxt().setEnabled(this.itemLabelsVisibleCkb.isSelected());
                });
            }
        }
        return this.itemLabelsVisibleCkb;
    }

    protected JCheckBox getDomainAxisVisibleCkb() {
        if (this.domainAxisVisibleCkb == null) {
            this.domainAxisVisibleCkb = new JCheckBox("Show Domain Axis");
            this.domainAxisVisibleCkb.setVisible(this.hasAxes);
            if (this.hasAxes) {
                this.domainAxisVisibleCkb.setSelected(((AbstractCustomGraphics2)this.chart).get("cy_showDomainAxis", Boolean.class, false));
                this.domainAxisVisibleCkb.addActionListener(evt -> ((AbstractCustomGraphics2)this.chart).set("cy_showDomainAxis", this.domainAxisVisibleCkb.isSelected()));
            }
        }
        return this.domainAxisVisibleCkb;
    }

    protected JCheckBox getRangeAxisVisibleCkb() {
        if (this.rangeAxisVisibleCkb == null) {
            this.rangeAxisVisibleCkb = new JCheckBox("Show Range Axis");
            this.rangeAxisVisibleCkb.setVisible(this.hasAxes);
            if (this.hasAxes) {
                this.rangeAxisVisibleCkb.setSelected(((AbstractCustomGraphics2)this.chart).get("cy_showRangeAxis", Boolean.class, false));
                this.rangeAxisVisibleCkb.addActionListener(evt -> ((AbstractCustomGraphics2)this.chart).set("cy_showRangeAxis", this.rangeAxisVisibleCkb.isSelected()));
            }
        }
        return this.rangeAxisVisibleCkb;
    }

    protected JCheckBox getRangeZeroBaselineVisibleCkb() {
        if (this.rangeZeroBaselineVisibleCkb == null) {
            this.rangeZeroBaselineVisibleCkb = new JCheckBox("Show Zero Baseline");
            this.rangeZeroBaselineVisibleCkb.setVisible(this.hasZeroBaseline);
            if (this.hasAxes) {
                this.rangeZeroBaselineVisibleCkb.setSelected(((AbstractCustomGraphics2)this.chart).get("cy_showRangeZeroBaseline", Boolean.class, false));
                this.rangeZeroBaselineVisibleCkb.addActionListener(evt -> ((AbstractCustomGraphics2)this.chart).set("cy_showRangeZeroBaseline", this.rangeZeroBaselineVisibleCkb.isSelected()));
            }
        }
        return this.rangeZeroBaselineVisibleCkb;
    }

    public JComboBox<LabelPosition> getDomainLabelPositionCmb() {
        if (this.domainLabelPositionCmb == null) {
            this.domainLabelPositionCmb = new JComboBox<LabelPosition>(LabelPosition.values());
            this.domainLabelPositionCmb.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel lbl = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (value instanceof LabelPosition) {
                        lbl.setText(((LabelPosition)((Object)value)).getLabel());
                    }
                    return lbl;
                }
            });
            this.domainLabelPositionCmb.setSelectedItem((Object)((AbstractCustomGraphics2)this.chart).get("cy_domainLabelPosition", LabelPosition.class, (LabelPosition)LabelPosition.STANDARD));
            this.domainLabelPositionCmb.addActionListener(evt -> {
                LabelPosition position = (LabelPosition)((Object)((Object)this.domainLabelPositionCmb.getSelectedItem()));
                ((AbstractCustomGraphics2)this.chart).set("cy_domainLabelPosition", (Object)position);
            });
        }
        return this.domainLabelPositionCmb;
    }

    protected JTextField getAxisWidthTxt() {
        if (this.axisWidthTxt == null) {
            this.axisWidthTxt = new JTextField("" + ((AbstractCustomGraphics2)this.chart).get("cy_axisWidth", Float.class, (Float)Float.valueOf(0.25f)));
            this.axisWidthTxt.setInputVerifier(new DoubleInputVerifier());
            this.axisWidthTxt.setPreferredSize(new Dimension(60, this.axisWidthTxt.getMinimumSize().height));
            this.axisWidthTxt.setHorizontalAlignment(11);
            this.axisWidthTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    try {
                        float v = Float.parseFloat(AbstractChartEditor.this.axisWidthTxt.getText());
                        ((AbstractCustomGraphics2)AbstractChartEditor.this.chart).set("cy_axisWidth", Float.valueOf(v));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
        }
        return this.axisWidthTxt;
    }

    protected ColorButton getAxisColorBtn() {
        if (this.axisColorBtn == null) {
            Color color = ((AbstractCustomGraphics2)this.chart).get("cy_axisColor", Color.class, (Color)Color.DARK_GRAY);
            this.axisColorBtn = new ColorButton(this.serviceRegistrar, null, (PaletteType)BrewerType.ANY, color, false);
            this.axisColorBtn.setVisible(this.hasAxes);
            this.axisColorBtn.addPropertyChangeListener("color", evt -> {
                Color newColor = (Color)evt.getNewValue();
                ((AbstractCustomGraphics2)this.chart).set("cy_axisColor", newColor);
            });
        }
        return this.axisColorBtn;
    }

    protected JTextField getItemFontSizeTxt() {
        if (this.itemFontSizeTxt == null) {
            this.itemFontSizeTxt = new JTextField("" + ((AbstractCustomGraphics2)this.chart).get("cy_itemLabelFontSize", Integer.class, 1));
            this.itemFontSizeTxt.setInputVerifier(new IntInputVerifier());
            this.itemFontSizeTxt.setPreferredSize(new Dimension(40, this.itemFontSizeTxt.getMinimumSize().height));
            this.itemFontSizeTxt.setHorizontalAlignment(11);
            this.itemFontSizeTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    try {
                        int v = Integer.parseInt(AbstractChartEditor.this.itemFontSizeTxt.getText());
                        ((AbstractCustomGraphics2)AbstractChartEditor.this.chart).set("cy_itemLabelFontSize", v);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
        }
        return this.itemFontSizeTxt;
    }

    protected JTextField getAxisFontSizeTxt() {
        if (this.axisFontSizeTxt == null) {
            this.axisFontSizeTxt = new JTextField("" + ((AbstractCustomGraphics2)this.chart).get("cy_axisLabelFontSize", Integer.class, 1));
            this.axisFontSizeTxt.setInputVerifier(new IntInputVerifier());
            this.axisFontSizeTxt.setPreferredSize(new Dimension(60, this.axisFontSizeTxt.getMinimumSize().height));
            this.axisFontSizeTxt.setHorizontalAlignment(11);
            this.axisFontSizeTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    try {
                        int v = Integer.parseInt(AbstractChartEditor.this.axisFontSizeTxt.getText());
                        ((AbstractCustomGraphics2)AbstractChartEditor.this.chart).set("cy_axisLabelFontSize", v);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
        }
        return this.axisFontSizeTxt;
    }

    private ButtonGroup getOrientationGrp() {
        if (this.orientationGrp == null) {
            this.orientationGrp = new ButtonGroup();
            this.orientationGrp.add(this.getVerticalRd());
            this.orientationGrp.add(this.getHorizontalRd());
        }
        return this.orientationGrp;
    }

    protected JRadioButton getVerticalRd() {
        if (this.verticalRd == null) {
            this.verticalRd = new JRadioButton("Vertical Orientation");
            this.verticalRd.setVisible(this.setOrientation);
            if (this.setOrientation) {
                this.verticalRd.addActionListener(evt -> this.setOrientation());
            }
        }
        return this.verticalRd;
    }

    protected JRadioButton getHorizontalRd() {
        if (this.horizontalRd == null) {
            this.horizontalRd = new JRadioButton("Horizontal Orientation");
            this.horizontalRd.setVisible(this.setOrientation);
            if (this.setOrientation) {
                this.horizontalRd.addActionListener(evt -> this.setOrientation());
            }
        }
        return this.horizontalRd;
    }

    protected void setOrientation() {
        Orientation orientation = this.getHorizontalRd().isSelected() ? Orientation.HORIZONTAL : Orientation.VERTICAL;
        ((AbstractCustomGraphics2)this.chart).set("cy_orientation", (Object)orientation);
    }

    protected JTextField getBorderWidthTxt() {
        if (this.borderWidthTxt == null) {
            this.borderWidthTxt = new JTextField("" + ((AbstractCustomGraphics2)this.chart).get("cy_borderWidth", Float.class, (Float)Float.valueOf(0.25f)));
            this.borderWidthTxt.setInputVerifier(new DoubleInputVerifier());
            this.borderWidthTxt.setPreferredSize(new Dimension(60, this.borderWidthTxt.getMinimumSize().height));
            this.borderWidthTxt.setHorizontalAlignment(11);
            this.borderWidthTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    try {
                        float v = Float.parseFloat(AbstractChartEditor.this.borderWidthTxt.getText());
                        ((AbstractCustomGraphics2)AbstractChartEditor.this.chart).set("cy_borderWidth", Float.valueOf(v));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
        }
        return this.borderWidthTxt;
    }

    protected ColorButton getBorderColorBtn() {
        if (this.borderColorBtn == null) {
            Color color = ((AbstractCustomGraphics2)this.chart).get("cy_borderColor", Color.class, (Color)Color.DARK_GRAY);
            this.borderColorBtn = new ColorButton(this.serviceRegistrar, null, (PaletteType)BrewerType.ANY, color, false);
            this.borderColorBtn.addPropertyChangeListener("color", evt -> {
                Color newColor = (Color)evt.getNewValue();
                ((AbstractCustomGraphics2)this.chart).set("cy_borderColor", newColor);
            });
        }
        return this.borderColorBtn;
    }

    protected List<Double> calculateAutoRange() {
        ArrayList<Double> range = new ArrayList<Double>(2);
        CyNetwork net = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        if (net != null) {
            List nodes = net.getNodeList();
            List<CyColumnIdentifier> dataColumns = this.getDataPnl().getDataColumns();
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (CyColumnIdentifier colId : dataColumns) {
                CyColumn column = this.columns.get(colId);
                if (column == null) continue;
                Class colType = column.getType();
                Class colListType = column.getListElementType();
                if (!Number.class.isAssignableFrom(colType) && (!List.class.isAssignableFrom(colType) || !Number.class.isAssignableFrom(colListType))) continue;
                for (CyNode n : nodes) {
                    List<Number> values = null;
                    CyRow row = net.getRow((CyIdentifiable)n);
                    if (List.class.isAssignableFrom(colType)) {
                        values = row.getList(column.getName(), colListType);
                    } else if (row.isSet(column.getName())) {
                        values = Collections.singletonList((Number)row.get(column.getName(), colType));
                    }
                    double[] mm = this.minMax(min, max, (List<Number>)values);
                    min = mm[0];
                    max = mm[1];
                }
            }
            if (min != Double.POSITIVE_INFINITY && max != Double.NEGATIVE_INFINITY) {
                range.add(min);
                range.add(max);
            }
        }
        return range;
    }

    protected double[] minMax(double min, double max, List<? extends Number> values) {
        if (values != null) {
            for (Number number : values) {
                if (number == null) continue;
                double dv = number.doubleValue();
                min = Math.min(min, dv);
                max = Math.max(max, dv);
            }
        }
        return new double[]{min, max};
    }

    protected void update(boolean recalculateRange) {
        if (this.setOrientation) {
            this.updateOrientation();
        }
        this.updateGlobalRange();
        this.updateRangeMinMax(recalculateRange);
        this.updateItemLabel();
        this.updateOptions();
    }

    protected void updateOptions() {
        boolean sparklines = this.targetType == CyColumn.class;
        this.getLabelsPnl().setVisible(!sparklines && (this.setItemLabels || this.setDomainLabels || this.setRangeLabels));
        this.getOrientationPnl().setVisible(!sparklines && this.setOrientation);
        this.getAxesPnl().setVisible(!sparklines && this.hasAxes);
        this.getBorderPnl().setVisible(!sparklines);
        if (sparklines) {
            ((AbstractCustomGraphics2)this.chart).set("cy_borderWidth", Float.valueOf(0.0f));
        }
    }

    protected void updateOrientation() {
        Orientation orientation = ((AbstractCustomGraphics2)this.chart).get("cy_orientation", Orientation.class, (Orientation)Orientation.VERTICAL);
        JRadioButton orientRd = orientation == Orientation.HORIZONTAL ? this.getHorizontalRd() : this.getVerticalRd();
        this.getOrientationGrp().setSelected(orientRd.getModel(), true);
    }

    protected void updateGlobalRange() {
        Boolean global = ((AbstractCustomGraphics2)this.chart).get("cy_globalRange", Boolean.class, (Boolean)Boolean.TRUE);
        this.getAutoRangeCkb().setVisible(global);
        this.rangeMinLbl.setVisible(global);
        this.rangeMaxLbl.setVisible(global);
        this.getRangeMinTxt().setVisible(global);
        this.getRangeMaxTxt().setVisible(global);
        this.getRefreshRangeBtn().setVisible(global);
    }

    protected void updateItemLabel() {
        Boolean showItemLabels = ((AbstractCustomGraphics2)this.chart).get("cy_showItemLabels", Boolean.class, (Boolean)Boolean.FALSE);
        this.itemLabelsColumnLbl.setEnabled(showItemLabels);
        this.getItemLabelsColumnCmb().setEnabled(showItemLabels);
        this.itemFontSizeLbl.setEnabled(showItemLabels);
        this.getItemFontSizeTxt().setEnabled(showItemLabels);
    }

    protected void updateRangeMinMax(boolean recalculate) {
        Boolean global = ((AbstractCustomGraphics2)this.chart).get("cy_globalRange", Boolean.class, (Boolean)Boolean.TRUE);
        if (global.booleanValue() && this.setRange) {
            Boolean auto = ((AbstractCustomGraphics2)this.chart).get("cy_autoRange", Boolean.class, (Boolean)Boolean.TRUE);
            List<Double> range = ((AbstractCustomGraphics2)this.chart).getList("cy_range", Double.class);
            if (auto.booleanValue()) {
                if (recalculate) {
                    range = this.calculateAutoRange();
                    this.getRefreshRangeBtn().setEnabled(false);
                } else {
                    this.updateRefreshRangeBtn();
                }
            }
            if (range != null && range.size() >= 2) {
                ((AbstractCustomGraphics2)this.chart).set("cy_range", range);
                this.getRangeMinTxt().setText("" + range.get(0));
                this.getRangeMaxTxt().setText("" + range.get(1));
            }
        }
    }

    private void updateRefreshRangeBtn() {
        if (this.setRange) {
            boolean b = ((AbstractCustomGraphics2)this.chart).get("cy_globalRange", Boolean.class, (Boolean)Boolean.TRUE);
            boolean bl = b = b && ((AbstractCustomGraphics2)this.chart).get("cy_autoRange", Boolean.class, (Boolean)Boolean.TRUE) != false;
            if (b) {
                List<Double> range = ((AbstractCustomGraphics2)this.chart).getList("cy_range", Double.class);
                b = b && (range == null || !range.equals(this.calculateAutoRange()));
            }
            this.getRefreshRangeBtn().setEnabled(b);
        }
    }

    private void setGlobalRange() {
        Boolean global = ((AbstractCustomGraphics2)this.chart).get("cy_globalRange", Boolean.class, (Boolean)Boolean.TRUE);
        if (global.booleanValue() && this.setRange) {
            String minTxt = this.getRangeMinTxt().getText().trim();
            String maxTxt = this.getRangeMaxTxt().getText().trim();
            try {
                double min = Double.parseDouble(minTxt);
                double max = Double.parseDouble(maxTxt);
                ((AbstractCustomGraphics2)this.chart).set("cy_range", Arrays.asList(min, max));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected boolean isDataColumn(CyColumn c) {
        Class colType = c.getType();
        Class colListType = c.getListElementType();
        return this.dataType.isAssignableFrom(colType) || List.class.isAssignableFrom(colType) && this.dataType.isAssignableFrom(colListType);
    }

    protected static void selectColumnIdItem(JComboBox<CyColumnIdentifier> cmb, CyColumnIdentifier columnId) {
        if (columnId != null) {
            for (int i = 0; i < cmb.getItemCount(); ++i) {
                CyColumnIdentifier colId = cmb.getItemAt(i);
                if (colId == null || !colId.equals(columnId)) continue;
                cmb.setSelectedItem(colId);
                break;
            }
        }
    }

    protected JComboBox<Double> createAngleComboBox(AbstractCustomGraphics2<?> cg2, String propKey, Double[] values) {
        if (values == null) {
            values = ANGLES;
        }
        JComboBox<Double> cmb = new JComboBox<Double>(values);
        cmb.setToolTipText("Starting from 3 o'clock and measuring clockwise (90\u00b0 = 6 o'clock)");
        cmb.setEditable(true);
        ((JLabel)((Object)cmb.getRenderer())).setHorizontalAlignment(4);
        cmb.setSelectedItem(cg2.get(propKey, Double.class, 0.0));
        cmb.setInputVerifier(new DoubleInputVerifier());
        cmb.addActionListener(evt -> {
            Object angle = cmb.getSelectedItem();
            try {
                cg2.set(propKey, angle instanceof Number ? ((Number)angle).doubleValue() : 0.0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        return cmb;
    }

    protected PaletteType getDefaultPaletteType() {
        return BrewerType.ANY;
    }

    protected String getDefaultPaletteName() {
        return "Set3 colors";
    }

    protected static class CyColumnCellRenderer
    extends DefaultListCellRenderer {
        private final boolean showCount;

        public CyColumnCellRenderer() {
            this(false);
        }

        public CyColumnCellRenderer(boolean showCount) {
            this.showCount = showCount;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DefaultListCellRenderer c = (DefaultListCellRenderer)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                c.setText("-- none --");
            } else if (value instanceof CyColumnIdentifier) {
                if (this.showCount) {
                    int totalLength = (int)(Math.log10(list.getModel().getSize()) + 1.0);
                    int idxLength = (int)(Math.log10(index + 1) + 1.0);
                    int dif = totalLength - idxLength;
                    Object count = "";
                    while (dif-- > 0) {
                        count = (String)count + "&nbsp;";
                    }
                    count = (String)count + (index + 1) + ". ";
                    c.setText("<html><font face='Monospaced'>" + (String)count + "</font>" + ((CyColumnIdentifier)value).getColumnName() + "</html>");
                } else {
                    c.setText(((CyColumnIdentifier)value).getColumnName());
                }
            } else {
                c.setText("[ invalid column ]");
            }
            return c;
        }
    }

    protected static class CyColumnComboBox
    extends JComboBox<CyColumnIdentifier> {
        public CyColumnComboBox(Collection<CyColumnIdentifier> columnIds, boolean acceptsNull) {
            ArrayList<CyColumnIdentifier> values = new ArrayList<CyColumnIdentifier>(columnIds);
            if (acceptsNull && !values.contains(null)) {
                values.add(0, null);
            }
            DefaultComboBoxModel<CyColumnIdentifier> model = new DefaultComboBoxModel<CyColumnIdentifier>(values.toArray(new CyColumnIdentifier[values.size()]));
            this.setModel(model);
            this.setRenderer(new CyColumnCellRenderer());
        }
    }

    public static class IntInputVerifier
    extends InputVerifier {
        @Override
        public boolean verify(JComponent input) {
            try {
                Integer.parseInt(((JTextField)input).getText().trim());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    public static class DoubleInputVerifier
    extends InputVerifier {
        @Override
        public boolean verify(JComponent input) {
            try {
                Double.parseDouble(((JTextField)input).getText().trim());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    public class ColumnComparator
    implements Comparator<CyColumnIdentifier> {
        private final Collator collator = Collator.getInstance(Locale.getDefault());

        @Override
        public int compare(CyColumnIdentifier c1, CyColumnIdentifier c2) {
            return this.collator.compare(c1.getColumnName(), c2.getColumnName());
        }
    }

    protected class DataPanel
    extends JPanel {
        private final Set<CyColumnIdentifier> dataColumns = new LinkedHashSet<CyColumnIdentifier>();
        private JList<CyColumnIdentifier> allColumnsLs;
        private JList<CyColumnIdentifier> selColumnsLs;
        private final DefaultListModel<CyColumnIdentifier> allModel = new DefaultListModel();
        private final DefaultListModel<CyColumnIdentifier> selModel = new DefaultListModel();
        private JButton addBtn;
        private JButton addAllBtn;
        private JButton removeBtn;
        private JButton removeAllBtn;
        private JButton moveUpBtn;
        private JButton moveDownBtn;

        protected DataPanel() {
            for (CyColumnIdentifier colId : AbstractChartEditor.this.columns.keySet()) {
                CyColumn c = AbstractChartEditor.this.columns.get(colId);
                if (!AbstractChartEditor.this.isDataColumn(c)) continue;
                this.dataColumns.add(colId);
            }
            JLabel allColumnsLbl = new JLabel("Available Columns:");
            JLabel selColumnsLbl = new JLabel("Selected Columns:");
            JScrollPane listScr1 = new JScrollPane(this.getAllColumnsLs());
            listScr1.setPreferredSize(new Dimension(200, listScr1.getPreferredSize().height));
            JScrollPane listScr2 = new JScrollPane(this.getSelColumnsLs());
            listScr2.setPreferredSize(new Dimension(200, listScr2.getPreferredSize().height));
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(LookAndFeelUtil.isWinLAF());
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(allColumnsLbl, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(listScr1, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getAddBtn(), -1, -1, Short.MAX_VALUE).addComponent(this.getAddAllBtn(), -1, -1, Short.MAX_VALUE).addComponent(this.getRemoveBtn(), -1, -1, Short.MAX_VALUE).addComponent(this.getRemoveAllBtn(), -1, -1, Short.MAX_VALUE)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(selColumnsLbl, -1, -1, Short.MAX_VALUE).addComponent(this.getMoveUpBtn(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getMoveDownBtn(), -2, -1, -2)).addComponent(listScr2, -1, -1, Short.MAX_VALUE))));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(allColumnsLbl, -2, -1, -2).addComponent(selColumnsLbl, -2, -1, -2).addComponent(this.getMoveUpBtn(), -2, -1, -2).addComponent(this.getMoveDownBtn(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, true).addComponent(listScr1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.getAddBtn(), -2, -1, -2).addComponent(this.getAddAllBtn(), -2, -1, -2).addGap(0, 20, Short.MAX_VALUE).addComponent(this.getRemoveBtn(), -2, -1, -2).addComponent(this.getRemoveAllBtn(), -2, -1, -2)).addComponent(listScr2, -1, -1, Short.MAX_VALUE)));
        }

        protected void refresh() {
            List<CyColumnIdentifier> chartDataColumns = ((AbstractCustomGraphics2)AbstractChartEditor.this.chart).getList("cy_dataColumns", CyColumnIdentifier.class);
            for (CyColumnIdentifier colId : chartDataColumns) {
                this.selModel.addElement(colId);
            }
            if (this.dataColumns != null) {
                for (CyColumnIdentifier colId : this.dataColumns) {
                    if (chartDataColumns.contains(colId)) continue;
                    this.allModel.addElement(colId);
                }
            }
            if (this.selModel.getSize() == 0 && this.allModel.getSize() > 0) {
                CyColumnIdentifier colId = this.allModel.get(0);
                this.allModel.removeElement(colId);
                this.selModel.addElement(colId);
                ((AbstractCustomGraphics2)AbstractChartEditor.this.chart).set("cy_dataColumns", this.getDataColumns());
                AbstractChartEditor.this.updateRangeMinMax(true);
            }
            this.updateButtons();
            AbstractChartEditor.this.getColorSchemeEditor().reset(false);
        }

        private JList<CyColumnIdentifier> getAllColumnsLs() {
            if (this.allColumnsLs == null) {
                this.allColumnsLs = new JList();
                this.allColumnsLs.setModel(new SortedListModel<CyColumnIdentifier>(this.allModel, SortedListModel.SortOrder.ASCENDING, new ColumnComparator()));
                this.allColumnsLs.setCellRenderer(new CyColumnCellRenderer(true));
                this.allColumnsLs.getSelectionModel().addListSelectionListener(evt -> this.updateButtons());
                this.allColumnsLs.getModel().addListDataListener(new ListDataListener(){

                    @Override
                    public void intervalRemoved(ListDataEvent e) {
                        DataPanel.this.updateButtons();
                    }

                    @Override
                    public void intervalAdded(ListDataEvent e) {
                        DataPanel.this.updateButtons();
                    }

                    @Override
                    public void contentsChanged(ListDataEvent e) {
                    }
                });
            }
            return this.allColumnsLs;
        }

        private JList<CyColumnIdentifier> getSelColumnsLs() {
            if (this.selColumnsLs == null) {
                this.selColumnsLs = new JList();
                this.selColumnsLs.setModel(this.selModel);
                this.selColumnsLs.setCellRenderer(new CyColumnCellRenderer(true));
                this.selColumnsLs.getSelectionModel().addListSelectionListener(evt -> this.updateButtons());
            }
            return this.selColumnsLs;
        }

        private JButton getAddBtn() {
            if (this.addBtn == null) {
                this.addBtn = new JButton("\uf105");
                this.addBtn.setFont(((IconManager)AbstractChartEditor.this.serviceRegistrar.getService(IconManager.class)).getIconFont(14.0f));
                this.addBtn.setToolTipText("Add Selected");
                this.addBtn.addActionListener(evt -> this.moveDataColumns(this.getAllColumnsLs(), this.getSelColumnsLs(), false));
            }
            return this.addBtn;
        }

        private JButton getAddAllBtn() {
            if (this.addAllBtn == null) {
                this.addAllBtn = new JButton("\uf101");
                this.addAllBtn.setFont(((IconManager)AbstractChartEditor.this.serviceRegistrar.getService(IconManager.class)).getIconFont(14.0f));
                this.addAllBtn.setToolTipText("Add All");
                this.addAllBtn.addActionListener(evt -> this.moveDataColumns(this.getAllColumnsLs(), this.getSelColumnsLs(), true));
            }
            return this.addAllBtn;
        }

        private JButton getRemoveBtn() {
            if (this.removeBtn == null) {
                this.removeBtn = new JButton("\uf104");
                this.removeBtn.setFont(((IconManager)AbstractChartEditor.this.serviceRegistrar.getService(IconManager.class)).getIconFont(14.0f));
                this.removeBtn.setToolTipText("Remove Selected");
                this.removeBtn.addActionListener(evt -> this.moveDataColumns(this.getSelColumnsLs(), this.getAllColumnsLs(), false));
            }
            return this.removeBtn;
        }

        private JButton getRemoveAllBtn() {
            if (this.removeAllBtn == null) {
                this.removeAllBtn = new JButton("\uf100");
                this.removeAllBtn.setFont(((IconManager)AbstractChartEditor.this.serviceRegistrar.getService(IconManager.class)).getIconFont(14.0f));
                this.removeAllBtn.setToolTipText("Remove All");
                this.removeAllBtn.addActionListener(evt -> this.moveDataColumns(this.getSelColumnsLs(), this.getAllColumnsLs(), true));
            }
            return this.removeAllBtn;
        }

        private JButton getMoveUpBtn() {
            if (this.moveUpBtn == null) {
                this.moveUpBtn = new JButton("\uf0d8");
                this.moveUpBtn.setFont(((IconManager)AbstractChartEditor.this.serviceRegistrar.getService(IconManager.class)).getIconFont(17.0f));
                this.moveUpBtn.setToolTipText("Move Selected Up");
                this.moveUpBtn.setBorderPainted(false);
                this.moveUpBtn.setContentAreaFilled(false);
                this.moveUpBtn.setOpaque(false);
                this.moveUpBtn.setFocusPainted(false);
                this.moveUpBtn.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
                this.moveUpBtn.addActionListener(evt -> this.moveUp(this.getSelColumnsLs()));
            }
            return this.moveUpBtn;
        }

        private JButton getMoveDownBtn() {
            if (this.moveDownBtn == null) {
                this.moveDownBtn = new JButton("\uf0d7");
                this.moveDownBtn.setFont(((IconManager)AbstractChartEditor.this.serviceRegistrar.getService(IconManager.class)).getIconFont(17.0f));
                this.moveDownBtn.setToolTipText("Move Selected Down");
                this.moveDownBtn.setBorderPainted(false);
                this.moveDownBtn.setContentAreaFilled(false);
                this.moveDownBtn.setOpaque(false);
                this.moveDownBtn.setFocusPainted(false);
                this.moveDownBtn.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
                this.moveDownBtn.addActionListener(evt -> this.moveDown(this.getSelColumnsLs()));
            }
            return this.moveDownBtn;
        }

        private void updateButtons() {
            this.getAddBtn().setEnabled(!this.getAllColumnsLs().getSelectionModel().isSelectionEmpty());
            this.getRemoveBtn().setEnabled(!this.getSelColumnsLs().getSelectionModel().isSelectionEmpty());
            this.getAddAllBtn().setEnabled(this.getAllColumnsLs().getModel().getSize() > 0);
            this.getRemoveAllBtn().setEnabled(this.getSelColumnsLs().getModel().getSize() > 0);
            int[] selIndices = this.getSelColumnsLs().getSelectedIndices();
            int size = this.getSelColumnsLs().getModel().getSize();
            boolean b = selIndices != null && selIndices.length > 0;
            this.getMoveUpBtn().setEnabled(b && selIndices[0] > 0);
            this.getMoveDownBtn().setEnabled(b && selIndices[selIndices.length - 1] < size - 1);
        }

        private void moveDataColumns(JList<CyColumnIdentifier> src, JList<CyColumnIdentifier> tgt, boolean all) {
            HashSet<CyColumnIdentifier> set = new HashSet<CyColumnIdentifier>();
            DefaultListModel srcModel = src.getModel() instanceof SortedListModel ? (DefaultListModel)((SortedListModel)src.getModel()).getUnsortedModel() : (DefaultListModel)src.getModel();
            DefaultListModel tgtModel = tgt.getModel() instanceof SortedListModel ? (DefaultListModel)((SortedListModel)tgt.getModel()).getUnsortedModel() : (DefaultListModel)tgt.getModel();
            for (int i = 0; i < srcModel.getSize(); ++i) {
                int index = i;
                if (src.getModel() instanceof SortedListModel) {
                    index = ((SortedListModel)src.getModel()).toUnsortedModelIndex(i);
                }
                CyColumnIdentifier colId = (CyColumnIdentifier)srcModel.get(index);
                if (!all && !src.isSelectedIndex(i)) continue;
                set.add(colId);
                if (tgtModel.contains(colId)) continue;
                tgtModel.addElement(colId);
            }
            for (CyColumnIdentifier colId : set) {
                srcModel.removeElement(colId);
            }
            ((AbstractCustomGraphics2)AbstractChartEditor.this.chart).set("cy_dataColumns", this.getDataColumns());
            if (!AbstractChartEditor.this.initializing) {
                AbstractChartEditor.this.updateRangeMinMax(true);
                AbstractChartEditor.this.getColorSchemeEditor().reset(false);
            }
        }

        private void moveUp(JList<CyColumnIdentifier> list) {
            DefaultListModel model = (DefaultListModel)list.getModel();
            LinkedList<CyColumnIdentifier> all = new LinkedList<CyColumnIdentifier>();
            int[] selIndices = new int[list.getSelectedIndices().length];
            int selCount = 0;
            boolean move = true;
            for (int i = 0; i < model.getSize(); ++i) {
                CyColumnIdentifier colId = (CyColumnIdentifier)model.get(i);
                if (list.isSelectedIndex(i)) {
                    if (i == 0) {
                        move = false;
                        break;
                    }
                    all.add(i - 1, colId);
                    selIndices[selCount++] = i - 1;
                    continue;
                }
                all.add(colId);
            }
            if (move) {
                this.replaceAll(list, all, selIndices);
            }
        }

        private void moveDown(JList<CyColumnIdentifier> list) {
            DefaultListModel model = (DefaultListModel)list.getModel();
            LinkedList<CyColumnIdentifier> all = new LinkedList<CyColumnIdentifier>();
            int[] selIndices = new int[list.getSelectedIndices().length];
            int selCount = 0;
            boolean move = true;
            for (int i = model.getSize() - 1; i >= 0; --i) {
                CyColumnIdentifier colId = (CyColumnIdentifier)model.get(i);
                if (list.isSelectedIndex(i)) {
                    if (i == model.getSize() - 1) {
                        move = false;
                        break;
                    }
                    all.add(1, colId);
                    selIndices[selCount++] = i + 1;
                    continue;
                }
                all.add(0, colId);
            }
            if (move) {
                this.replaceAll(list, all, selIndices);
            }
        }

        private void replaceAll(JList<CyColumnIdentifier> list, List<CyColumnIdentifier> elements, int[] selectedIndices) {
            DefaultListModel model = (DefaultListModel)list.getModel();
            model.removeAllElements();
            int i = 0;
            for (CyColumnIdentifier colId : elements) {
                model.add(i++, colId);
            }
            list.setSelectedIndices(selectedIndices);
            ((AbstractCustomGraphics2)AbstractChartEditor.this.chart).set("cy_dataColumns", this.getDataColumns());
        }

        protected List<CyColumnIdentifier> getDataColumns() {
            ArrayList<CyColumnIdentifier> columns = new ArrayList<CyColumnIdentifier>();
            ListModel<CyColumnIdentifier> model = this.getSelColumnsLs().getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                CyColumnIdentifier colId = model.getElementAt(i);
                columns.add(colId);
            }
            return columns;
        }
    }
}

