/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.task;

import io.swagger.annotations.Api;
import javax.ws.rs.Path;
import javax.ws.rs.core.Feature;
import javax.ws.rs.ext.Provider;
import org.cytoscape.rest.internal.resource.CyRESTSwagger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class SwaggerResourceTracker
extends ServiceTracker {
    CyRESTSwagger swaggerResource;
    private final BundleContext context;

    public SwaggerResourceTracker(BundleContext context, Filter filter, CyRESTSwagger swaggerResource) {
        super(context, filter, null);
        this.context = context;
        this.swaggerResource = swaggerResource;
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.context.getService(reference);
        return this.delegateAddService(reference, service);
    }

    private Object delegateAddService(ServiceReference reference, Object service) {
        Object result;
        if (this.isResource(service)) {
            this.swaggerResource.addResource(service.getClass());
            result = service;
        } else {
            this.context.ungetService(reference);
            result = null;
        }
        return result;
    }

    public void removedService(ServiceReference reference, Object service) {
        this.swaggerResource.removeResource(service.getClass());
        this.context.ungetService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.swaggerResource.removeResource(service.getClass());
        this.delegateAddService(reference, service);
    }

    private boolean isResource(Object service) {
        return service != null && (this.hasRegisterableAnnotation(service) || service instanceof Feature);
    }

    private boolean hasRegisterableAnnotation(Object service) {
        boolean result = this.isRegisterableAnnotationPresent(service.getClass());
        if (!result) {
            Class<?>[] interfaces;
            for (Class<?> type : interfaces = service.getClass().getInterfaces()) {
                result = result || this.isRegisterableAnnotationPresent(type);
            }
        }
        return result;
    }

    private boolean isRegisterableAnnotationPresent(Class<?> type) {
        return (type.isAnnotationPresent(Path.class) || type.isAnnotationPresent(Provider.class)) && type.isAnnotationPresent(Api.class);
    }
}

