/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.task;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class OSGiJAXRSManager {
    private static final String SCHEMA_HTTP = "http";
    private static final String SCHEMA_HTTPS = "https";
    private static final String PROXY_HOST = "proxyHost";
    private static final String PROXY_PORT = "proxyPort";
    private static final String PROXY_USER = "proxyUser";
    private static final String PROXY_PASSWORD = "proxyPassword";
    private static final String NON_PROXY_HOSTS = "nonProxyHosts";
    private BundleContext context;
    private FeaturesService featuresService;
    private List<Bundle> bundles;
    private String port;
    private static final String JERSEY_VERSION = "2.23";
    private static final String HK2_PATH = "hk2/";
    private static final String[] HK2_BUNDLES = new String[]{"hk2/hk2-api-2.4.0.jar", "hk2/hk2-locator-2.4.0.jar", "hk2/hk2-utils-2.4.0.jar", "hk2/osgi-resource-locator-1.0.1.jar", "hk2/javax.inject-2.4.0.jar", "hk2/aopalliance-repackaged-2.4.0.jar"};
    private static final String GLASSFISH_JERSEY_PATH = "glassfish-jersey/";
    private static final String[] GLASSFISH_JERSEY_BUNDLES = new String[]{"glassfish-jersey/jersey-container-servlet-2.23.jar", "glassfish-jersey/jersey-media-sse-2.23.jar", "glassfish-jersey/jersey-media-multipart-2.23.jar", "glassfish-jersey/jersey-container-servlet-core-2.23.jar", "glassfish-jersey/jersey-common-2.23.jar", "glassfish-jersey/jersey-guava-2.23.jar", "glassfish-jersey/jersey-server-2.23.jar", "glassfish-jersey/jersey-client-2.23.jar", "glassfish-jersey/jersey-media-jaxb-2.23.jar"};
    private static final String JERSEY_MISC_PATH = "jersey-misc/";
    private static final String[] JERSEY_MISC_BUNDLES = new String[]{"jersey-misc/validation-api-1.1.0.Final.jar", "jersey-misc/javassist-3.18.1-GA.jar", "jersey-misc/mimepull-1.9.6.jar"};
    private static final String OSGI_JAX_RS_CONNECTOR_BUNDLES_PATH = "osgi-jax-rs-connector/";
    private static final String[] OSGI_JAX_RS_CONNECTOR_BUNDLES = new String[]{"osgi-jax-rs-connector/publisher-5.3.jar", "osgi-jax-rs-connector/provider-gson-2.3.jar"};

    public void installOSGiJAXRSBundles(BundleContext bundleContext, FeaturesService featuresService, String port) throws Exception {
        this.context = bundleContext;
        this.installFeature(this.context, featuresService.getFeature("jetty", "9.4.28.v20200408"));
        this.installFeature(this.context, featuresService.getFeature("scr"));
        this.installFeature(this.context, featuresService.getFeature("pax-jetty"));
        this.installFeature(this.context, featuresService.getFeature("pax-web-core"));
        this.installFeature(this.context, featuresService.getFeature("pax-http-jetty"));
        this.installFeature(this.context, featuresService.getFeature("pax-http"));
        this.installFeature(this.context, featuresService.getFeature("pax-http-service"));
        this.installFeature(this.context, featuresService.getFeature(SCHEMA_HTTP));
        this.bundles = new ArrayList<Bundle>();
        this.port = port;
        this.setPortConfig(this.context);
        this.setRootResourceConfig(this.context);
        this.installBundlesFromResources(bundleContext, JERSEY_MISC_BUNDLES);
        this.installBundlesFromResources(bundleContext, HK2_BUNDLES);
        this.installBundlesFromResources(bundleContext, GLASSFISH_JERSEY_BUNDLES);
        this.installBundlesFromResources(bundleContext, OSGI_JAX_RS_CONNECTOR_BUNDLES);
    }

    private void installFeature(BundleContext bc, Feature feature) throws BundleException, IOException {
        if (feature == null) {
            return;
        }
        LinkedList<Bundle> bundleList = new LinkedList<Bundle>();
        List bundleInfos = feature.getBundles();
        for (BundleInfo bundleInfo : bundleInfos) {
            bundleList.add(bc.installBundle(bundleInfo.getLocation()));
        }
        for (Bundle bundle : bundleList) {
            bundle.start();
        }
    }

    private void setRootResourceConfig(BundleContext context) throws Exception {
        ServiceReference configurationAdminReference = context.getServiceReference(ConfigurationAdmin.class.getName());
        if (configurationAdminReference == null) {
            throw new IllegalStateException("No available ConfigurationAdmin service.");
        }
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)context.getService(configurationAdminReference);
        Configuration config = configurationAdmin.getConfiguration("com.eclipsesource.jaxrs.connector", null);
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("root", "/*");
        config.update(dictionary);
        context.ungetService(configurationAdminReference);
    }

    private void setPortConfig(BundleContext context) throws Exception {
        ServiceReference configurationAdminReference = context.getServiceReference(ConfigurationAdmin.class.getName());
        if (configurationAdminReference == null) {
            throw new IllegalStateException("No available ConfigurationAdmin service.");
        }
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)context.getService(configurationAdminReference);
        Configuration config = configurationAdmin.getConfiguration("org.ops4j.pax.web", null);
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("org.osgi.service.http.port", this.port);
        ((Dictionary)dictionary).put("org.ops4j.pax.web.session.timeout", "0");
        config.update(dictionary);
        context.ungetService(configurationAdminReference);
    }

    private void installBundlesFromResources(BundleContext bundleContext, String[] resources) throws BundleException, IOException {
        LinkedList<Bundle> bundleList = new LinkedList<Bundle>();
        for (String bundle : resources) {
            bundleList.add(this.installBundleFromResource(bundleContext, bundle));
        }
        for (Bundle bundle : bundleList) {
            if (bundle == null) continue;
            bundle.start();
            this.bundles.add(bundle);
        }
    }

    private Bundle installBundleFromResource(BundleContext bundleContext, String resourceName) throws BundleException, IOException {
        Bundle bundle = null;
        URL url = bundleContext.getBundle().getResource(resourceName);
        bundle = bundleContext.installBundle(url.toString(), url.openConnection().getInputStream());
        return bundle;
    }

    public void uninstallOSGiJAXRSBundles() throws BundleException {
        if (this.bundles != null) {
            for (Bundle bundle : this.bundles) {
                bundle.stop();
                bundle.uninstall();
            }
        }
    }
}

