/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Feature;
import javax.ws.rs.ext.Provider;
import org.cytoscape.rest.internal.CyRESTConstants;
import org.cytoscape.task.NetworkTaskFactory;
import org.cytoscape.task.NetworkViewCollectionTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.TableTaskFactory;
import org.cytoscape.work.TaskFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomationAppTracker
extends ServiceTracker
implements BundleListener {
    private static final Logger logger = LoggerFactory.getLogger(AutomationAppTracker.class);
    Map<Bundle, Set<Object>> bundles = new HashMap<Bundle, Set<Object>>();
    Map<String, Map<String, Bundle>> commandBundles = new HashMap<String, Map<String, Bundle>>();

    public AutomationAppTracker(BundleContext context, Filter filter) {
        super(context, filter, null);
    }

    public Set<Bundle> getAppBundles() {
        return Collections.unmodifiableSet(this.bundles.keySet());
    }

    private void delegateAddService(ServiceReference reference, Object service) {
        if (this.isAutomationService(reference, service)) {
            this.addAutomationService(reference.getBundle(), service);
        }
        if (this.isCommand(reference, service)) {
            this.addAutomationService(reference.getBundle(), service);
            this.addCommand(reference);
        }
    }

    public String getMarkdownReport() {
        int runningAutomationBundles = 0;
        int totalAutomationBundles = 0;
        try {
            Set<Bundle> automationBundles = this.getAppBundles();
            totalAutomationBundles = automationBundles.size();
            for (Bundle bundle : automationBundles) {
                if (bundle.getState() != 32) continue;
                ++runningAutomationBundles;
            }
        }
        catch (Throwable e) {
            logger.error("Error reporting running automation bundles.", e);
            return "_Error reporting running automation bundles. This document may not be complete._";
        }
        String summary = runningAutomationBundles == totalAutomationBundles ? "" : " Some API may not be listed. Try reloading this page. If this condition persists, check the Cytoscape error log for possible causes.";
        return "_" + runningAutomationBundles + "/" + totalAutomationBundles + " Automation Apps started." + summary + "_";
    }

    public Object addingService(ServiceReference reference) {
        Object service = super.addingService(reference);
        this.delegateAddService(reference, service);
        return service;
    }

    private void addAutomationService(Bundle bundle, Object service) {
        Set<Object> services = this.bundles.get(bundle);
        if (services == null) {
            services = new HashSet<Object>();
        }
        services.add(service);
        this.bundles.put(bundle, services);
    }

    private void addCommand(ServiceReference serviceReference) {
        String command = serviceReference.getProperty("command").toString();
        String commandNamespace = serviceReference.getProperty("commandNamespace").toString();
        Map<String, Bundle> commandMap = this.commandBundles.get(commandNamespace);
        if (commandMap == null) {
            commandMap = new HashMap<String, Bundle>();
        }
        commandMap.put(command, serviceReference.getBundle());
        this.commandBundles.put(commandNamespace, commandMap);
    }

    public void removedService(ServiceReference reference, Object service) {
        Set<Object> bundleServices = this.bundles.get(reference.getBundle());
        if (bundleServices != null) {
            bundleServices.remove(service);
            if (bundleServices.size() > 0) {
                this.bundles.put(reference.getBundle(), bundleServices);
            } else {
                this.bundles.remove(reference.getBundle());
            }
        }
        super.removedService(reference, service);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        super.modifiedService(reference, service);
    }

    private boolean isAutomationService(ServiceReference reference, Object service) {
        return service != null && (this.hasRegisterableAnnotation(service) || service instanceof Feature);
    }

    private boolean hasRegisterableAnnotation(Object service) {
        boolean result = this.isRegisterableAnnotationPresent(service.getClass());
        if (!result) {
            Class<?>[] interfaces;
            for (Class<?> type : interfaces = service.getClass().getInterfaces()) {
                result = result || this.isRegisterableAnnotationPresent(type);
            }
        }
        return result;
    }

    public boolean isCommandTaskFactory(Object service) {
        if (service instanceof TaskFactory) {
            return true;
        }
        if (service instanceof NetworkTaskFactory) {
            return true;
        }
        if (service instanceof NetworkViewTaskFactory) {
            return true;
        }
        if (service instanceof NetworkViewCollectionTaskFactory) {
            return true;
        }
        return service instanceof TableTaskFactory;
    }

    private boolean isCommand(ServiceReference reference, Object service) {
        return service != null && this.isCommandTaskFactory(service) && reference.getProperty("command") != null && reference.getProperty("commandNamespace") != null;
    }

    private boolean isRegisterableAnnotationPresent(Class<?> type) {
        return type.isAnnotationPresent(Path.class) || type.isAnnotationPresent(Provider.class);
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 256 || event.getType() == 4 || event.getType() == 16) {
            this.bundles.remove(event.getBundle());
        }
    }

    public String getCommandSourceApp(String commandNamespace, String command) {
        Map<String, Bundle> commandMap = this.commandBundles.get(commandNamespace);
        Bundle bundle = commandMap.get(command);
        Object bundleNameObject = bundle.getHeaders().get(CyRESTConstants.BUNDLE_NAME);
        String bundleName = null;
        if (bundleNameObject != null) {
            bundleName = bundleNameObject.toString();
        }
        return bundleName;
    }
}

