/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.serializer;

import java.util.Collection;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;

public class CyTableSerializer {
    private String SEP = ",";

    public String toCSV(CyTable table, String sep) throws Exception {
        String separator = sep;
        if (separator == null) {
            separator = this.SEP;
        }
        StringBuilder builder = new StringBuilder();
        Collection columns = table.getColumns();
        int colLength = columns.size();
        List rows = table.getAllRows();
        int idx = 1;
        for (CyColumn column : columns) {
            builder.append(column.getName());
            if (idx == colLength) {
                builder.append("\n");
            } else {
                builder.append(separator);
            }
            ++idx;
        }
        for (CyRow row : rows) {
            idx = 1;
            for (CyColumn column : columns) {
                Class type = column.getType();
                if (type != List.class) {
                    Object value = row.get(column.getName(), type);
                    if (value != null) {
                        builder.append(value.toString());
                    }
                } else {
                    List listValue = row.getList(column.getName(), column.getListElementType());
                    builder.append(this.listToString(listValue));
                }
                if (idx == colLength) {
                    builder.append("\n");
                } else {
                    builder.append(separator);
                }
                ++idx;
            }
        }
        return builder.toString();
    }

    private final String listToString(List<?> listCell) {
        if (listCell == null) {
            return "";
        }
        StringBuilder listBuilder = new StringBuilder();
        for (Object item : listCell) {
            if (item == null) continue;
            listBuilder.append(item.toString());
            listBuilder.append("|");
        }
        String cellString = listBuilder.toString();
        if (cellString != null && !cellString.isEmpty()) {
            return cellString.substring(0, cellString.length() - 1);
        }
        return "";
    }
}

