/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.io.write.VizmapWriterFactory;
import org.cytoscape.rest.internal.CyActivator;
import org.cytoscape.rest.internal.MappingFactoryManager;
import org.cytoscape.rest.internal.datamapper.VisualStyleMapper;
import org.cytoscape.rest.internal.model.CountModel;
import org.cytoscape.rest.internal.model.TitleModel;
import org.cytoscape.rest.internal.model.VisualPropertyDependencyModel;
import org.cytoscape.rest.internal.model.VisualPropertyModel;
import org.cytoscape.rest.internal.model.VisualPropertyValueModel;
import org.cytoscape.rest.internal.model.VisualPropertyValuesModel;
import org.cytoscape.rest.internal.model.VisualStyleDefaultsModel;
import org.cytoscape.rest.internal.model.VisualStyleMappingModel;
import org.cytoscape.rest.internal.model.VisualStyleModel;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.rest.internal.serializer.VisualStyleModule;
import org.cytoscape.rest.internal.serializer.VisualStyleSerializer;
import org.cytoscape.rest.internal.task.HeadlessTaskMonitor;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.DiscreteRange;
import org.cytoscape.view.model.Range;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Visual Styles"})
@Singleton
@Path(value="/v1/styles")
public class StyleResource
extends AbstractResource {
    static final String RESOURCE_URN = "styles";
    private static final Logger logger = LoggerFactory.getLogger(StyleResource.class);
    static final int VISUAL_PROPERTY_NOT_FOUND_ERROR = 1;
    static final int VISUAL_MAPPING_NOT_FOUND_ERROR = 2;
    static final int VISUAL_STYLE_NOT_FOUND_ERROR = 3;
    static final int NO_VISUAL_LEXICON_ERROR = 4;
    static final int INTERNAL_METHOD_ERROR = 5;
    static final int SERIALIZATION_ERROR = 6;
    static final int INVALID_PARAMETER_ERROR = 7;
    private final VisualStyleSerializer styleSerializer = new VisualStyleSerializer();
    @Inject
    private CyActivator.WriterListener writerListener;
    @Inject
    private TaskMonitor tm;
    @Inject
    private VisualStyleFactory vsFactory;
    @Inject
    private MappingFactoryManager factoryManager;
    @Inject
    private CyEventHelper cyEventHelper;
    private final ObjectMapper styleMapper = new ObjectMapper();
    private final VisualStyleMapper visualStyleMapper;
    private final VisualStyleSerializer visualStyleSerializer;
    private static final String MAPPING_DESCRIPTION = "The types of mapping available in Cytoscape are explained in depth [here](http://manual.cytoscape.org/en/stable/Styles.html#how-mappings-work). An example of the data format for each is included below. For additional details, such as what Visual Properties supported by each Mapping, click on the relevant JavaDoc API link.\n\n#### Discrete Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/DiscreteMapping.html)\n```\n{ \"mappingType\": \"discrete\",\n  \"mappingColumn\": \"interaction\",\n\t \"mappingColumnType\": \"String\",\n\t \"visualProperty\": \"EDGE_WIDTH\", \n\t \"map\": [\n      { \"key\" : \"pd\",\n         \"value\" : \"20\"\n      },\n      { \"key\" : \"pp\",\n        \"value\" : \"1.5\"\n      }\n    ]\n}```\n#### Continuous Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/ContinuousMapping.html)\n```\n{ \"mappingType\": \"continuous\",\n  \"mappingColumn\": \"Degree\",\n  \"mappingColumnType\": \"Integer\",\n  \"visualProperty\": \"NODE_SIZE\",\n  \"points\": [\n      { \"value\" : 1,\n        \"lesser\" : \"20\",\n        \"equal\" : \"20\",\n        \"greater\" : \"20\"\n      },\n\t     { \"value\" : 20,\n        \"lesser\" : \"120\",\n        \"equal\" : \"120\",\n        \"greater\" : \"220\"      }\n    ]\n}```\n#### Passthrough Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/PassthroughMapping.html)\n```\n{ \"mappingType\": \"passthrough\",\n  \"mappingColumn\": \"name\",\n  \"mappingColumnType\": \"String\",\n  \"visualProperty\": \"EDGE_LABEL\" \n}```\n";

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    public StyleResource() {
        this.styleMapper.registerModule((Module)new VisualStyleModule());
        this.visualStyleMapper = new VisualStyleMapper();
        this.visualStyleSerializer = new VisualStyleSerializer();
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get list of Visual Style names", notes="Returns a list of all the Visual Style names in the current session.", response=String.class, responseContainer="List")
    public String getStyleNames() {
        Set styles = this.vmm.getAllVisualStyles();
        ArrayList<String> styleNames = new ArrayList<String>();
        for (VisualStyle style : styles) {
            styleNames.add(style.getTitle());
        }
        try {
            return this.getNames(styleNames);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not get style names.", logger, e);
        }
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get number of Visual Styles", notes="Returns the number of Visual Styles available in the current session", response=CountModel.class)
    public CountModel getStyleCount() {
        return new CountModel(Long.valueOf(this.vmm.getAllVisualStyles().size()));
    }

    @DELETE
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a Visual Style", notes="Deletes the Visual Style specified by the `name` parameter.")
    public Response deleteStyle(@ApiParam(value="Visual Style Name") @PathParam(value="name") String name) {
        this.vmm.removeVisualStyle(this.getStyleByName(name));
        return Response.ok().build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete all Visual Styles", notes="Deletes all vision styles except for default style")
    public Response deleteAllStyles() {
        Set styles = this.vmm.getAllVisualStyles();
        HashSet<VisualStyle> toBeDeleted = new HashSet<VisualStyle>();
        for (VisualStyle style2 : styles) {
            if (style2.getTitle().equals("default")) continue;
            toBeDeleted.add(style2);
        }
        toBeDeleted.stream().forEach(style -> this.vmm.removeVisualStyle(style));
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{name}/mappings/{vpName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a Visual Mapping from a Visual Style", notes="Deletes the Visual Property mapping specified by the `vpName` and `name` parameters.")
    public Response deleteMapping(@ApiParam(value="Name of the Visual Style containing the Visual Mapping", example="default") @PathParam(value="name") String name, @ApiParam(value="Name of the Visual Property that the Visual Mapping controls", example="NODE_SIZE") @PathParam(value="vpName") String vpName) {
        VisualStyle style = this.getStyleByName(name);
        VisualProperty<?> vp = this.getVisualProperty(vpName);
        if (vp == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 1, "Could not find Visual Property: " + vpName, logger, null);
        }
        VisualMappingFunction mapping = style.getVisualMappingFunction(vp);
        if (mapping == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 2, "Could not find mapping for: " + vpName, logger, null);
        }
        style.removeVisualMappingFunction(vp);
        return Response.ok().build();
    }

    @GET
    @Path(value="/{name}/defaults")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all default values for the Visual Style", notes="Returns a list of all the default values for the Visual Style specified by the `name` parameter.", response=VisualStyleDefaultsModel.class)
    public String getDefaults(@ApiParam(value="Name of the Visual Style") @PathParam(value="name") String name) {
        return this.serializeDefaultValues(name);
    }

    @GET
    @Path(value="/{name}/defaults/{vp}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a default value for the Visual Property", notes="Returns the default value for the Visual Property specified by the `name` and `vp` parameters.\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)\n\n", response=VisualPropertyValueModel.class)
    public String getDefaultValue(@ApiParam(value="Name of the Visual Style containing the Visual Property") @PathParam(value="name") String name, @ApiParam(value="Name of the Visual Property") @PathParam(value="vp") String vp) {
        return this.serializeDefaultValue(name, vp);
    }

    @GET
    @Path(value="/visualproperties/{vp}/values")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all available values for a Visual Property", notes="Returns a list of all available values for the Visual Property specified by the `vp` parameter.\n\nThis method is only for Visual Properties with a Discrete Range, such as NODE_SHAPE or EDGE_LINE_TYPE.\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)\n\n", response=VisualPropertyValuesModel.class)
    public String getRangeValues(@ApiParam(value="ID of the Visual Property", example="NODE_SHAPE") @PathParam(value="vp") String vp) {
        return this.serializeRangeValue(vp);
    }

    @GET
    @Path(value="/visualproperties")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all available Visual Properties", notes="Get all available Visual Properties.\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)")
    public Collection<VisualPropertyModel> getVisualProperties() {
        Set<VisualProperty<?>> vps = this.getAllVisualProperties();
        return vps.stream().map(cyVp -> new VisualPropertyModel((VisualProperty<Object>)cyVp)).collect(Collectors.toList());
    }

    @GET
    @Path(value="/visualproperties/{visualProperty}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a Visual Property", notes="Return the Visual Property specified by the `visualProperty` parameter.\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)", response=VisualPropertyModel.class)
    public String getSingleVisualProperty(@ApiParam(value="ID of the Visual Property", example="NODE_SHAPE") @PathParam(value="visualProperty") String visualProperty) {
        VisualProperty<?> vp = this.getVisualProperty(visualProperty);
        try {
            return this.styleSerializer.serializeVisualProperty(vp);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not serialize Visual Properties.", logger, e);
        }
    }

    @GET
    @Path(value="/{name}/mappings")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all Visual Mappings for the Visual Style", notes="Returns a list of all Visual Mappings used in the Visual Style specified by the `name` parameter.\n\nThe types of mapping available in Cytoscape are explained in depth [here](http://manual.cytoscape.org/en/stable/Styles.html#how-mappings-work). An example of the data format for each is included below. For additional details, such as what Visual Properties supported by each Mapping, click on the relevant JavaDoc API link.\n\n#### Discrete Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/DiscreteMapping.html)\n```\n{ \"mappingType\": \"discrete\",\n  \"mappingColumn\": \"interaction\",\n\t \"mappingColumnType\": \"String\",\n\t \"visualProperty\": \"EDGE_WIDTH\", \n\t \"map\": [\n      { \"key\" : \"pd\",\n         \"value\" : \"20\"\n      },\n      { \"key\" : \"pp\",\n        \"value\" : \"1.5\"\n      }\n    ]\n}```\n#### Continuous Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/ContinuousMapping.html)\n```\n{ \"mappingType\": \"continuous\",\n  \"mappingColumn\": \"Degree\",\n  \"mappingColumnType\": \"Integer\",\n  \"visualProperty\": \"NODE_SIZE\",\n  \"points\": [\n      { \"value\" : 1,\n        \"lesser\" : \"20\",\n        \"equal\" : \"20\",\n        \"greater\" : \"20\"\n      },\n\t     { \"value\" : 20,\n        \"lesser\" : \"120\",\n        \"equal\" : \"120\",\n        \"greater\" : \"220\"      }\n    ]\n}```\n#### Passthrough Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/PassthroughMapping.html)\n```\n{ \"mappingType\": \"passthrough\",\n  \"mappingColumn\": \"name\",\n  \"mappingColumnType\": \"String\",\n  \"visualProperty\": \"EDGE_LABEL\" \n}```\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)", response=VisualStyleMappingModel.class, responseContainer="List")
    public String getMappings(@ApiParam(value="Name of the Visual Style") @PathParam(value="name") String name) {
        VisualStyle style = this.getStyleByName(name);
        Collection mappings = style.getAllVisualMappingFunctions();
        if (mappings.isEmpty()) {
            return "[]";
        }
        try {
            return this.styleMapper.writeValueAsString((Object)mappings);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not serialize Mappings.", logger, (Exception)((Object)e));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not serialize Mappings.", logger, ex);
        }
    }

    @GET
    @Path(value="/{name}/mappings/{vp}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a Visual Mapping associated with the Visual Property", notes="Returns the Visual Mapping assigned to the Visual Property specified by the `name` and `vp` parameters.\n\nThe types of mapping available in Cytoscape are explained in depth [here](http://manual.cytoscape.org/en/stable/Styles.html#how-mappings-work). An example of the data format for each is included below. For additional details, such as what Visual Properties supported by each Mapping, click on the relevant JavaDoc API link.\n\n#### Discrete Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/DiscreteMapping.html)\n```\n{ \"mappingType\": \"discrete\",\n  \"mappingColumn\": \"interaction\",\n\t \"mappingColumnType\": \"String\",\n\t \"visualProperty\": \"EDGE_WIDTH\", \n\t \"map\": [\n      { \"key\" : \"pd\",\n         \"value\" : \"20\"\n      },\n      { \"key\" : \"pp\",\n        \"value\" : \"1.5\"\n      }\n    ]\n}```\n#### Continuous Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/ContinuousMapping.html)\n```\n{ \"mappingType\": \"continuous\",\n  \"mappingColumn\": \"Degree\",\n  \"mappingColumnType\": \"Integer\",\n  \"visualProperty\": \"NODE_SIZE\",\n  \"points\": [\n      { \"value\" : 1,\n        \"lesser\" : \"20\",\n        \"equal\" : \"20\",\n        \"greater\" : \"20\"\n      },\n\t     { \"value\" : 20,\n        \"lesser\" : \"120\",\n        \"equal\" : \"120\",\n        \"greater\" : \"220\"      }\n    ]\n}```\n#### Passthrough Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/PassthroughMapping.html)\n```\n{ \"mappingType\": \"passthrough\",\n  \"mappingColumn\": \"name\",\n  \"mappingColumnType\": \"String\",\n  \"visualProperty\": \"EDGE_LABEL\" \n}```\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)", response=VisualStyleMappingModel.class)
    public String getMapping(@ApiParam(value="Name of the Visual Style containing the Visual Property mapping") @PathParam(value="name") String name, @ApiParam(value="Name of the Visual Property that the Visual Mapping controls") @PathParam(value="vp") String vp) {
        VisualStyle style = this.getStyleByName(name);
        VisualMappingFunction<?, ?> mapping = this.getMappingFunction(vp, style);
        try {
            return this.styleMapper.writeValueAsString(mapping);
        }
        catch (JsonProcessingException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not serialize Mapping.", logger, (Exception)((Object)e));
        }
    }

    private final VisualMappingFunction<?, ?> getMappingFunction(String vp, VisualStyle style) {
        VisualLexicon lexicon = this.getLexicon(4);
        Set allVp = lexicon.getAllVisualProperties();
        VisualProperty visualProp = null;
        for (VisualProperty curVp : allVp) {
            if (!curVp.getIdString().equals(vp)) continue;
            visualProp = curVp;
            break;
        }
        if (visualProp == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 1, "Could not find VisualProperty: " + vp, logger, null);
        }
        VisualMappingFunction mapping = style.getVisualMappingFunction(visualProp);
        if (mapping == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 2, "Could not find visual mapping function for " + vp, logger, null);
        }
        return mapping;
    }

    private final String serializeDefaultValues(String name) {
        VisualStyle style = this.getStyleByName(name);
        VisualLexicon lexicon = this.getLexicon(4);
        Set vps = lexicon.getAllVisualProperties();
        try {
            return this.styleSerializer.serializeDefaults(vps, style);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not serialize default values.", logger, e);
        }
    }

    private final String serializeDefaultValue(String styleName, String vpName) {
        VisualStyle style = this.getStyleByName(styleName);
        VisualProperty<?> vp = this.getVisualProperty(vpName);
        try {
            return this.styleSerializer.serializeDefault(vp, style);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not serialize default value for " + vpName, logger, e);
        }
    }

    private final String serializeRangeValue(String vpName) {
        VisualProperty<?> vp = this.getVisualProperty(vpName);
        Range range = vp.getRange();
        if (range.isDiscrete()) {
            DiscreteRange discRange = (DiscreteRange)range;
            try {
                return this.styleSerializer.serializeDiscreteRange(vp, (DiscreteRange<Object>)discRange);
            }
            catch (IOException e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not serialize default value for " + vpName, logger, e);
            }
        }
        throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Range object is not available for " + vpName, logger, null);
    }

    private final Set<VisualProperty<?>> getAllVisualProperties() {
        VisualLexicon lexicon = this.getLexicon(4);
        return lexicon.getAllVisualProperties();
    }

    private final VisualProperty<?> getVisualProperty(String vpName) {
        VisualLexicon lexicon = this.getLexicon(4);
        Set vps = lexicon.getAllVisualProperties();
        for (VisualProperty vp : vps) {
            if (!vp.getIdString().equals(vpName)) continue;
            return vp;
        }
        return null;
    }

    @PUT
    @Path(value="/{name}/defaults")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update the default values for Visual Properties", notes="Updates the default values for the Visual Properties in the Visual Style specified by the `name` parameter.\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)")
    @ApiImplicitParams(value={@ApiImplicitParam(value="A list of Visual Property values to update.", dataType="[Lorg.cytoscape.rest.internal.model.VisualPropertyValueModel;", paramType="body", required=true)})
    public Response updateDefaults(@ApiParam(value="Name of the Visual Style") @PathParam(value="name") String name, @ApiParam(hidden=true) InputStream is) {
        VisualStyle style = this.getStyleByName(name);
        ObjectMapper objMapper = new ObjectMapper();
        try {
            JsonNode rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
            this.updateVisualProperties(rootNode, style);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 7, "Could not update default values.", logger, e);
        }
        return Response.ok().build();
    }

    private final void updateVisualProperties(JsonNode rootNode, VisualStyle style) {
        for (JsonNode defaultNode : rootNode) {
            Object value;
            String vpName = defaultNode.get("visualProperty").textValue();
            VisualProperty<?> vp = this.getVisualProperty(vpName);
            if (vp == null || (value = vp.parseSerializableString(defaultNode.get("value").asText())) == null) continue;
            style.setDefaultValue(vp, value);
        }
    }

    @GET
    @Path(value="/{name}.json")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a Visual Style in Cytoscape.js CSS format.", notes="Visual Style in [Cytoscape.js CSS](http://js.cytoscape.org/#style) format.")
    public String getStyle(@ApiParam(value="Name of the Visual Style") @PathParam(value="name") String name) {
        if (this.networkViewManager.getNetworkViewSet().isEmpty()) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 7, "You need at least one view object to use this feature.", logger, null);
        }
        VisualStyle style = this.getStyleByName(name);
        VizmapWriterFactory jsonVsFact = this.writerListener.getFactory();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HashSet<VisualStyle> styleCollection = new HashSet<VisualStyle>();
        styleCollection.add(style);
        try {
            CyWriter styleWriter = jsonVsFact.createWriter((OutputStream)os, styleCollection);
            styleWriter.run((TaskMonitor)new HeadlessTaskMonitor());
            String jsonString = os.toString("UTF-8");
            os.close();
            return jsonString;
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 6, "Could not get Visual Style in Cytoscape.js format.", logger, e);
        }
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a Visual Style with full details", notes="Returns the Visual Style specified by the `name` parameter.", response=VisualStyleModel.class)
    public String getStyleFull(@ApiParam(value="Name of the Visual Style") @PathParam(value="name") String name) {
        VisualStyle style = this.getStyleByName(name);
        try {
            return this.styleSerializer.serializeStyle(this.getLexicon(4).getAllVisualProperties(), style);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not get Visual Style JSON.", logger, e);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new Visual Style from JSON.", notes="Creates a new Visual Style using the message body.\n\nReturns the title of the new Visual Style. If the title of the Visual Style already existed in the session, a new one will be automatically generated and returned.", response=TitleModel.class)
    @ApiImplicitParams(value={@ApiImplicitParam(value="The details of the new Visual Style to be created.", dataType="org.cytoscape.rest.internal.model.VisualStyleModel", paramType="body", required=true)})
    public Response createStyle(@ApiParam(hidden=true) InputStream is) {
        ObjectMapper objMapper = new ObjectMapper();
        try {
            JsonNode rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
            VisualStyle style = this.visualStyleMapper.buildVisualStyle(this.factoryManager, this.vsFactory, this.getLexicon(4), rootNode);
            this.vmm.addVisualStyle(style);
            String result = "{\"title\": \"" + style.getTitle() + "\"}";
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 7, "Could not create new Visual Style.", logger, e);
        }
    }

    @POST
    @Path(value="/{name}/mappings")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add a new Visual Mapping", notes="Create a new Visual Mapping function and add it to the Visual Style specified by the `name` parameter. Existing mappings in the Visual Style will be overidden by the new mappings created.\n\nThe types of mapping available in Cytoscape are explained in depth [here](http://manual.cytoscape.org/en/stable/Styles.html#how-mappings-work). An example of the data format for each is included below. For additional details, such as what Visual Properties supported by each Mapping, click on the relevant JavaDoc API link.\n\n#### Discrete Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/DiscreteMapping.html)\n```\n{ \"mappingType\": \"discrete\",\n  \"mappingColumn\": \"interaction\",\n\t \"mappingColumnType\": \"String\",\n\t \"visualProperty\": \"EDGE_WIDTH\", \n\t \"map\": [\n      { \"key\" : \"pd\",\n         \"value\" : \"20\"\n      },\n      { \"key\" : \"pp\",\n        \"value\" : \"1.5\"\n      }\n    ]\n}```\n#### Continuous Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/ContinuousMapping.html)\n```\n{ \"mappingType\": \"continuous\",\n  \"mappingColumn\": \"Degree\",\n  \"mappingColumnType\": \"Integer\",\n  \"visualProperty\": \"NODE_SIZE\",\n  \"points\": [\n      { \"value\" : 1,\n        \"lesser\" : \"20\",\n        \"equal\" : \"20\",\n        \"greater\" : \"20\"\n      },\n\t     { \"value\" : 20,\n        \"lesser\" : \"120\",\n        \"equal\" : \"120\",\n        \"greater\" : \"220\"      }\n    ]\n}```\n#### Passthrough Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/PassthroughMapping.html)\n```\n{ \"mappingType\": \"passthrough\",\n  \"mappingColumn\": \"name\",\n  \"mappingColumnType\": \"String\",\n  \"visualProperty\": \"EDGE_LABEL\" \n}```\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)")
    @ApiImplicitParams(value={@ApiImplicitParam(value="A list of new mappings.", dataType="[Lorg.cytoscape.rest.internal.model.VisualStyleMappingModel;", paramType="body", required=true, examples=@Example(value={@ExampleProperty(mediaType="default", value="[{\n      \"mappingType\": \"continuous\",\n      \"mappingColumn\": \"degree.layout\",\n      \"mappingColumnType\": \"Integer\",\n      \"visualProperty\": \"NODE_SIZE\",\n      \"points\": [\n        {\n          \"value\": 1,\n          \"lesser\": \"1.0\",\n          \"equal\": \"40.0\",\n          \"greater\": \"40.0\"\n        },\n        {\n          \"value\": 18,\n          \"lesser\": \"150.0\",\n          \"equal\": \"150.0\",\n          \"greater\": \"1.0\"\n        }\n      ]\n    }")}))})
    public Response createMappings(@ApiParam(value="Name of the Visual Style") @PathParam(value="name") String name, @ApiParam(hidden=true) InputStream is) {
        VisualStyle style = this.getStyleByName(name);
        this.cyEventHelper.silenceEventSource((Object)style);
        ObjectMapper objMapper = new ObjectMapper();
        try {
            JsonNode rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
            this.visualStyleMapper.buildMappings(style, this.factoryManager, this.getLexicon(4), rootNode);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 7, "Could not create new Mapping.", logger, e);
        }
        Set<CyNetworkView> networkViews = this.findNetworkViewsWithStyles(Collections.singleton(style));
        for (CyNetworkView view : networkViews) {
            style.apply(view);
            view.updateView();
        }
        this.cyEventHelper.unsilenceEventSource((Object)style);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    private Set<CyNetworkView> findNetworkViewsWithStyles(Set<VisualStyle> styles) {
        HashSet<CyNetworkView> result = new HashSet<CyNetworkView>();
        if (styles == null || styles.isEmpty()) {
            return result;
        }
        Set networkViews = this.networkViewManager.getNetworkViewSet();
        for (CyNetworkView view : networkViews) {
            if (!styles.contains(this.vmm.getVisualStyle(view))) continue;
            result.add(view);
        }
        return result;
    }

    @PUT
    @Path(value="/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update name of a Visual Style", notes="Updates the name of the Visual Style specified by the `name` parameter.")
    @ApiImplicitParams(value={@ApiImplicitParam(value="A new name for the Visual Style.", dataType="org.cytoscape.rest.internal.model.TitleModel", paramType="body", required=true)})
    public void updateStyleName(@ApiParam(value="Original name of the Visual Style") @PathParam(value="name") String name, @ApiParam(hidden=true) InputStream is) {
        JsonNode rootNode;
        VisualStyle style = this.getStyleByName(name);
        ObjectMapper objMapper = new ObjectMapper();
        try {
            rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 7, "Could not update Visual Style title.", logger, e);
        }
        this.visualStyleMapper.updateStyleName(style, this.getLexicon(4), rootNode);
    }

    @PUT
    @Path(value="/{name}/mappings/{vp}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing Visual Mapping", notes="Update the visual mapping specified by the `name` and `vp` parameters.\n\nThe types of mapping available in Cytoscape are explained in depth [here](http://manual.cytoscape.org/en/stable/Styles.html#how-mappings-work). An example of the data format for each is included below. For additional details, such as what Visual Properties supported by each Mapping, click on the relevant JavaDoc API link.\n\n#### Discrete Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/DiscreteMapping.html)\n```\n{ \"mappingType\": \"discrete\",\n  \"mappingColumn\": \"interaction\",\n\t \"mappingColumnType\": \"String\",\n\t \"visualProperty\": \"EDGE_WIDTH\", \n\t \"map\": [\n      { \"key\" : \"pd\",\n         \"value\" : \"20\"\n      },\n      { \"key\" : \"pp\",\n        \"value\" : \"1.5\"\n      }\n    ]\n}```\n#### Continuous Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/ContinuousMapping.html)\n```\n{ \"mappingType\": \"continuous\",\n  \"mappingColumn\": \"Degree\",\n  \"mappingColumnType\": \"Integer\",\n  \"visualProperty\": \"NODE_SIZE\",\n  \"points\": [\n      { \"value\" : 1,\n        \"lesser\" : \"20\",\n        \"equal\" : \"20\",\n        \"greater\" : \"20\"\n      },\n\t     { \"value\" : 20,\n        \"lesser\" : \"120\",\n        \"equal\" : \"120\",\n        \"greater\" : \"220\"      }\n    ]\n}```\n#### Passthrough Mapping\n[JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/vizmap/mappings/PassthroughMapping.html)\n```\n{ \"mappingType\": \"passthrough\",\n  \"mappingColumn\": \"name\",\n  \"mappingColumnType\": \"String\",\n  \"visualProperty\": \"EDGE_LABEL\" \n}```\n\nAdditional details on common Visual Properties can be found in the [Basic Visual Lexicon JavaDoc API](http://chianti.ucsd.edu/cytoscape-3.9.1/API/org/cytoscape/view/presentation/property/BasicVisualLexicon.html)")
    @ApiImplicitParams(value={@ApiImplicitParam(value="A list of new mappings.", dataType="[Lorg.cytoscape.rest.internal.model.VisualStyleMappingModel;", paramType="body", required=true)})
    public Response updateMapping(@ApiParam(value="Name of the Visual Style containing the Visual Mapping") @PathParam(value="name") String name, @ApiParam(value="Name of the Visual Property that the Visual Mapping controls") @PathParam(value="vp") String vp, @ApiParam(hidden=true) InputStream is) {
        VisualStyle style = this.getStyleByName(name);
        this.cyEventHelper.silenceEventSource((Object)style);
        ObjectMapper objMapper = new ObjectMapper();
        try {
            JsonNode rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
            this.visualStyleMapper.buildMappings(style, this.factoryManager, this.getLexicon(4), rootNode);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 7, "Could not update Mapping.", logger, e);
        }
        Set<CyNetworkView> networkViews = this.findNetworkViewsWithStyles(Collections.singleton(style));
        for (CyNetworkView view : networkViews) {
            style.apply(view);
            view.updateView();
        }
        this.cyEventHelper.unsilenceEventSource((Object)style);
        return Response.ok().build();
    }

    private final VisualStyle getStyleByName(String name) {
        Set styles = this.vmm.getAllVisualStyles();
        for (VisualStyle style : styles) {
            if (!style.getTitle().equals(name)) continue;
            return style;
        }
        throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 3, "Could not find Visual Style: " + name, logger, null);
    }

    @GET
    @Path(value="/{name}/dependencies")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all Visual Property Dependency statuses", notes="Returns the status of all the Visual Property Dependencies.", response=VisualPropertyDependencyModel.class, responseContainer="List")
    public String getAllDependencies(@ApiParam(value="Name of the Visual Style") @PathParam(value="name") String name) {
        VisualStyle style = this.getStyleByName(name);
        Set dependencies = style.getAllVisualPropertyDependencies();
        try {
            return this.visualStyleSerializer.serializeDependecies(dependencies);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not get Visual Property dependencies.", logger, e);
        }
    }

    @PUT
    @Path(value="/{name}/dependencies")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Set Visual Property Dependencies", notes="Sets the value of Visual Property dependencies to the values in the message body.")
    @ApiImplicitParams(value={@ApiImplicitParam(value="A list of dependencies.", dataType="[Lorg.cytoscape.rest.internal.model.VisualPropertyDependencyModel;", paramType="body", required=true)})
    public void updateDependencies(@ApiParam(value="Name of the Visual Style") @PathParam(value="name") String name, @ApiParam(hidden=true) InputStream is) {
        JsonNode rootNode;
        VisualStyle style = this.getStyleByName(name);
        ObjectMapper objMapper = new ObjectMapper();
        try {
            rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 7, "Could not update Visual Style title.", logger, e);
        }
        this.visualStyleMapper.updateDependencies(style, rootNode);
    }
}

