/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.rest.internal.datamapper.GroupMapper;
import org.cytoscape.rest.internal.model.CountModel;
import org.cytoscape.rest.internal.model.GroupModel;
import org.cytoscape.rest.internal.model.GroupSUIDModel;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.rest.internal.serializer.GroupModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/v1/networks/{networkId}/groups")
@Api(tags={"Groups"})
public class GroupResource
extends AbstractResource {
    private static final String RESOURCE_URN = "networks:groups";
    private static final Logger logger = LoggerFactory.getLogger(GroupResource.class);
    private static final int NETWORK_NOT_FOUND_ERROR = 1;
    private static final int GROUP_NOT_FOUND_ERROR = 2;
    public static final int SERIALIZATION_ERROR = 3;
    private static final int INVALID_PARAMETER_ERROR = 4;
    public static final int INTERNAL_METHOD_ERROR = 5;
    private final GroupMapper mapper = new GroupMapper();
    @Inject
    private CyGroupFactory groupFactory;
    @Inject
    private CyGroupManager groupManager;

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all groups in the network", notes="Returns a list of all the groups in the network specified by the `networkId` parameter.", response=GroupModel.class, responseContainer="List")
    public String getAllGroups(@ApiParam(value="Network SUID") @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        Set groups = this.groupManager.getGroupSet(network);
        try {
            ObjectMapper groupMapper = new ObjectMapper();
            groupMapper.registerModule((Module)new GroupModule(network));
            return groupMapper.writeValueAsString((Object)groups);
        }
        catch (JsonProcessingException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 3, "Could not serialize groups.", this.getResourceLogger(), (Exception)((Object)e));
        }
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get number of groups in the network", notes="Returns the number of groups in the network")
    public CountModel getGroupCount(@ApiParam(value="Network SUID") @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        return new CountModel(Integer.valueOf(this.groupManager.getGroupSet(network).size()).longValue());
    }

    @GET
    @Path(value="/{groupNodeId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a group by SUID", notes="Returns the group specified by the `groupNodeId` and `networkId` parameters.", response=GroupModel.class)
    public String getGroup(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Node representing the Group") @PathParam(value="groupNodeId") Long groupNodeId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyGroup group = this.getGroupById(networkId, groupNodeId);
        try {
            ObjectMapper groupMapper = new ObjectMapper();
            groupMapper.registerModule((Module)new GroupModule(network));
            return groupMapper.writeValueAsString((Object)group);
        }
        catch (JsonProcessingException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 3, "Could not serialize group.", this.getResourceLogger(), (Exception)((Object)e));
        }
    }

    @DELETE
    @ApiOperation(value="Delete all groups in the network", notes="Deletes all groups in the network specified by `networkId` parameter. The nodes and edges that the groups contained will remain present in the network, however the nodes used to identify the Groups will be deleted.")
    public void deleteAllGroups(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        Set groups = this.groupManager.getGroupSet(network);
        try {
            for (CyGroup group : groups) {
                this.groupManager.destroyGroup(group);
            }
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 5, "Could not delete group.", this.getResourceLogger(), e);
        }
    }

    @DELETE
    @Path(value="/{groupNodeId}")
    @ApiOperation(value="Delete a group", notes="Deletes the group specified by the `groupNodeId` and `networkId` parameters. The nodes and edges that the group contained will remain present in the network, however the node used to identify the Group will be deleted.")
    public void deleteGroup(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Node representing the Group") @PathParam(value="groupNodeId") Long groupNodeId) {
        CyGroup group = this.getGroupById(networkId, groupNodeId);
        try {
            this.groupManager.destroyGroup(group);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 5, "Could not delete group.", this.getResourceLogger(), e);
        }
    }

    @GET
    @Path(value="/{groupNodeId}/expand")
    @ApiOperation(value="Expand group", notes="Expands the group specified by the `groupNodeId` and `networkId` parameters.")
    @ApiResponses(value={@ApiResponse(code=204, message="Group expanded"), @ApiResponse(code=500, message="Failed to expand group")})
    public Response expandGroup(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Node representing the Group") @PathParam(value="groupNodeId") Long groupNodeId) {
        return this.toggle(networkId, groupNodeId, false);
    }

    @GET
    @Path(value="/{groupNodeId}/collapse")
    @ApiOperation(value="Collapse group", notes="Collapses the group specified by the `groupNodeId` and `networkId` parameters.")
    @ApiResponses(value={@ApiResponse(code=204, message="Group collapsed"), @ApiResponse(code=500, message="Failed to collapse group")})
    public Response collapseGroup(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the Node representing the Group") @PathParam(value="groupNodeId") Long groupNodeId) {
        return this.toggle(networkId, groupNodeId, true);
    }

    private final Response toggle(Long networkId, Long suid, boolean collapse) {
        CyGroup group = this.getGroupById(networkId, suid);
        CyNetwork network = this.getCyNetwork(1, networkId);
        try {
            if (collapse) {
                group.collapse(network);
            } else {
                group.expand(network);
            }
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 5, "Could not toggle group state. State: " + collapse, this.getResourceLogger(), e);
        }
        return Response.noContent().build();
    }

    private final CyGroup getGroupById(Long networkId, Long suid) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        Set groupSet = this.groupManager.getGroupSet(network);
        for (CyGroup group : groupSet) {
            if (group.getGroupNode().getSUID().longValue() != suid.longValue()) continue;
            return group;
        }
        throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 2, "Could not find group.", this.getResourceLogger(), null);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new group", notes="Create a new group in the network specified by the parameter `networkId`. The contents are specified the message body.", response=GroupSUIDModel.class)
    @ApiImplicitParams(value={@ApiImplicitParam(value="New Group name and contents", dataType="org.cytoscape.rest.internal.model.NewGroupParameterModel", paramType="body", required=true)})
    public String createGroup(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(hidden=true) InputStream is) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        ObjectMapper objMapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
        }
        catch (IOException ex) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 4, "Could not create JSON root node.", this.getResourceLogger(), ex);
        }
        try {
            CyGroup newGroup = this.mapper.createGroup(rootNode, this.groupFactory, network);
            return this.getNumberObjectString(3, "groupSUID", newGroup.getGroupNode().getSUID());
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 5, "Error creating group.", this.getResourceLogger(), e);
        }
    }
}

