/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.inject.Inject;
import io.swagger.annotations.ExternalDocs;
import io.swagger.annotations.Info;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.config.ReaderListener;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.cytoscape.ci.model.CIError;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.command.AvailableCommands;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.rest.internal.commands.resources.CommandResource;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.rest.internal.task.AutomationAppTracker;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/commands/swagger.json")
@Singleton
public class CyRESTCommandSwagger
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(CyRESTCommandSwagger.class);
    private static final String SWAGGER_INFO_DESCRIPTION = "An API to offer access to Cytoscape command line commands through a REST-like service.\n\nIn Cytoscape 3.6, this section is upgraded with support for POST access to Cytoscape commands, offering enhanced documentation as well as JSON output for some commands. **The JSON currently provided by commands in this release may be expanded or revised in future releases.**\n\nAll commands are still available via GET requests, the syntax of which is described in the [Command resources](#!/Commands).\n\n";
    private static final String RESOURCE_URN = "commands:swagger";
    @Inject
    @NotNull
    AutomationAppTracker appTracker;
    @Inject
    @NotNull
    private AvailableCommands available;
    @Inject
    protected CyEventHelper cyEventHelper;
    private String swaggerDefinition;
    private Model ciResponseModel;
    CyNetwork emptyNetwork;
    CyNetworkView emptyView;

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    public CyRESTCommandSwagger() {
        this.updateSwagger();
    }

    protected void updateSwagger() {
        this.swaggerDefinition = null;
    }

    public boolean isSwaggerDefinitionNull() {
        return this.swaggerDefinition == null;
    }

    protected void buildSwagger() {
        BeanConfig commandBeanConfig = new BeanConfig(){

            public Set<Class<?>> classes() {
                HashSet classes = new HashSet();
                classes.add(CommandResource.class);
                classes.add(CyRESTCommandSwaggerConfig.class);
                return classes;
            }
        };
        commandBeanConfig.setHost("localhost:" + this.cyRESTPort);
        commandBeanConfig.setScan(true);
        commandBeanConfig.setPrettyPrint(true);
        Swagger swagger = commandBeanConfig.getSwagger();
        String automationAppReport = this.appTracker.getMarkdownReport();
        swagger.getInfo().setDescription(SWAGGER_INFO_DESCRIPTION + automationAppReport);
        Map ciResponseModels = ModelConverters.getInstance().read(CIResponse.class);
        this.ciResponseModel = (Model)ciResponseModels.get("CIResponse");
        Map ciErrorModels = ModelConverters.getInstance().read(CIError.class);
        Model ciErrorModel = (Model)ciErrorModels.get("CIError");
        swagger.addDefinition("CIError", ciErrorModel);
        this.addCommandPaths(swagger);
        try {
            Json.mapper().enable(SerializationFeature.INDENT_OUTPUT);
            this.swaggerDefinition = Json.mapper().writeValueAsString((Object)swagger);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommandPaths(Swagger swagger) {
        if (this.available != null) {
            boolean resetNetwork = this.setCurrentNetwork();
            boolean resetView = this.setCurrentNetworkView();
            try {
                for (String namespace : this.available.getNamespaces()) {
                    for (String command : this.available.getCommands(namespace)) {
                        io.swagger.models.Path testPath = new io.swagger.models.Path();
                        Operation operation = new Operation();
                        operation.addTag(namespace);
                        operation.setOperationId(namespace + "/" + command);
                        operation.setSummary(this.available.getDescription(namespace, command));
                        operation.setDescription(this.available.getLongDescription(namespace, command) + "\n\n_App: " + this.appTracker.getCommandSourceApp(namespace, command) + "_");
                        Response response = new Response();
                        response.setDescription("successful operation");
                        boolean isJSONCapable = this.setSuccessfulResponse(namespace, command, this.available, response);
                        operation.addResponse("200", response);
                        if (isJSONCapable) {
                            this.setPostParameters(namespace, command, this.available, operation);
                            operation.addConsumes("application/json");
                            operation.addProduces("application/json");
                            testPath.setPost(operation);
                        } else {
                            this.setGetParameters(namespace, command, this.available, operation);
                            operation.addProduces("text/plain");
                            testPath.setGet(operation);
                        }
                        swagger.path("/v1/commands/" + namespace + "/" + command, testPath);
                    }
                }
            }
            finally {
                this.resetCurrentNetworkView(resetView);
                this.resetCurrentNetwork(resetNetwork);
            }
        } else {
            logger.error("CyRESTCommandSwagger availableCommands is null");
        }
    }

    private boolean setSuccessfulResponse(String namespace, String command, AvailableCommands available, Response response) {
        boolean isJSONCapable = available.getSupportsJSON(namespace, command);
        if (isJSONCapable) {
            String jsonExample = available.getExampleJSON(namespace, command);
            ObjectProperty objectProperty = new ObjectProperty();
            ObjectMapper objectMapper = new ObjectMapper();
            objectProperty.setProperties(this.ciResponseModel.getProperties());
            try {
                JsonNode jsonNode = (JsonNode)objectMapper.readValue(CommandResource.getJSONResponse(Arrays.asList(jsonExample), new ArrayList<CIError>(), null), JsonNode.class);
                if (!CyRESTCommandSwagger.containsNull(jsonNode)) {
                    objectProperty.setExample((Object)jsonNode);
                } else {
                    this.reportJSONExampleError(new Exception("Swagger Definition Contained a null value: " + objectMapper.writeValueAsString((Object)jsonNode)), namespace, command, "Invalid for Swagger (JSON contained null)", objectMapper, objectProperty);
                }
            }
            catch (JsonParseException e) {
                this.reportJSONExampleError(e, namespace, command, "JsonParseException", objectMapper, objectProperty);
            }
            catch (JsonMappingException e) {
                this.reportJSONExampleError(e, namespace, command, "JsonMappingException", objectMapper, objectProperty);
            }
            catch (IOException e) {
                this.reportJSONExampleError(e, namespace, command, "IOException", objectMapper, objectProperty);
            }
            response.setSchema((Property)objectProperty);
        } else {
            StringProperty stringProperty = new StringProperty();
            stringProperty.setName("noName");
            response.setSchema((Property)stringProperty);
        }
        return isJSONCapable;
    }

    private void reportJSONExampleError(Throwable e, String namespace, String command, String string, ObjectMapper objectMapper, ObjectProperty objectProperty) {
        logger.error("Error creating json example for " + namespace + " " + command + " : " + string, e);
        try {
            JsonNode jsonNode = (JsonNode)objectMapper.readValue("\"ERROR. Example could not be included: " + string + "\"", JsonNode.class);
            objectProperty.setExample((Object)jsonNode);
        }
        catch (JsonParseException e1) {
            e1.printStackTrace();
        }
        catch (JsonMappingException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void setGetParameters(String namespace, String command, AvailableCommands available, Operation operation) {
        for (String argumentName : available.getArguments(namespace, command)) {
            QueryParameter parameter = new QueryParameter();
            parameter.setName(argumentName);
            String javaType = available.getArgType(namespace, command, argumentName).toString();
            Object longDescription = available.getArgLongDescription(namespace, command, argumentName);
            if (longDescription == null || ((String)longDescription).length() == 0) {
                String description = available.getArgDescription(namespace, command, argumentName);
                longDescription = description != null && description.length() > 0 ? description : "";
            }
            if (((String)longDescription).length() > 0) {
                longDescription = (String)longDescription + "\n\n";
            }
            longDescription = (String)longDescription + "Java Type:\n\n ``` " + javaType + " ```";
            parameter.setDescription((String)longDescription);
            String example = available.getArgExampleStringValue(namespace, command, argumentName);
            if (example != null && example.length() > 0) {
                parameter.setExample(example);
            }
            Class typeClass = available.getArgType(namespace, command, argumentName);
            CyRESTCommandSwagger.setParameterTypeAndFormatFromClass(parameter, typeClass);
            boolean required = available.getArgRequired(namespace, command, argumentName);
            parameter.setRequired(required);
            operation.addParameter((Parameter)parameter);
        }
    }

    private void setPostParameters(String namespace, String command, AvailableCommands available, Operation operation) {
        BodyParameter parameter = new BodyParameter();
        parameter.setName("body");
        CommandModel model = new CommandModel(namespace, command, available);
        parameter.setSchema((Model)model);
        operation.addParameter((Parameter)parameter);
    }

    private CyNetwork getNetwork() {
        if (this.applicationManager.getCurrentNetwork() != null) {
            return this.applicationManager.getCurrentNetwork();
        }
        if (this.emptyNetwork == null) {
            this.emptyNetwork = this.networkFactory.createNetwork(SavePolicy.DO_NOT_SAVE);
            this.emptyNetwork.getRow((CyIdentifiable)this.emptyNetwork).set("name", (Object)"cy:command_documentation_generation");
        }
        return this.emptyNetwork;
    }

    private boolean setCurrentNetwork() {
        if (this.applicationManager.getCurrentNetwork() == null) {
            this.getNetwork();
            this.networkManager.addNetwork(this.emptyNetwork, true);
            return true;
        }
        return false;
    }

    private void resetCurrentNetwork(boolean reset) {
        if (!reset) {
            return;
        }
        this.applicationManager.setCurrentNetwork(null);
        this.networkManager.destroyNetwork(this.emptyNetwork);
        this.emptyNetwork = null;
    }

    private CyNetworkView getNetworkView() {
        if (this.applicationManager.getCurrentNetworkView() != null) {
            return this.applicationManager.getCurrentNetworkView();
        }
        if (this.emptyView == null) {
            this.cyEventHelper.silenceEventSource((Object)this.networkViewManager);
            this.emptyView = this.networkViewFactory.createNetworkView(this.getNetwork());
        }
        return this.emptyView;
    }

    private boolean setCurrentNetworkView() {
        if (this.applicationManager.getCurrentNetworkView() == null) {
            this.getNetworkView();
            this.networkViewManager.addNetworkView(this.emptyView, true);
            return true;
        }
        return false;
    }

    public static boolean containsNull(JsonNode input) {
        if (input.isNull()) {
            return true;
        }
        for (JsonNode node : input) {
            if (!CyRESTCommandSwagger.containsNull(node)) continue;
            return true;
        }
        return false;
    }

    private void resetCurrentNetworkView(boolean reset) {
        if (!reset) {
            return;
        }
        this.applicationManager.setCurrentNetworkView(null);
        this.networkViewManager.destroyNetworkView(this.emptyView);
        this.cyEventHelper.unsilenceEventSource((Object)this.networkViewManager);
        this.emptyView = null;
    }

    @Produces(value={"application/json"})
    @GET
    public String get() throws JsonProcessingException {
        this.updateSwagger();
        if (this.swaggerDefinition == null) {
            this.buildSwagger();
        }
        return this.swaggerDefinition;
    }

    public static void setParameterTypeAndFormatFromClass(QueryParameter parameter, Class<?> clazz) {
        if (Integer.TYPE.equals(clazz)) {
            parameter.setType("integer");
            parameter.setFormat("int32");
        } else if (Long.TYPE.equals(clazz)) {
            parameter.setType("integer");
            parameter.setFormat("int64");
        } else if (Float.TYPE.equals(clazz)) {
            parameter.setType("number");
            parameter.setFormat("int32");
        } else if (Double.TYPE.equals(clazz)) {
            parameter.setType("number");
            parameter.setFormat("int64");
        } else if (String.class.equals(clazz)) {
            parameter.setType("string");
        } else if (Byte.TYPE.equals(clazz)) {
            parameter.setType("string");
            parameter.setFormat("byte");
        } else if (Boolean.TYPE.equals(clazz)) {
            parameter.setType("boolean");
        } else {
            parameter.setType("string");
        }
    }

    @SwaggerDefinition(info=@Info(description="An API to offer access to Cytoscape command line commands through a REST-like service.\n\nIn Cytoscape 3.6, this section is upgraded with support for POST access to Cytoscape commands, offering enhanced documentation as well as JSON output for some commands. **The JSON currently provided by commands in this release may be expanded or revised in future releases.**\n\nAll commands are still available via GET requests, the syntax of which is described in the [Command resources](#!/Commands).\n\n", version="V2.0.0", title="CyREST Command API"), basePath="", consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"}, schemes={SwaggerDefinition.Scheme.HTTP}, tags={}, externalDocs=@ExternalDocs(value="Cytoscape", url="http://cytoscape.org/"))
    public static class CyRESTCommandSwaggerConfig
    implements ReaderListener {
        public void beforeScan(Reader arg0, Swagger swagger) {
        }

        public void afterScan(Reader reader, Swagger swagger) {
        }
    }

    private final class CommandModel
    extends ModelImpl {
        public CommandModel(String namespace, String command, AvailableCommands available) {
            for (String argument : available.getArguments(namespace, command)) {
                StringProperty property = new StringProperty();
                property.setName(argument);
                Object description = available.getArgLongDescription(namespace, command, argument);
                String defaultString = available.getArgExampleStringValue(namespace, command, argument);
                if (defaultString != null && defaultString.length() > 0) {
                    property.setExample(defaultString);
                }
                try {
                    Class type = available.getArgType(namespace, command, argument);
                    Object value = available.getArgValue(namespace, command, argument);
                    if (type.equals(ListSingleSelection.class) && value != null) {
                        ArrayList<String> values = new ArrayList<String>();
                        for (Object entry : ((ListSingleSelection)value).getPossibleValues()) {
                            values.add(entry.toString());
                        }
                        property.setEnum(values);
                    } else if (type.equals(ListMultipleSelection.class) && value != null) {
                        StringJoiner joiner = new StringJoiner(", ", " = [", "]");
                        for (Object entry : ((ListMultipleSelection)value).getPossibleValues()) {
                            joiner.add("'" + entry.toString() + "'");
                        }
                        description = (String)description + joiner.toString();
                    } else if (type.equals(CyTable.class)) {
                        description = (String)description + " [NodeTable -> Node:NetworkName , EdgeTable -> Edge:NetworkName , NetworkTable -> Network:NetworkName , UnassignedTable -> TableFileName]";
                    }
                }
                catch (Exception e) {
                    logger.error("Error handling command enum", (Throwable)e);
                }
                property.setDescription((String)description);
                boolean required = available.getArgRequired(namespace, command, argument);
                this.addProperty(argument, (Property)property);
                if (!required) continue;
                this.addRequired(argument);
            }
        }

        public String getDescription() {
            return "A list of command arguments";
        }

        public String getTitle() {
            return "Command Arguments";
        }
    }
}

