/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.TaskMonitor;

public class EdgeListReader
extends AbstractCyNetworkReader {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("[\\s\\t]+");
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private final CyNetworkManager cyNetworkManager;
    private final CyRootNetworkManager cyRootNetworkManager;
    private final String collectionName;

    public EdgeListReader(InputStream inputStream, CyNetworkViewFactory cyNetworkViewFactory, CyNetworkFactory cyNetworkFactory, CyNetworkManager cyNetworkManager, CyRootNetworkManager cyRootNetworkManager, String collecitonName) {
        super(inputStream, cyNetworkViewFactory, cyNetworkFactory, cyNetworkManager, cyRootNetworkManager);
        this.collectionName = collecitonName;
        this.cyRootNetworkManager = cyRootNetworkManager;
        this.cyNetworkManager = cyNetworkManager;
    }

    private CyRootNetwork getRootNetworkByName(String collectionName) {
        for (CyNetwork net : this.cyNetworkManager.getNetworkSet()) {
            CyRootNetwork rootNet = this.cyRootNetworkManager.getRootNetwork(net);
            if (!((String)rootNet.getRow((CyIdentifiable)rootNet).get("name", String.class)).equals(collectionName)) continue;
            return rootNet;
        }
        return null;
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        return this.cyNetworkViewFactory.createNetworkView(network);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        try {
            this.read(taskMonitor);
        }
        finally {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
    }

    private final void read(TaskMonitor tm) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream, Charset.forName("UTF-8").newDecoder()), 131072);
        CySubNetwork subNetwork = null;
        CyRootNetwork rootNetwork = this.getRootNetwork();
        subNetwork = rootNetwork != null ? rootNetwork.addSubNetwork() : ((rootNetwork = this.getRootNetworkByName(this.collectionName)) == null ? (CySubNetwork)this.cyNetworkFactory.createNetwork() : rootNetwork.addSubNetwork());
        if (subNetwork.getDefaultEdgeTable().getColumn(SOURCE) == null) {
            subNetwork.getDefaultEdgeTable().createColumn(SOURCE, String.class, true);
        }
        if (subNetwork.getDefaultEdgeTable().getColumn(TARGET) == null) {
            subNetwork.getDefaultEdgeTable().createColumn(TARGET, String.class, true);
        }
        HashMap<String, CyNode> nMap = new HashMap<String, CyNode>();
        while ((line = br.readLine()) != null) {
            if (this.cancelled) {
                nMap.clear();
                nMap = null;
                subNetwork = null;
                br.close();
                return;
            }
            if (line.trim().length() <= 0) continue;
            String[] parts = SPLIT_PATTERN.split(line);
            if (parts.length == 2) {
                CyNode targetNode;
                CyNode sourceNode = (CyNode)nMap.get(parts[0]);
                if (sourceNode == null) {
                    sourceNode = subNetwork.addNode();
                    subNetwork.getRow((CyIdentifiable)sourceNode).set("name", (Object)parts[0]);
                    nMap.put(parts[0], sourceNode);
                }
                if ((targetNode = (CyNode)nMap.get(parts[1])) == null) {
                    targetNode = subNetwork.addNode();
                    subNetwork.getRow((CyIdentifiable)targetNode).set("name", (Object)parts[1]);
                    nMap.put(parts[1], targetNode);
                }
                CyEdge edge = subNetwork.addEdge(sourceNode, targetNode, true);
                subNetwork.getRow((CyIdentifiable)edge).set("interaction", (Object)"-");
                subNetwork.getRow((CyIdentifiable)edge).set(SOURCE, (Object)parts[0]);
                subNetwork.getRow((CyIdentifiable)edge).set(TARGET, (Object)parts[1]);
                continue;
            }
            if (parts.length != 1) continue;
        }
        br.close();
        nMap.clear();
        nMap = null;
        this.networks = new CyNetwork[]{subNetwork};
    }
}

