/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.datamapper;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.rest.internal.MappingFactoryManager;
import org.cytoscape.rest.internal.datamapper.MapperUtil;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;

public class VisualStyleMapper {
    private static final String TITLE = "title";
    private static final String MAPPINGS = "mappings";
    private static final String DEFAULTS = "defaults";
    public static final String MAPPING_TYPE = "mappingType";
    private static final String MAPPING_DISCRETE = "discrete";
    private static final String MAPPING_PASSTHROUGH = "passthrough";
    private static final String MAPPING_CONTINUOUS = "continuous";
    public static final String MAPPING_COLUMN = "mappingColumn";
    public static final String MAPPING_COLUMN_TYPE = "mappingColumnType";
    public static final String MAPPING_VP = "visualProperty";
    private static final String MAPPING_DISCRETE_MAP = "map";
    private static final String MAPPING_DISCRETE_KEY = "key";
    private static final String MAPPING_DISCRETE_VALUE = "value";
    public static final String VP_DEPENDENCY = "visualPropertyDependency";
    public static final String VP_DEPENDENCY_ENABLED = "enabled";

    public VisualStyle buildVisualStyle(MappingFactoryManager factoryManager, VisualStyleFactory factory, VisualLexicon lexicon, JsonNode rootNode) {
        JsonNode title = rootNode.get(TITLE);
        VisualStyle style = factory.createVisualStyle(title.textValue());
        JsonNode defaults = rootNode.get(DEFAULTS);
        JsonNode mappings = rootNode.get(MAPPINGS);
        if (defaults != null) {
            this.parseDefaults(defaults, style, lexicon);
        }
        if (mappings != null) {
            this.parseMappings(mappings, style, lexicon, factoryManager);
        }
        return style;
    }

    public void buildMappings(VisualStyle style, MappingFactoryManager factoryManager, VisualLexicon lexicon, JsonNode mappings) {
        this.parseMappings(mappings, style, lexicon, factoryManager);
    }

    public void updateStyleName(VisualStyle style, VisualLexicon lexicon, JsonNode rootNode) {
        String newTitle = rootNode.get(TITLE).textValue();
        style.setTitle(newTitle);
    }

    private final void parseDefaults(JsonNode defaults, VisualStyle style, VisualLexicon lexicon) {
        for (JsonNode vpNode : defaults) {
            String vpName = vpNode.get(MAPPING_VP).textValue();
            VisualProperty vp = this.getVisualProperty(vpName, lexicon);
            JsonNode value = vpNode.get(MAPPING_DISCRETE_VALUE);
            if (vp == null || value == null) continue;
            Object parsedValue = null;
            parsedValue = value.isTextual() ? vp.parseSerializableString(value.asText()) : vp.parseSerializableString(value.toString());
            style.setDefaultValue(vp, parsedValue);
        }
    }

    private final void parseMappings(JsonNode mappings, VisualStyle style, VisualLexicon lexicon, MappingFactoryManager factoryManager) {
        for (JsonNode mapping : mappings) {
            VisualMappingFunctionFactory factory;
            String type = mapping.get(MAPPING_TYPE).textValue();
            String column = mapping.get(MAPPING_COLUMN).textValue();
            String colType = mapping.get(MAPPING_COLUMN_TYPE).textValue();
            String vpName = mapping.get(MAPPING_VP).textValue();
            VisualProperty vp = this.getVisualProperty(vpName, lexicon);
            Class<?> columnType = MapperUtil.getColumnClass(colType, false);
            if (vp == null || columnType == null) continue;
            DiscreteMapping newMapping = null;
            if (type.equals(MAPPING_DISCRETE)) {
                factory = factoryManager.getFactory(DiscreteMapping.class);
                newMapping = this.parseDiscrete(column, columnType, vp, factory, mapping.get(MAPPING_DISCRETE_MAP));
            } else if (type.equals(MAPPING_CONTINUOUS)) {
                factory = factoryManager.getFactory(ContinuousMapping.class);
                newMapping = this.parseContinuous(column, columnType, vp, factory, mapping);
            } else if (type.equals(MAPPING_PASSTHROUGH)) {
                factory = factoryManager.getFactory(PassthroughMapping.class);
                newMapping = this.parsePassthrough(column, columnType, vp, factory);
            }
            if (newMapping == null) continue;
            style.addVisualMappingFunction(newMapping);
        }
    }

    private final VisualProperty getVisualProperty(String vpName, VisualLexicon lexicon) {
        VisualProperty vp = null;
        if (vpName.startsWith("NODE")) {
            vp = lexicon.lookup(CyNode.class, vpName);
        } else if (vpName.startsWith("EDGE")) {
            vp = lexicon.lookup(CyEdge.class, vpName);
        } else if (vpName.startsWith("NETWORK")) {
            vp = lexicon.lookup(CyNetwork.class, vpName);
        }
        return vp;
    }

    private final Object parseKeyValue(Class<?> type, String value) {
        if (type == Double.class) {
            return Double.parseDouble(value);
        }
        if (type == Long.class) {
            return Long.parseLong(value);
        }
        if (type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (type == String.class) {
            return value;
        }
        return null;
    }

    private final DiscreteMapping parseDiscrete(String columnName, Class<?> type, VisualProperty<?> vp, VisualMappingFunctionFactory factory, JsonNode discreteMapping) {
        DiscreteMapping mapping = (DiscreteMapping)factory.createVisualMappingFunction(columnName, type, vp);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (JsonNode pair : discreteMapping) {
            Object key = this.parseKeyValue(type, pair.get(MAPPING_DISCRETE_KEY).textValue());
            if (key == null) continue;
            map.put(key, vp.parseSerializableString(pair.get(MAPPING_DISCRETE_VALUE).textValue()));
        }
        mapping.putAll(map);
        return mapping;
    }

    private final ContinuousMapping parseContinuous(String columnName, Class<?> type, VisualProperty<?> vp, VisualMappingFunctionFactory factory, JsonNode mappingNode) {
        ContinuousMapping mapping = (ContinuousMapping)factory.createVisualMappingFunction(columnName, type, vp);
        for (JsonNode point : mappingNode.get("points")) {
            JsonNode val = point.get(MAPPING_DISCRETE_VALUE);
            JsonNode lesser = point.get("lesser");
            JsonNode equal = point.get("equal");
            JsonNode greater = point.get("greater");
            BoundaryRangeValues newPoint = new BoundaryRangeValues(vp.parseSerializableString(lesser.asText()), vp.parseSerializableString(equal.asText()), vp.parseSerializableString(greater.asText()));
            mapping.addPoint((Object)val.asDouble(), newPoint);
        }
        return mapping;
    }

    private final PassthroughMapping parsePassthrough(String columnName, Class<?> type, VisualProperty<?> vp, VisualMappingFunctionFactory factory) {
        return (PassthroughMapping)factory.createVisualMappingFunction(columnName, type, vp);
    }

    public Response updateView(View<? extends CyIdentifiable> view, JsonNode rootNode, VisualLexicon lexicon, boolean bypass) {
        for (JsonNode vpNode : rootNode) {
            this.updateViewVisualProperty(view, vpNode, lexicon, bypass);
        }
        return Response.ok().build();
    }

    public void updateViewVisualProperty(View<? extends CyIdentifiable> view, JsonNode vpNode, VisualLexicon lexicon, boolean bypass) {
        String vpName = vpNode.get(MAPPING_VP).textValue();
        VisualProperty vp = this.getVisualProperty(vpName, lexicon);
        JsonNode value = vpNode.get(MAPPING_DISCRETE_VALUE);
        if (vp == null || value == null) {
            return;
        }
        Object parsedValue = null;
        parsedValue = value.isTextual() ? vp.parseSerializableString(value.asText()) : vp.parseSerializableString(value.toString());
        if (bypass) {
            view.setLockedValue(vp, parsedValue);
        } else {
            view.setVisualProperty(vp, parsedValue);
        }
    }

    public void updateDependencies(VisualStyle style, JsonNode rootNode) {
        Set deps = style.getAllVisualPropertyDependencies();
        HashMap<String, VisualPropertyDependency> names = new HashMap<String, VisualPropertyDependency>();
        for (VisualPropertyDependency dep : deps) {
            names.put(dep.getIdString(), dep);
        }
        for (JsonNode depNode : rootNode) {
            JsonNode enabled;
            String depId = depNode.get(VP_DEPENDENCY).textValue();
            VisualPropertyDependency dep = (VisualPropertyDependency)names.get(depId);
            if (dep == null || (enabled = depNode.get(VP_DEPENDENCY_ENABLED)) == null) continue;
            boolean value = enabled.asBoolean();
            dep.setDependency(value);
        }
    }
}

