/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.intr;

import java.io.Serializable;
import org.cytoscape.util.intr.IntEnumerator;

public final class IntQueue
implements Serializable {
    private static final long serialVersionUID = 121374594921419L;
    private static final int DEFAULT_CAPACITY = 12;
    private int[] m_queue = new int[12];
    private int m_head;
    private int m_tail;

    public IntQueue() {
        this.empty();
    }

    public final void empty() {
        this.m_head = 0;
        this.m_tail = 0;
    }

    public final int size() {
        int absHead = this.m_head;
        if (absHead < this.m_tail) {
            absHead += this.m_queue.length;
        }
        return absHead - this.m_tail;
    }

    public final void enqueue(int value) {
        this.checkSize();
        this.m_queue[this.m_head++] = value;
        if (this.m_head == this.m_queue.length) {
            this.m_head = 0;
        }
    }

    public final int peek() {
        return this.m_queue[this.m_tail];
    }

    public final int dequeue() {
        int returnThis = this.m_queue[this.m_tail++];
        if (this.m_tail == this.m_queue.length) {
            this.m_tail = 0;
        }
        return returnThis;
    }

    public final IntEnumerator elements() {
        final int[] queue = this.m_queue;
        final int head = this.m_head;
        final int tail = this.m_tail;
        return new IntEnumerator(){
            private int inx;
            {
                this.inx = tail;
            }

            @Override
            public final int numRemaining() {
                int absHead = head;
                if (absHead < this.inx) {
                    absHead += queue.length;
                }
                return absHead - this.inx;
            }

            @Override
            public final int nextInt() {
                int returnThis = queue[this.inx++];
                if (this.inx == queue.length) {
                    this.inx = 0;
                }
                return returnThis;
            }
        };
    }

    private final void checkSize() {
        if (this.size() + 2 > this.m_queue.length) {
            int newQueueArrSize = (int)Math.min(Integer.MAX_VALUE, (long)this.m_queue.length * 2L + 1L);
            if (newQueueArrSize == this.m_queue.length) {
                throw new IllegalStateException("cannot allocate large enough array");
            }
            int[] newQueueArr = new int[newQueueArrSize];
            if (this.m_tail <= this.m_head) {
                System.arraycopy(this.m_queue, this.m_tail, newQueueArr, 0, this.m_head - this.m_tail);
                this.m_head -= this.m_tail;
            } else {
                System.arraycopy(this.m_queue, this.m_tail, newQueueArr, 0, this.m_queue.length - this.m_tail);
                System.arraycopy(this.m_queue, 0, newQueueArr, this.m_queue.length - this.m_tail, this.m_head);
                this.m_head += this.m_queue.length - this.m_tail;
            }
            this.m_tail = 0;
            this.m_queue = newQueueArr;
        }
    }
}

