/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.graph.render.stateful;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.ding.impl.work.DiscreteProgressMonitor;
import org.cytoscape.ding.impl.work.ProgressMonitor;
import org.cytoscape.ding.internal.util.MurmurHash3;
import org.cytoscape.graph.render.immed.EdgeAnchors;
import org.cytoscape.graph.render.immed.GraphGraphics;
import org.cytoscape.graph.render.stateful.CustomGraphicsInfo;
import org.cytoscape.graph.render.stateful.EdgeDetails;
import org.cytoscape.graph.render.stateful.GraphLOD;
import org.cytoscape.graph.render.stateful.LabelInfo;
import org.cytoscape.graph.render.stateful.LabelInfoProvider;
import org.cytoscape.graph.render.stateful.LabelLineInfo;
import org.cytoscape.graph.render.stateful.NodeDetails;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.SnapshotEdgeInfo;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.spacial.EdgeSpacialIndex2DEnumerator;
import org.cytoscape.view.model.spacial.NodeSpacialIndex2DEnumerator;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.property.ArrowShapeVisualProperty;
import org.cytoscape.view.presentation.property.EdgeStackingVisualProperty;
import org.cytoscape.view.presentation.property.values.ArrowShape;
import org.cytoscape.view.presentation.property.values.EdgeStacking;
import org.cytoscape.view.presentation.property.values.Justification;
import org.cytoscape.view.presentation.property.values.Position;
import org.cytoscape.view.vizmap.VisualPropertyDependency;

public final class GraphRenderer {
    private static final float[] s_floatTemp = new float[6];
    private static final int[] s_segTypeBuff = new int[200];
    private static final float[] s_floatBuff2 = new float[1200];

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void renderEdges(ProgressMonitor pm, GraphGraphics grafx, CyNetworkViewSnapshot netView, RenderDetailFlags flags, NodeDetails nodeDetails, EdgeDetails edgeDetails, LabelInfoProvider labelInfoProvider) {
        if (flags.renderEdges() == GraphLOD.RenderEdges.NONE) {
            return;
        }
        float[] floatBuff1 = new float[4];
        float[] floatBuff2 = new float[4];
        float[] floatBuff3 = new float[2];
        float[] floatBuff4 = new float[2];
        float[] floatBuff5 = new float[8];
        double[] doubleBuff1 = new double[4];
        double[] doubleBuff2 = new double[2];
        GeneralPath path2d = new GeneralPath();
        Rectangle2D.Float area = grafx.getTransform().getNetworkVisibleAreaNodeCoords();
        EdgeSpacialIndex2DEnumerator edgeHits = flags.renderEdges() == GraphLOD.RenderEdges.ALL ? netView.getSpacialIndex2D().queryAllEdges(pm::isCancelled) : netView.getSpacialIndex2D().queryOverlapEdges(area.x, area.y, area.x + area.width, area.y + area.height, pm::isCancelled);
        if (edgeHits == null) {
            return;
        }
        if (flags.not(2)) {
            ProgressMonitor[] subPms = pm.split(1.0, 0.0);
            ProgressMonitor shapePm = subPms[0];
            ProgressMonitor labelPm = subPms[1];
            shapePm.start("Line");
            DiscreteProgressMonitor shapeDpm = shapePm.toDiscrete(edgeHits.size());
            while (edgeHits.hasNext()) {
                if (pm.isCancelled()) {
                    return;
                }
                View edge = edgeHits.nextEdgeWithNodeExtents(floatBuff1, floatBuff2, null);
                float sourceNodeX = (floatBuff1[0] + floatBuff1[2]) / 2.0f;
                float sourceNodeY = (floatBuff1[1] + floatBuff1[3]) / 2.0f;
                float targetNodeX = (floatBuff2[0] + floatBuff2[2]) / 2.0f;
                float targetNodeY = (floatBuff2[1] + floatBuff2[3]) / 2.0f;
                Color color = edgeDetails.getColorLowDetail(netView, (View<CyEdge>)edge);
                grafx.drawEdgeLow(sourceNodeX, sourceNodeY, targetNodeX, targetNodeY, color);
                shapeDpm.increment();
            }
            shapePm.done();
            labelPm.emptyTask("Label");
            return;
        } else {
            ProgressMonitor[] subPms = pm.split(1.0, 1.0);
            ProgressMonitor shapePm = subPms[0];
            ProgressMonitor labelPm = subPms[1];
            DiscreteProgressMonitor shapeDpm = shapePm.toDiscrete(edgeHits.size());
            DiscreteProgressMonitor labelDpm = labelPm.toDiscrete(edgeHits.size());
            byte[] haystackDataBuff = new byte[16];
            View[] nodeBuff = new View[2];
            while (edgeHits.hasNext()) {
                EdgeAnchors anchors;
                Paint trgArrowPaint;
                Paint srcArrowPaint;
                float trgArrowSize;
                float srcArrowSize;
                ArrowShape trgArrow;
                ArrowShape srcArrow;
                if (pm.isCancelled()) {
                    return;
                }
                View edge = edgeHits.nextEdgeWithNodeExtents(floatBuff1, floatBuff2, nodeBuff);
                SnapshotEdgeInfo edgeInfo = netView.getEdgeInfo(edge);
                long srcSuid = edgeInfo.getSourceViewSUID();
                long trgSuid = edgeInfo.getTargetViewSUID();
                View sourceNode = nodeBuff[0];
                View targetNode = nodeBuff[1];
                byte srcShape = nodeDetails.getShape((View<CyNode>)sourceNode);
                byte trgShape = nodeDetails.getShape((View<CyNode>)targetNode);
                shapePm.start("Line");
                EdgeStacking stacking = edgeDetails.getStacking((View<CyEdge>)edge);
                float thickness = edgeDetails.getWidth((View<CyEdge>)edge);
                Stroke edgeStroke = edgeDetails.getStroke((View<CyEdge>)edge);
                Paint segPaint = edgeDetails.getPaint((View<CyEdge>)edge);
                if (flags.not(16) || stacking == EdgeStackingVisualProperty.HAYSTACK) {
                    trgArrow = srcArrow = ArrowShapeVisualProperty.NONE;
                    srcArrowSize = 0.0f;
                    trgArrowSize = 0.0f;
                    srcArrowPaint = null;
                    trgArrowPaint = null;
                } else {
                    srcArrow = edgeDetails.getSourceArrowShape((View<CyEdge>)edge);
                    trgArrow = edgeDetails.getTargetArrowShape((View<CyEdge>)edge);
                    srcArrowSize = srcArrow == ArrowShapeVisualProperty.NONE ? 0.0f : edgeDetails.getSourceArrowSize((View<CyEdge>)edge);
                    trgArrowSize = trgArrow == ArrowShapeVisualProperty.NONE ? 0.0f : edgeDetails.getTargetArrowSize((View<CyEdge>)edge);
                    srcArrowPaint = srcArrow == ArrowShapeVisualProperty.NONE ? null : edgeDetails.getSourceArrowPaint((View<CyEdge>)edge);
                    trgArrowPaint = trgArrow == ArrowShapeVisualProperty.NONE ? null : edgeDetails.getTargetArrowPaint((View<CyEdge>)edge);
                }
                EdgeAnchors edgeAnchors = anchors = flags.not(64) ? null : edgeDetails.getAnchors(netView, (View<CyEdge>)edge);
                if (stacking == EdgeStackingVisualProperty.HAYSTACK) {
                    float radiusModifier = edgeDetails.getStackingDensity((View<CyEdge>)edge);
                    GraphRenderer.computeEdgeEndpointsHaystack(floatBuff1, floatBuff2, srcSuid, trgSuid, edgeInfo.getSUID(), radiusModifier, stacking, floatBuff3, floatBuff4, haystackDataBuff);
                } else {
                    GraphRenderer.computeEdgeEndpoints(floatBuff1, srcShape, srcArrow, srcArrowSize, anchors, floatBuff2, trgShape, trgArrow, trgArrowSize, floatBuff3, floatBuff4);
                }
                float srcXAdj = floatBuff3[0];
                float srcYAdj = floatBuff3[1];
                float trgXAdj = floatBuff4[0];
                float trgYAdj = floatBuff4[1];
                grafx.drawEdgeFull(srcArrow, srcArrowSize, srcArrowPaint, trgArrow, trgArrowSize, trgArrowPaint, srcXAdj, srcYAdj, anchors, trgXAdj, trgYAdj, thickness, edgeStroke, segPaint);
                if (anchors != null) {
                    for (int k = 0; k < anchors.numAnchors(); ++k) {
                        float f;
                        float anchorSize = edgeDetails.getAnchorSize((View<CyEdge>)edge, k);
                        if (!(f > 0.0f)) continue;
                        anchors.getAnchor(k, floatBuff4);
                        grafx.drawNodeFull((byte)0, (float)((double)floatBuff4[0] - (double)anchorSize / 2.0), (float)((double)floatBuff4[1] - (double)anchorSize / 2.0), (float)((double)floatBuff4[0] + (double)anchorSize / 2.0), (float)((double)floatBuff4[1] + (double)anchorSize / 2.0), edgeDetails.getAnchorPaint((View<CyEdge>)edge, k), 0.0f, null, null);
                    }
                }
                shapePm.done();
                labelPm.start("Label");
                if (flags.has(128)) {
                    int labelCount = edgeDetails.getLabelCount((View<CyEdge>)edge);
                    for (int labelInx = 0; labelInx < labelCount; ++labelInx) {
                        double edgeAnchorPointY;
                        double edgeAnchorPointX;
                        if (pm.isCancelled()) {
                            return;
                        }
                        String text = edgeDetails.getLabelText((View<CyEdge>)edge);
                        Font font = edgeDetails.getLabelFont((View<CyEdge>)edge);
                        Paint paint = edgeDetails.getLabelPaint((View<CyEdge>)edge);
                        Position textAnchor = edgeDetails.getLabelTextAnchor((View<CyEdge>)edge);
                        Position edgeAnchor = edgeDetails.getLabelEdgeAnchor((View<CyEdge>)edge);
                        float offsetVectorX = edgeDetails.getLabelOffsetVectorX((View<CyEdge>)edge);
                        float offsetVectorY = edgeDetails.getLabelOffsetVectorY((View<CyEdge>)edge);
                        double theta = edgeDetails.getLabelRotation((View<CyEdge>)edge) * 0.01745329252;
                        Justification justify = text.indexOf(10) >= 0 ? edgeDetails.getLabelJustify((View<CyEdge>)edge) : Justification.JUSTIFY_CENTER;
                        double edgeLabelWidth = edgeDetails.getLabelWidth((View<CyEdge>)edge);
                        if (edgeAnchor == Position.WEST) {
                            edgeAnchorPointX = srcXAdj;
                            edgeAnchorPointY = srcYAdj;
                        } else if (edgeAnchor == Position.EAST) {
                            edgeAnchorPointX = trgXAdj;
                            edgeAnchorPointY = trgYAdj;
                        } else {
                            int subPathType;
                            int i;
                            if (edgeAnchor != Position.CENTER) throw new IllegalStateException("encountered an invalid EDGE_ANCHOR_* constant: " + edgeAnchor);
                            if (!GraphGraphics.getEdgePath(srcArrow, srcArrowSize, trgArrow, trgArrowSize, srcXAdj, srcYAdj, anchors, trgXAdj, trgYAdj, path2d)) continue;
                            PathIterator pathIter = path2d.getPathIterator(null);
                            int numPathsTemp = 0;
                            while (!pathIter.isDone()) {
                                ++numPathsTemp;
                                pathIter.next();
                            }
                            int numPaths = numPathsTemp;
                            if (numPaths % 2 != 0) {
                                pathIter = path2d.getPathIterator(null);
                                for (i = numPaths / 2; i > 0; --i) {
                                    pathIter.next();
                                }
                                subPathType = pathIter.currentSegment(floatBuff5);
                                if (subPathType == 1) {
                                    edgeAnchorPointX = floatBuff5[0];
                                    edgeAnchorPointY = floatBuff5[1];
                                } else if (subPathType == 2) {
                                    edgeAnchorPointX = floatBuff5[2];
                                    edgeAnchorPointY = floatBuff5[3];
                                } else {
                                    if (subPathType != 3) throw new IllegalStateException("got unexpected PathIterator segment type: " + subPathType);
                                    edgeAnchorPointX = floatBuff5[4];
                                    edgeAnchorPointY = floatBuff5[5];
                                }
                            } else {
                                pathIter = path2d.getPathIterator(null);
                                for (i = numPaths / 2; i > 0; --i) {
                                    if (i == 1) {
                                        int subPathType2 = pathIter.currentSegment(floatBuff5);
                                        if (subPathType2 == 0 || subPathType2 == 1) {
                                            floatBuff5[6] = floatBuff5[0];
                                            floatBuff5[7] = floatBuff5[1];
                                        } else if (subPathType2 == 2) {
                                            floatBuff5[6] = floatBuff5[2];
                                            floatBuff5[7] = floatBuff5[3];
                                        } else {
                                            if (subPathType2 != 3) throw new IllegalStateException("got unexpected PathIterator segment type: " + subPathType2);
                                            floatBuff5[6] = floatBuff5[4];
                                            floatBuff5[7] = floatBuff5[5];
                                        }
                                    }
                                    pathIter.next();
                                }
                                subPathType = pathIter.currentSegment(floatBuff5);
                                if (subPathType == 1) {
                                    edgeAnchorPointX = 0.5 * (double)floatBuff5[6] + 0.5 * (double)floatBuff5[0];
                                    edgeAnchorPointY = 0.5 * (double)floatBuff5[7] + 0.5 * (double)floatBuff5[1];
                                } else if (subPathType == 2) {
                                    edgeAnchorPointX = 0.25 * (double)floatBuff5[6] + 0.5 * (double)floatBuff5[0] + 0.25 * (double)floatBuff5[2];
                                    edgeAnchorPointY = 0.25 * (double)floatBuff5[7] + 0.5 * (double)floatBuff5[1] + 0.25 * (double)floatBuff5[3];
                                } else {
                                    if (subPathType != 3) throw new IllegalStateException("got unexpected PathIterator segment type: " + subPathType);
                                    edgeAnchorPointX = 0.125 * (double)floatBuff5[6] + 0.375 * (double)floatBuff5[0] + 0.375 * (double)floatBuff5[2] + 0.125 * (double)floatBuff5[4];
                                    edgeAnchorPointY = 0.125 * (double)floatBuff5[7] + 0.375 * (double)floatBuff5[1] + 0.375 * (double)floatBuff5[3] + 0.125 * (double)floatBuff5[5];
                                }
                            }
                        }
                        LabelInfo labelInfo = labelInfoProvider.getLabelInfo(text, font, edgeLabelWidth, grafx.getFontRenderContextFull());
                        doubleBuff1[0] = -0.5 * labelInfo.getMaxLineWidth();
                        doubleBuff1[1] = -0.5 * labelInfo.getTotalHeight();
                        doubleBuff1[2] = 0.5 * labelInfo.getMaxLineWidth();
                        doubleBuff1[3] = 0.5 * labelInfo.getTotalHeight();
                        GraphRenderer.computeAnchor(textAnchor, doubleBuff1, doubleBuff2);
                        double textXCenter = edgeAnchorPointX - doubleBuff2[0] + (double)offsetVectorX;
                        double textYCenter = edgeAnchorPointY - doubleBuff2[1] + (double)offsetVectorY;
                        GraphRenderer.renderText(grafx, labelInfo, (float)textXCenter, (float)textYCenter, edgeAnchorPointX, edgeAnchorPointY, justify, paint, theta, flags.has(256));
                    }
                }
                labelPm.done();
                shapeDpm.increment();
                labelDpm.increment();
            }
        }
    }

    public static void renderNodes(ProgressMonitor pm, GraphGraphics grafx, CyNetworkViewSnapshot netView, RenderDetailFlags flags, NodeDetails nodeDetails, Set<VisualPropertyDependency<?>> dependencies, LabelInfoProvider labelInfoProvider) {
        float[] floatBuff1 = new float[4];
        double[] doubleBuff1 = new double[4];
        double[] doubleBuff2 = new double[2];
        Rectangle2D.Float area = grafx.getTransform().getNetworkVisibleAreaNodeCoords();
        NodeSpacialIndex2DEnumerator nodeHits = netView.getSpacialIndex2D().queryOverlapNodes(area.x, area.y, area.x + area.width, area.y + area.height, pm::isCancelled);
        if (nodeHits == null) {
            return;
        }
        if (flags.not(2)) {
            ProgressMonitor[] subPms = pm.split(1.0, 0.0);
            ProgressMonitor shapePm = subPms[0];
            ProgressMonitor labelPm = subPms[1];
            shapePm.start("Shape");
            int nodeHitCount = nodeHits.size();
            DiscreteProgressMonitor shapeDpm = shapePm.toDiscrete(nodeHitCount);
            for (int i = 0; i < nodeHitCount; ++i) {
                if (pm.isCancelled()) {
                    return;
                }
                View node = nodeHits.nextNodeExtents(floatBuff1);
                if (floatBuff1[0] != floatBuff1[2] && floatBuff1[1] != floatBuff1[3]) {
                    Color color = nodeDetails.getColorLowDetail(netView, (View<CyNode>)node);
                    grafx.drawNodeLow(floatBuff1[0], floatBuff1[1], floatBuff1[2], floatBuff1[3], color);
                }
                shapeDpm.increment();
            }
            shapePm.done();
            labelPm.emptyTask("Label");
        } else {
            ProgressMonitor[] subPms = pm.split(1.0, 2.0);
            ProgressMonitor shapePm = subPms[0];
            ProgressMonitor labelPm = subPms[1];
            DiscreteProgressMonitor shapeDpm = shapePm.toDiscrete(nodeHits.size());
            DiscreteProgressMonitor labelDpm = labelPm.toDiscrete(nodeHits.size());
            while (nodeHits.hasNext()) {
                String text;
                if (pm.isCancelled()) {
                    return;
                }
                View node = nodeHits.nextNodeExtents(floatBuff1);
                shapePm.start("Shape");
                GraphRenderer.renderNodeHigh(netView, grafx, (View<CyNode>)node, floatBuff1, doubleBuff1, doubleBuff2, nodeDetails, flags, dependencies);
                shapeDpm.increment();
                shapePm.done();
                labelPm.start("Label");
                if (flags.has(8) && (text = nodeDetails.getLabelText((View<CyNode>)node)) != null && !text.isEmpty()) {
                    Font font = nodeDetails.getLabelFont((View<CyNode>)node);
                    Paint paint = nodeDetails.getLabelPaint((View<CyNode>)node);
                    Position textAnchor = nodeDetails.getLabelTextAnchor((View<CyNode>)node);
                    Position nodeAnchor = nodeDetails.getLabelNodeAnchor((View<CyNode>)node);
                    float offsetVectorX = nodeDetails.getLabelOffsetVectorX((View<CyNode>)node);
                    float offsetVectorY = nodeDetails.getLabelOffsetVectorY((View<CyNode>)node);
                    double theta = nodeDetails.getLabelRotation((View<CyNode>)node) * 0.01745329252;
                    double nodeLabelWidth = nodeDetails.getLabelWidth((View<CyNode>)node);
                    Justification justify = text.indexOf(10) >= 0 ? nodeDetails.getLabelJustify((View<CyNode>)node) : Justification.JUSTIFY_CENTER;
                    doubleBuff1[0] = floatBuff1[0];
                    doubleBuff1[1] = floatBuff1[1];
                    doubleBuff1[2] = floatBuff1[2];
                    doubleBuff1[3] = floatBuff1[3];
                    GraphRenderer.computeAnchor(nodeAnchor, doubleBuff1, doubleBuff2);
                    double nodeAnchorPointX = doubleBuff2[0];
                    double nodeAnchorPointY = doubleBuff2[1];
                    LabelInfo labelInfo = labelInfoProvider.getLabelInfo(text, font, nodeLabelWidth, grafx.getFontRenderContextFull());
                    doubleBuff1[0] = -0.5 * labelInfo.getMaxLineWidth();
                    doubleBuff1[1] = -0.5 * labelInfo.getTotalHeight();
                    doubleBuff1[2] = 0.5 * labelInfo.getMaxLineWidth();
                    doubleBuff1[3] = 0.5 * labelInfo.getTotalHeight();
                    GraphRenderer.computeAnchor(textAnchor, doubleBuff1, doubleBuff2);
                    double textXCenter = nodeAnchorPointX - doubleBuff2[0] + (double)offsetVectorX;
                    double textYCenter = nodeAnchorPointY - doubleBuff2[1] + (double)offsetVectorY;
                    GraphRenderer.renderText(grafx, labelInfo, (float)textXCenter, (float)textYCenter, nodeAnchorPointX + (double)offsetVectorX, nodeAnchorPointY + (double)offsetVectorY, justify, paint, theta, flags.has(256));
                }
                labelDpm.increment();
                labelPm.done();
            }
        }
    }

    public static final void renderText(GraphGraphics grafx, LabelInfo measuredText, float textXCenter, float textYCenter, double textXAnchor, double textYAnchor, Justification textJustify, Paint paint, double theta, boolean textAsShape) {
        double currHeight = measuredText.getTotalHeight() / -2.0;
        double overallWidth = measuredText.getMaxLineWidth();
        for (LabelLineInfo line : measuredText.getMeasuredLines()) {
            double xCenter;
            double yCenter = currHeight + (double)textYCenter + line.getHeight() / 2.0;
            if (textJustify == Justification.JUSTIFY_CENTER) {
                xCenter = textXCenter;
            } else if (textJustify == Justification.JUSTIFY_LEFT) {
                xCenter = -0.5 * (overallWidth - line.getWidth()) + (double)textXCenter;
            } else if (textJustify == Justification.JUSTIFY_RIGHT) {
                xCenter = 0.5 * (overallWidth - line.getWidth()) + (double)textXCenter;
            } else {
                throw new IllegalStateException("textJustify value unrecognized");
            }
            grafx.drawTextFull(line, (float)xCenter, (float)yCenter, textXAnchor, textYAnchor, (float)theta, paint, textAsShape);
            currHeight += line.getHeight();
        }
    }

    public static final void computeAnchor(Position anchor, double[] input4x, double[] rtrn2x) {
        switch (anchor) {
            case CENTER: {
                rtrn2x[0] = (input4x[0] + input4x[2]) / 2.0;
                rtrn2x[1] = (input4x[1] + input4x[3]) / 2.0;
                break;
            }
            case SOUTH: {
                rtrn2x[0] = (input4x[0] + input4x[2]) / 2.0;
                rtrn2x[1] = input4x[3];
                break;
            }
            case SOUTH_EAST: {
                rtrn2x[0] = input4x[2];
                rtrn2x[1] = input4x[3];
                break;
            }
            case EAST: {
                rtrn2x[0] = input4x[2];
                rtrn2x[1] = (input4x[1] + input4x[3]) / 2.0;
                break;
            }
            case NORTH_EAST: {
                rtrn2x[0] = input4x[2];
                rtrn2x[1] = input4x[1];
                break;
            }
            case NORTH: {
                rtrn2x[0] = (input4x[0] + input4x[2]) / 2.0;
                rtrn2x[1] = input4x[1];
                break;
            }
            case NORTH_WEST: {
                rtrn2x[0] = input4x[0];
                rtrn2x[1] = input4x[1];
                break;
            }
            case WEST: {
                rtrn2x[0] = input4x[0];
                rtrn2x[1] = (input4x[1] + input4x[3]) / 2.0;
                break;
            }
            case SOUTH_WEST: {
                rtrn2x[0] = input4x[0];
                rtrn2x[1] = input4x[3];
                break;
            }
            default: {
                throw new IllegalStateException("encoutered an invalid ANCHOR_* constant: " + anchor);
            }
        }
    }

    public static final void computeEdgeEndpointsHaystack(float[] srcNodeExtents, float[] trgNodeExtents, long srcSuid, long trgSuid, long edgeSuid, float radiusModifier, EdgeStacking stacking, float[] rtnValSrc, float[] rtnValTrg, byte[] dataBuff) {
        float x0 = (srcNodeExtents[0] + srcNodeExtents[2]) / 2.0f;
        float y0 = (srcNodeExtents[1] + srcNodeExtents[3]) / 2.0f;
        float x1 = (trgNodeExtents[2] + trgNodeExtents[0]) / 2.0f;
        float y1 = (trgNodeExtents[3] + trgNodeExtents[1]) / 2.0f;
        float srcWidth = srcNodeExtents[2] - srcNodeExtents[0];
        float srcHeight = srcNodeExtents[3] - srcNodeExtents[1];
        float srcRadius = Math.min(srcWidth, srcHeight) / 2.0f * 0.9f * radiusModifier;
        float trgWidth = trgNodeExtents[2] - trgNodeExtents[0];
        float trgHeight = trgNodeExtents[3] - trgNodeExtents[1];
        float trgRadius = Math.min(trgWidth, trgHeight) / 2.0f * 0.9f * radiusModifier;
        GraphRenderer.crossHaystackEndpoint(x0, y0, srcRadius, rtnValSrc, dataBuff, srcSuid, edgeSuid, radiusModifier);
        GraphRenderer.crossHaystackEndpoint(x1, y1, trgRadius, rtnValTrg, dataBuff, trgSuid, edgeSuid, radiusModifier);
    }

    private static final void crossHaystackEndpoint(float centerX, float centerY, float radius, float[] rtnVal, byte[] dataBuff, long nodeSuid, long edgeSuid, float radiusModifier) {
        float h1 = GraphRenderer.hashSuids(dataBuff, nodeSuid, edgeSuid, 99);
        double theta = (double)h1 * Math.PI * 2.0;
        double x = (double)centerX + Math.cos(theta) * (double)radius;
        double y = (double)centerY + Math.sin(theta) * (double)radius;
        rtnVal[0] = (float)x;
        rtnVal[1] = (float)y;
    }

    private static void longToBytes(long l, byte[] buff, int offset) {
        for (int i = offset + 7; i >= offset; --i) {
            buff[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    private static float hashSuids(byte[] dataBuff, long nodeSuid, long edgeSuid, int seed) {
        GraphRenderer.longToBytes(nodeSuid, dataBuff, 0);
        GraphRenderer.longToBytes(edgeSuid, dataBuff, 8);
        int hash = MurmurHash3.murmurhash3_x86_32(dataBuff, 0, dataBuff.length, seed);
        float r = Math.abs((float)hash / 2.1474836E9f);
        return r;
    }

    public static final void computeEdgeEndpoints(float[] srcNodeExtents, byte srcNodeShape, ArrowShape srcArrow, float srcArrowSize, EdgeAnchors anchors, float[] trgNodeExtents, byte trgNodeShape, ArrowShape trgArrow, float trgArrowSize, float[] rtnValSrc, float[] rtnValTrg) {
        float trgYOut;
        float trgXOut;
        float srcYOut;
        float srcXOut;
        float srcX = (float)(((double)srcNodeExtents[0] + (double)srcNodeExtents[2]) / 2.0);
        float srcY = (float)(((double)srcNodeExtents[1] + (double)srcNodeExtents[3]) / 2.0);
        float trgX = (float)(((double)trgNodeExtents[0] + (double)trgNodeExtents[2]) / 2.0);
        float trgY = (float)(((double)trgNodeExtents[1] + (double)trgNodeExtents[3]) / 2.0);
        float[] floatBuff = new float[2];
        if (anchors != null && anchors.numAnchors() == 0) {
            anchors = null;
        }
        if (anchors == null) {
            srcXOut = trgX;
            srcYOut = trgY;
            trgXOut = srcX;
            trgYOut = srcY;
        } else {
            anchors.getAnchor(0, floatBuff);
            srcXOut = floatBuff[0];
            srcYOut = floatBuff[1];
            anchors.getAnchor(anchors.numAnchors() - 1, floatBuff);
            trgXOut = floatBuff[0];
            trgYOut = floatBuff[1];
        }
        GraphRenderer.calcIntersection(srcNodeShape, srcNodeExtents, srcX, srcY, srcXOut, srcYOut, floatBuff);
        float srcXAdj = floatBuff[0];
        float srcYAdj = floatBuff[1];
        GraphRenderer.calcIntersection(trgNodeShape, trgNodeExtents, trgX, trgY, trgXOut, trgYOut, floatBuff);
        float trgXAdj = floatBuff[0];
        float trgYAdj = floatBuff[1];
        rtnValSrc[0] = srcXAdj;
        rtnValSrc[1] = srcYAdj;
        rtnValTrg[0] = trgXAdj;
        rtnValTrg[1] = trgYAdj;
    }

    private static void calcIntersection(byte nodeShape, float[] nodeExtents, float x, float y, float xOut, float yOut, float[] retVal) {
        if (nodeExtents[0] == nodeExtents[2] || nodeExtents[1] == nodeExtents[3]) {
            retVal[0] = x;
            retVal[1] = y;
        } else if (!GraphGraphics.computeEdgeIntersection(nodeShape, nodeExtents[0], nodeExtents[1], nodeExtents[2], nodeExtents[3], 0.0f, xOut, yOut, retVal)) {
            float newYOut;
            float newXOut;
            double xCenter = ((double)nodeExtents[0] + (double)nodeExtents[2]) / 2.0;
            double yCenter = ((double)nodeExtents[1] + (double)nodeExtents[3]) / 2.0;
            double desiredDist = Math.max((double)nodeExtents[2] - (double)nodeExtents[0], (double)nodeExtents[3] - (double)nodeExtents[1]);
            double dX = (double)xOut - xCenter;
            double dY = (double)yOut - yCenter;
            double len = Math.sqrt(dX * dX + dY * dY);
            if (len == 0.0) {
                newXOut = (float)((double)xOut + desiredDist);
                newYOut = yOut;
            } else {
                newXOut = (float)(dX / len * desiredDist + (double)xOut);
                newYOut = (float)(dY / len * desiredDist + (double)yOut);
            }
            GraphGraphics.computeEdgeIntersection(nodeShape, nodeExtents[0], nodeExtents[1], nodeExtents[2], nodeExtents[3], 0.0f, newXOut, newYOut, retVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void computeClosedPath(PathIterator origPath, GeneralPath rtnVal) {
        float[] fArray = s_floatTemp;
        synchronized (s_floatTemp) {
            int i;
            int segs = 0;
            int offset = 0;
            GraphRenderer.s_segTypeBuff[segs++] = origPath.currentSegment(s_floatTemp);
            if (GraphRenderer.s_segTypeBuff[segs++] != 0) {
                throw new IllegalStateException("expected a SEG_MOVETO at the beginning of origPath");
            }
            for (i = 0; i < 2; ++i) {
                GraphRenderer.s_floatBuff2[offset++] = s_floatTemp[i];
            }
            origPath.next();
            while (!origPath.isDone()) {
                int segType = origPath.currentSegment(s_floatTemp);
                GraphRenderer.s_segTypeBuff[segs++] = segType;
                if (segType == 0 || segType == 4) {
                    throw new IllegalStateException("did not expect SEG_MOVETO or SEG_CLOSE");
                }
                int coordCount = segType * 2;
                for (int i2 = 0; i2 < coordCount; ++i2) {
                    GraphRenderer.s_floatBuff2[offset++] = s_floatTemp[i2];
                }
                origPath.next();
            }
            rtnVal.reset();
            offset = 0;
            block15: for (i = 0; i < segs; ++i) {
                switch (s_segTypeBuff[i]) {
                    case 0: {
                        rtnVal.moveTo(s_floatBuff2[offset++], s_floatBuff2[offset++]);
                        continue block15;
                    }
                    case 1: {
                        rtnVal.lineTo(s_floatBuff2[offset++], s_floatBuff2[offset++]);
                        continue block15;
                    }
                    case 2: {
                        rtnVal.quadTo(s_floatBuff2[offset++], s_floatBuff2[offset++], s_floatBuff2[offset++], s_floatBuff2[offset++]);
                        continue block15;
                    }
                    default: {
                        rtnVal.curveTo(s_floatBuff2[offset++], s_floatBuff2[offset++], s_floatBuff2[offset++], s_floatBuff2[offset++], s_floatBuff2[offset++], s_floatBuff2[offset++]);
                    }
                }
            }
            block16: for (i = segs - 1; i > 0; --i) {
                switch (s_segTypeBuff[i]) {
                    case 1: {
                        rtnVal.lineTo(s_floatBuff2[(offset -= 2) - 2], s_floatBuff2[offset - 1]);
                        continue block16;
                    }
                    case 2: {
                        rtnVal.quadTo(s_floatBuff2[offset -= 4], s_floatBuff2[offset + 1], s_floatBuff2[offset - 2], s_floatBuff2[offset - 1]);
                        continue block16;
                    }
                    default: {
                        rtnVal.curveTo(s_floatBuff2[(offset -= 6) + 2], s_floatBuff2[offset + 3], s_floatBuff2[offset], s_floatBuff2[offset + 1], s_floatBuff2[offset - 2], s_floatBuff2[offset - 1]);
                    }
                }
            }
            rtnVal.closePath();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static final boolean _computeEdgeIntersection(float nodeX, float nodeY, float offset, float ptX, float ptY, boolean alwaysCompute, float[] returnVal) {
        if (offset == 0.0f) {
            returnVal[0] = nodeX;
            returnVal[1] = nodeY;
            return true;
        }
        double dX = ptX - nodeX;
        double dY = ptY - nodeY;
        double len = Math.sqrt(dX * dX + dY * dY);
        if (len < (double)offset) {
            if (!alwaysCompute) {
                return false;
            }
            if (len == 0.0) {
                returnVal[0] = offset + nodeX;
                returnVal[1] = nodeY;
                return true;
            }
        }
        returnVal[0] = (float)(dX / len * (double)offset + (double)nodeX);
        returnVal[1] = (float)(dY / len * (double)offset + (double)nodeY);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void renderNodeHigh(CyNetworkViewSnapshot netView, GraphGraphics grafx, View<CyNode> cyNode, float[] floatBuff1, double[] doubleBuff1, double[] doubleBuff2, NodeDetails nodeDetails, RenderDetailFlags flags, Set<VisualPropertyDependency<?>> dependencies) {
        Shape nodeShape = null;
        if (floatBuff1[0] != floatBuff1[2] && floatBuff1[1] != floatBuff1[3]) {
            Paint borderPaint;
            float borderWidth;
            byte shape = nodeDetails.getShape(cyNode);
            Paint fillPaint = nodeDetails.getFillPaint(cyNode);
            Stroke borderStroke = null;
            if (flags.not(4)) {
                borderWidth = 0.0f;
                borderPaint = null;
            } else {
                borderWidth = nodeDetails.getBorderWidth(cyNode);
                borderStroke = nodeDetails.getBorderStroke(cyNode);
                borderPaint = borderWidth == 0.0f ? null : nodeDetails.getBorderPaint(cyNode);
            }
            nodeShape = grafx.drawNodeFull(shape, floatBuff1[0], floatBuff1[1], floatBuff1[2], floatBuff1[3], fillPaint, borderWidth, borderStroke, borderPaint);
        }
        if (flags.has(512)) {
            TexturePaint nestedNetworkPaint = nodeDetails.getNestedNetworkTexturePaint(netView, cyNode);
            if (nestedNetworkPaint != null) {
                doubleBuff1[0] = floatBuff1[0];
                doubleBuff1[1] = floatBuff1[1];
                doubleBuff1[2] = floatBuff1[2];
                doubleBuff1[3] = floatBuff1[3];
                GraphRenderer.computeAnchor(Position.CENTER, doubleBuff1, doubleBuff2);
                grafx.drawCustomGraphicImage(nestedNetworkPaint.getAnchorRect(), (float)doubleBuff2[0], (float)doubleBuff2[1], nestedNetworkPaint);
            }
            NodeDetails nodeDetails2 = nodeDetails;
            synchronized (nodeDetails2) {
                Map<VisualProperty<CyCustomGraphics>, CustomGraphicsInfo> cgMap = nodeDetails.getCustomGraphics(cyNode);
                ArrayList<CustomGraphicsInfo> infoList = new ArrayList<CustomGraphicsInfo>(cgMap.values());
                for (CustomGraphicsInfo cgInfo : infoList) {
                    CyNetworkView netViewForCharts = netView.getMutableNetworkView();
                    View mutableNode = netView.getMutableNodeView(cyNode.getSUID().longValue());
                    if (mutableNode == null) continue;
                    List<CustomGraphicLayer> layers = cgInfo.createLayers(netViewForCharts, (View<CyNode>)mutableNode, nodeDetails, dependencies);
                    for (CustomGraphicLayer layer : layers) {
                        float offsetVectorX = nodeDetails.graphicOffsetVectorX(cyNode);
                        float offsetVectorY = nodeDetails.graphicOffsetVectorY(cyNode);
                        doubleBuff1[0] = floatBuff1[0];
                        doubleBuff1[1] = floatBuff1[1];
                        doubleBuff1[2] = floatBuff1[2];
                        doubleBuff1[3] = floatBuff1[3];
                        GraphRenderer.computeAnchor(Position.CENTER, doubleBuff1, doubleBuff2);
                        float xOffset = (float)(doubleBuff2[0] + (double)offsetVectorX);
                        float yOffset = (float)(doubleBuff2[1] + (double)offsetVectorY);
                        nodeShape = GraphRenderer.createCustomGraphicsShape(nodeShape, layer, -xOffset, -yOffset);
                        grafx.drawCustomGraphicFull(netViewForCharts, (View<CyNode>)mutableNode, nodeShape, layer, xOffset, yOffset);
                    }
                }
            }
        }
    }

    private static Shape createCustomGraphicsShape(Shape nodeShape, CustomGraphicLayer layer, float xOffset, float yOffset) {
        Rectangle2D nsb = nodeShape.getBounds2D();
        Rectangle2D cgb = layer.getBounds2D();
        AffineTransform xform = new AffineTransform();
        xform.scale(cgb.getWidth() / nsb.getWidth(), cgb.getHeight() / nsb.getHeight());
        xform.translate(xOffset, yOffset);
        return xform.createTransformedShape(nodeShape);
    }
}

