/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.work;

import org.cytoscape.ding.impl.work.ProgressMonitor;

public class ConsoleProgressMonitor
implements ProgressMonitor {
    private final String name;
    private boolean cancelled = false;
    private double currentProgress = 0.0;

    public ConsoleProgressMonitor(String name) {
        this.name = name;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.println("cancelled");
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void start(String taskName) {
        this.println("started " + taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProgress(double progress) {
        ConsoleProgressMonitor consoleProgressMonitor = this;
        synchronized (consoleProgressMonitor) {
            this.currentProgress = Math.max(0.0, Math.min(1.0, this.currentProgress + progress));
        }
        if (this.currentProgress >= 1.0) {
            this.println("done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        ConsoleProgressMonitor consoleProgressMonitor = this;
        synchronized (consoleProgressMonitor) {
            this.currentProgress = 1.0;
        }
        this.println("donezo");
    }

    private void println(String message) {
        System.out.print(this.name);
        System.out.print(": ");
        System.out.println(message);
    }
}

