/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.undo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class CompositeCyEdit<T extends AbstractCyEdit> {
    private final String compositeName;
    private final List<T> children;
    private final CyServiceRegistrar registrar;

    public CompositeCyEdit(String name, CyServiceRegistrar registrar, int initialCapacity) {
        this.compositeName = name;
        this.registrar = registrar;
        this.children = new ArrayList<T>(initialCapacity);
    }

    public CompositeCyEdit<T> add(T edit) {
        if (edit != null) {
            this.children.add(edit);
        }
        return this;
    }

    public Collection<T> getChildren() {
        return this.children;
    }

    public void post() {
        String name = this.children.size() == 1 ? ((AbstractCyEdit)this.children.get(0)).getPresentationName() : this.compositeName;
        AbstractCyEdit edit = new AbstractCyEdit(name){

            public void undo() {
                CompositeCyEdit.this.children.forEach(AbstractCyEdit::undo);
            }

            public void redo() {
                CompositeCyEdit.this.children.forEach(AbstractCyEdit::redo);
            }
        };
        ((UndoSupport)this.registrar.getService(UndoSupport.class)).postEdit(edit);
    }
}

