/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.undo;

import java.util.List;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class AnnotationEdit
extends AbstractCyEdit {
    private final CyAnnotator annotator;
    private final CyServiceRegistrar registrar;
    private List<String> oldState;
    private List<String> newState;

    public AnnotationEdit(String label, DRenderingEngine re) {
        this(label, re.getCyAnnotator(), re.getServiceRegistrar());
    }

    public AnnotationEdit(String label, CyAnnotator annotator, CyServiceRegistrar registrar) {
        super(label);
        this.annotator = annotator;
        this.registrar = registrar;
        this.saveOldAnnotations();
    }

    private void saveOldAnnotations() {
        this.oldState = this.annotator.createSavableNetworkAttribute();
    }

    public void saveNewAnnotations() {
        this.newState = this.annotator.createSavableNetworkAttribute();
    }

    public void post() {
        this.saveNewAnnotations();
        if (!this.oldState.equals(this.newState)) {
            ((UndoSupport)this.registrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)this);
        }
    }

    public void undo() {
        this.restore(this.oldState);
    }

    public void redo() {
        this.restore(this.newState);
    }

    private void restore(List<String> state) {
        if (state != null) {
            List<DingAnnotation> annotations = this.annotator.getAnnotations();
            this.annotator.removeAnnotations(annotations);
            this.annotator.loadAnnotations(state);
        }
    }
}

