/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.strokes;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.cytoscape.ding.impl.strokes.ShapeStroke;
import org.cytoscape.ding.impl.strokes.WidthStroke;

public class SineWaveStroke
extends ShapeStroke {
    private static final float wavelength = 20.0f;
    private static final float amplitude = 10.0f;

    public SineWaveStroke(float width) {
        super(new Shape[]{SineWaveStroke.getSineWave(width)}, 20.0f, width);
    }

    @Override
    public WidthStroke newInstanceForWidth(float w) {
        return new SineWaveStroke(w);
    }

    private static Shape getSineWave(float width) {
        GeneralPath shape = new GeneralPath();
        shape.moveTo(0.0f, 0.0f);
        shape.lineTo(0.0f, width);
        shape.quadTo(5.0f, 10.0f + width, 10.0f, width);
        shape.quadTo(15.0f, -10.0f - width, 20.0f, width);
        shape.lineTo(20.0f, 0.0f);
        shape.quadTo(15.0f, -10.0f - width, 10.0f, 0.0f);
        shape.quadTo(5.0f, 10.0f + width, 0.0f, 0.0f);
        return shape;
    }
}

