/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.strokes;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.cytoscape.ding.impl.strokes.ShapeStroke;
import org.cytoscape.ding.impl.strokes.WidthStroke;

public class SeparateArrowStroke
extends ShapeStroke {
    public SeparateArrowStroke(float width) {
        super(new Shape[]{SeparateArrowStroke.getArrowStroke(width)}, 5.0f * width, width);
    }

    @Override
    public WidthStroke newInstanceForWidth(float w) {
        return new SeparateArrowStroke(w);
    }

    private static Shape getArrowStroke(float width) {
        GeneralPath shape = new GeneralPath();
        float length = 4.0f * width;
        float lineWidth = width;
        float arrowWidth = 3.0f * width;
        float arrowHeadStart = length / 2.0f;
        float begin = 0.0f;
        float halfLineWidth = 0.5f * lineWidth;
        float halfArrowWidth = 0.5f * arrowWidth;
        shape.moveTo(begin, halfLineWidth);
        shape.lineTo(arrowHeadStart, halfLineWidth);
        shape.lineTo(arrowHeadStart, halfArrowWidth);
        shape.lineTo(length, 0.0f);
        shape.lineTo(arrowHeadStart, -halfArrowWidth);
        shape.lineTo(arrowHeadStart, -halfLineWidth);
        shape.lineTo(begin, -halfLineWidth);
        shape.lineTo(begin, halfLineWidth);
        return shape;
    }
}

