/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.strokes;

import java.awt.BasicStroke;
import org.cytoscape.ding.impl.strokes.DAnimatedStroke;
import org.cytoscape.ding.impl.strokes.WidthStroke;

public class AnimatedEqualDashStroke
extends BasicStroke
implements DAnimatedStroke {
    private final float width;
    private final float offset;

    public AnimatedEqualDashStroke(float width) {
        super(width, 0, 0, 10.0f, new float[]{width * 2.0f, width * 2.0f}, 0.0f);
        this.width = width;
        this.offset = -1.0f;
    }

    public AnimatedEqualDashStroke(float width, float offset) {
        super(width, 0, 0, 10.0f, new float[]{width * 2.0f, width * 2.0f}, width * 4.0f * offset);
        this.width = width;
        this.offset = offset;
    }

    @Override
    public WidthStroke newInstanceForWidth(float w) {
        if (this.offset >= 0.0f) {
            return new AnimatedEqualDashStroke(w, this.offset);
        }
        return new AnimatedEqualDashStroke(w);
    }

    @Override
    public DAnimatedStroke newInstanceForNextOffset() {
        float stepSize = 0.25f;
        float newOffset = this.offset - stepSize;
        if (newOffset < 0.0f) {
            newOffset = 1.0f - stepSize;
        }
        return new AnimatedEqualDashStroke(this.width, newOffset);
    }

    @Override
    public float getOffset() {
        return this.offset;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + Float.toString(this.width);
    }
}

