/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.utils;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.Icon;

public class ShapeIcon
implements Icon {
    private final Shape shape;
    private final int width;
    private final int height;

    public ShapeIcon(Shape shape, int width, int height) {
        this.shape = shape;
        this.width = width;
        this.height = height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g2.setPaint(c.getForeground());
        g2.setStroke(new BasicStroke(1.0f));
        Rectangle sb = this.shape.getBounds();
        g2.translate((double)x + ((double)this.width - sb.getWidth()) / 2.0, (double)y + ((double)this.height - sb.getHeight()) / 2.0);
        g2.draw(this.shape);
        g2.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

