/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.tasks.AnnotationJsonConverter;
import org.cytoscape.ding.impl.cyannotator.tasks.ImageAnnotationTunables;
import org.cytoscape.ding.impl.cyannotator.tasks.ShapeAnnotationTunables;
import org.cytoscape.ding.impl.cyannotator.tasks.StandardAnnotationTunables;
import org.cytoscape.ding.impl.cyannotator.tasks.TextAnnotationTunables;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;
import org.cytoscape.view.presentation.annotations.BoundedTextAnnotation;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;
import org.cytoscape.view.presentation.annotations.ImageAnnotation;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class UpdateAnnotationTask
extends AbstractTask
implements ObservableTask {
    private final AnnotationManager annotationManager;
    private final CyNetworkViewManager viewManager;
    private final Class<? extends Annotation> type;
    private Annotation updatedAnnotation;
    @Tunable(context="nogui", required=true, description="The UUID or name of the annotation to be updated")
    public String uuidOrName;
    @ContainsTunables
    public StandardAnnotationTunables standardTunables = null;
    @ContainsTunables
    public TextAnnotationTunables textTunables = null;
    @ContainsTunables
    public ShapeAnnotationTunables shapeTunables = null;
    @ContainsTunables
    public ImageAnnotationTunables imageTunables = null;

    public UpdateAnnotationTask(Class<? extends Annotation> type, AnnotationManager annotationManager, CyNetworkViewManager viewManager) {
        this.annotationManager = annotationManager;
        this.viewManager = viewManager;
        this.type = type;
        if (type.equals(ImageAnnotation.class)) {
            this.standardTunables = new StandardAnnotationTunables();
            this.shapeTunables = new ShapeAnnotationTunables();
            this.imageTunables = new ImageAnnotationTunables();
        } else if (type.equals(BoundedTextAnnotation.class)) {
            this.standardTunables = new StandardAnnotationTunables();
            this.textTunables = new TextAnnotationTunables();
            this.shapeTunables = new ShapeAnnotationTunables();
        } else if (type.equals(TextAnnotation.class)) {
            this.standardTunables = new StandardAnnotationTunables();
            this.textTunables = new TextAnnotationTunables();
        } else if (type.equals(ShapeAnnotation.class)) {
            this.standardTunables = new StandardAnnotationTunables();
            this.shapeTunables = new ShapeAnnotationTunables();
        } else if (!type.equals(ArrowAnnotation.class) && type.equals(GroupAnnotation.class)) {
            this.standardTunables = new StandardAnnotationTunables();
        }
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Update Annotation");
        UUID aUUID = null;
        String name = null;
        try {
            aUUID = UUID.fromString(this.uuidOrName);
        }
        catch (IllegalArgumentException e) {
            name = this.uuidOrName;
        }
        for (CyNetworkView view : this.viewManager.getNetworkViewSet()) {
            for (Annotation annotation : this.annotationManager.getAnnotations(view)) {
                if ((aUUID == null || !annotation.getUUID().equals(aUUID)) && (name == null || !annotation.getName().equals(name))) continue;
                try {
                    this.updateAnnotation(tm, annotation);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.updatedAnnotation = annotation;
                return;
            }
        }
        tm.setStatusMessage("Can't find an annotation with UUID " + this.uuidOrName);
    }

    private void updateAnnotation(TaskMonitor tm, Annotation annotation) {
        if (this.type.equals(ImageAnnotation.class)) {
            this.standardTunables.update(tm, annotation);
            this.shapeTunables.update(tm, annotation);
            this.imageTunables.update(tm, annotation);
        } else if (this.type.equals(BoundedTextAnnotation.class)) {
            this.standardTunables.update(tm, annotation);
            this.shapeTunables.update(tm, annotation);
            this.textTunables.update(tm, annotation);
        } else if (this.type.equals(TextAnnotation.class)) {
            this.standardTunables.update(tm, annotation);
            this.textTunables.update(tm, annotation);
        } else if (this.type.equals(ShapeAnnotation.class)) {
            this.standardTunables.update(tm, annotation);
            this.shapeTunables.update(tm, annotation);
        } else if (this.type.equals(GroupAnnotation.class)) {
            this.standardTunables.update(tm, annotation);
        }
        annotation.update();
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class, String.class, Annotation.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(Annotation.class)) {
            return (R)this.updatedAnnotation;
        }
        if (type.equals(String.class)) {
            Object result = this.updatedAnnotation == null ? "Nothing added" : "Updated annotation " + this.updatedAnnotation.toString();
            return (R)result;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.updatedAnnotation == null) {
                    return "{}";
                }
                return AnnotationJsonConverter.toJson((DingAnnotation)this.updatedAnnotation);
            };
            return (R)res;
        }
        return null;
    }
}

