/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.awt.geom.Point2D;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.annotations.GroupAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.tasks.UngroupAnnotationsTask;
import org.cytoscape.task.NetworkViewLocationTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;

public class UngroupAnnotationsTaskFactory
implements NetworkViewLocationTaskFactory,
TaskFactory {
    private final AnnotationManager annotationManager;
    private final CyNetworkViewManager viewManager;
    private final DingRenderer dingRenderer;
    private final RenderingEngineManager reManager;

    public UngroupAnnotationsTaskFactory(DingRenderer dingRenderer) {
        this.dingRenderer = dingRenderer;
        this.annotationManager = null;
        this.reManager = null;
        this.viewManager = null;
    }

    public UngroupAnnotationsTaskFactory(AnnotationManager annotationManager, RenderingEngineManager reManager, CyNetworkViewManager viewManager) {
        this.annotationManager = annotationManager;
        this.reManager = reManager;
        this.viewManager = viewManager;
        this.dingRenderer = null;
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{new UngroupAnnotationsTask(this.annotationManager, this.reManager, this.viewManager)});
    }

    public boolean isReady() {
        return true;
    }

    public TaskIterator createTaskIterator(CyNetworkView networkView, Point2D javaPt, Point2D xformPt) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(networkView);
        if (re == null) {
            return null;
        }
        DingAnnotation annotation = re.getPicker().getAnnotationAt(javaPt);
        return new TaskIterator(new Task[]{new UngroupAnnotationsTask(re, annotation)});
    }

    public boolean isReady(CyNetworkView networkView, Point2D javaPt, Point2D xformPt) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(networkView);
        if (re == null) {
            return false;
        }
        DingAnnotation annotation = re.getPicker().getAnnotationAt(javaPt);
        return annotation != null && annotation instanceof GroupAnnotationImpl;
    }
}

